/*
 * Decompiled with CFR 0.152.
 */
package studio.magemonkey.codex.config.legacy;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import org.bukkit.configuration.InvalidConfigurationException;
import org.bukkit.configuration.file.FileConfiguration;
import org.bukkit.configuration.file.YamlConfiguration;
import org.jetbrains.annotations.Nullable;

public class LegacyConfigManager {
    public static FileConfiguration loadConfigFile(File file, @Nullable InputStream defaultFile) {
        return LegacyConfigManager.loadConfigFile(file, defaultFile, true);
    }

    public static FileConfiguration loadConfigFile(File file, InputStream defaultFile, boolean copyMissing) {
        YamlConfiguration defConfig = new YamlConfiguration();
        if (defaultFile != null) {
            try {
                defConfig.load((Reader)new InputStreamReader(defaultFile));
            }
            catch (IOException | InvalidConfigurationException e) {
                e.printStackTrace();
            }
        }
        file.getParentFile().mkdirs();
        if (!file.exists()) {
            try {
                file.createNewFile();
                defConfig.save(file);
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        YamlConfiguration conf = new YamlConfiguration();
        try {
            conf.load(file);
            if (copyMissing) {
                conf.addDefaults(defConfig.getConfigurationSection("").getValues(true));
                conf.options().copyDefaults(true);
                conf.save(file);
            }
        }
        catch (IOException | InvalidConfigurationException e) {
            e.printStackTrace();
        }
        return conf;
    }
}

