/*
 * Decompiled with CFR 0.152.
 */
package studio.magemonkey.codex.data.users;

import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import org.bukkit.entity.Entity;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.player.AsyncPlayerPreLoginEvent;
import org.bukkit.event.player.PlayerJoinEvent;
import org.bukkit.event.player.PlayerQuitEvent;
import org.bukkit.plugin.Plugin;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import studio.magemonkey.codex.CodexDataPlugin;
import studio.magemonkey.codex.CodexEngine;
import studio.magemonkey.codex.CodexPlugin;
import studio.magemonkey.codex.data.event.EngineUserCreatedEvent;
import studio.magemonkey.codex.data.event.EngineUserLoadEvent;
import studio.magemonkey.codex.data.event.EngineUserUnloadEvent;
import studio.magemonkey.codex.data.users.IAbstractUser;
import studio.magemonkey.codex.hooks.Hooks;
import studio.magemonkey.codex.manager.IManager;
import studio.magemonkey.codex.manager.api.task.ITask;

public abstract class IUserManager<P extends CodexDataPlugin<P, U>, U extends IAbstractUser<P>>
extends IManager<P> {
    private Map<String, U> activeUsers;
    private Set<U> toSave;
    private SaveTask saveTask;
    private Set<UUID> isPassJoin;
    private Set<UUID> toCreate;

    public IUserManager(@NotNull P plugin) {
        super(plugin);
    }

    @Override
    public void setup() {
        this.activeUsers = new HashMap<String, U>();
        this.toSave = ConcurrentHashMap.newKeySet();
        this.isPassJoin = ConcurrentHashMap.newKeySet();
        this.toCreate = ConcurrentHashMap.newKeySet();
        this.registerListeners();
        this.saveTask = new SaveTask(this, (CodexDataPlugin)this.plugin);
        this.saveTask.start();
    }

    @Override
    public void shutdown() {
        this.unregisterListeners();
        if (this.saveTask != null) {
            this.saveTask.stop();
            this.saveTask = null;
        }
        this.autosave();
        this.activeUsers.clear();
        this.isPassJoin.clear();
        this.toCreate.clear();
    }

    public void loadOnlineUsers() {
        for (Player p : ((CodexDataPlugin)this.plugin).getServer().getOnlinePlayers()) {
            if (p == null) continue;
            this.getOrLoadUser(p);
        }
    }

    public void autosave() {
        int cacheFixCount = 0;
        for (IAbstractUser userOn : new HashSet<U>(this.getActiveUsers())) {
            if (!userOn.isOnline()) {
                this.toSave.add(userOn);
                this.activeUsers.remove(userOn.getUUID().toString());
                ++cacheFixCount;
                continue;
            }
            this.save(userOn);
        }
        int on = this.activeUsers.size();
        int off = this.toSave.size();
        this.toSave.forEach(userOff -> this.save(userOff));
        this.toSave.clear();
        ((CodexDataPlugin)this.plugin).info("Auto-save: Saved " + on + " online users | " + off + " offline users.");
        if (cacheFixCount > 0) {
            ((CodexDataPlugin)this.plugin).info("Saved and cleaned " + cacheFixCount + " offline loaded users.");
        }
    }

    public void save(@NotNull U user, boolean async) {
        if (async) {
            ((CodexDataPlugin)this.plugin).getServer().getScheduler().runTaskAsynchronously((Plugin)this.plugin, () -> this.save(user));
            return;
        }
        this.save(user);
    }

    public void save(@NotNull U user) {
        ((CodexDataPlugin)this.plugin).getData().saveUser(user);
    }

    @NotNull
    protected abstract U createData(@NotNull Player var1);

    @Nullable
    public U getOrLoadUser(@NotNull Player player) {
        if (Hooks.isNPC((Entity)player)) {
            throw new IllegalStateException("Could not load user data from an NPC!");
        }
        U user = this.getOrLoadUser(player.getUniqueId().toString(), true);
        return user;
    }

    @Nullable
    public final U getOrLoadUser(@NotNull String uuid, boolean isId) {
        IAbstractUser<Object> user2;
        Player playerHolder = null;
        if (isId) {
            playerHolder = ((CodexDataPlugin)this.plugin).getServer().getPlayer(UUID.fromString(uuid));
        } else {
            playerHolder = ((CodexDataPlugin)this.plugin).getServer().getPlayer(uuid);
            if (playerHolder != null) {
                isId = true;
                uuid = playerHolder.getUniqueId().toString();
            }
            for (Object userOff : this.getActiveUsers()) {
                if (!((IAbstractUser)userOff).getName().equalsIgnoreCase(uuid)) continue;
                return (U)userOff;
            }
        }
        IAbstractUser<Object> user = (IAbstractUser)this.activeUsers.get(uuid);
        if (user != null) {
            return (U)user;
        }
        for (IAbstractUser userOff : this.toSave) {
            if (!userOff.getUUID().toString().equalsIgnoreCase(uuid) && !userOff.getName().equalsIgnoreCase(uuid)) continue;
            this.toSave.remove(userOff);
            this.activeUsers.put(userOff.getUUID().toString(), userOff);
            return (U)userOff;
        }
        user = ((CodexDataPlugin)this.plugin).getData().getUser(uuid, isId);
        if (user != null) {
            user2 = user;
            this.activeUsers.put(user.getUUID().toString(), user2);
            if (this.isPassJoin.remove(user2.getUUID())) {
                ((CodexDataPlugin)this.plugin).getServer().getScheduler().runTask((Plugin)this.plugin, () -> {
                    this.onUserLoad(user2);
                    EngineUserLoadEvent<CodexDataPlugin, IAbstractUser> event = new EngineUserLoadEvent<CodexDataPlugin, IAbstractUser>((CodexDataPlugin)this.plugin, user2);
                    ((CodexDataPlugin)this.plugin).getPluginManager().callEvent(event);
                });
            }
            return (U)user2;
        }
        if (playerHolder == null) {
            return null;
        }
        user = this.createData(playerHolder);
        user2 = user;
        ((CodexDataPlugin)this.plugin).getServer().getScheduler().runTask((Plugin)CodexEngine.get(), () -> {
            EngineUserCreatedEvent<CodexDataPlugin, IAbstractUser> event = new EngineUserCreatedEvent<CodexDataPlugin, IAbstractUser>((CodexDataPlugin)this.plugin, user2);
            ((CodexDataPlugin)this.plugin).getPluginManager().callEvent(event);
        });
        ((CodexDataPlugin)this.plugin).info("Created new user data for: '" + uuid + "'");
        ((CodexDataPlugin)this.plugin).getServer().getScheduler().runTaskAsynchronously((Plugin)this.plugin, () -> ((CodexDataPlugin)this.plugin).getData().addUser(user2));
        this.activeUsers.put(uuid, user2);
        this.toCreate.remove(user2.getUUID());
        return (U)user2;
    }

    public final void unloadUser(@NotNull Player player) {
        this.unloadUser(player.getUniqueId().toString());
    }

    public final void unloadUser(@NotNull String uuid) {
        IAbstractUser user = (IAbstractUser)this.activeUsers.get(uuid);
        if (user == null) {
            return;
        }
        this.onUserUnload(user);
        EngineUserUnloadEvent<CodexDataPlugin, IAbstractUser> event = new EngineUserUnloadEvent<CodexDataPlugin, IAbstractUser>((CodexDataPlugin)this.plugin, user);
        ((CodexDataPlugin)this.plugin).getPluginManager().callEvent(event);
        user.setLastOnline(System.currentTimeMillis());
        if (((CodexDataPlugin)this.plugin).cfg().dataSaveInstant) {
            this.save(user, true);
        } else {
            this.toSave.add(user);
        }
        this.activeUsers.remove(uuid);
    }

    @Deprecated
    protected void onUserUnload(@NotNull U user) {
    }

    @Deprecated
    protected void onUserLoad(@NotNull U user) {
    }

    @NotNull
    public Map<String, U> getActiveUsersMap() {
        return this.activeUsers;
    }

    @NotNull
    public Collection<U> getActiveUsers() {
        return this.activeUsers.values();
    }

    @NotNull
    public Set<U> getInactiveUsers() {
        return this.toSave;
    }

    public boolean isLoaded(@NotNull Player player) {
        return this.activeUsers.containsKey(player.getUniqueId().toString());
    }

    @EventHandler(priority=EventPriority.HIGHEST)
    public void onUserLogin(AsyncPlayerPreLoginEvent e) {
        if (e.getLoginResult() != AsyncPlayerPreLoginEvent.Result.ALLOWED) {
            return;
        }
        if (!((CodexDataPlugin)this.plugin).getData().isUserExists(e.getUniqueId().toString(), true)) {
            this.toCreate.add(e.getUniqueId());
            return;
        }
        this.getOrLoadUser(e.getUniqueId().toString(), true);
    }

    @EventHandler(priority=EventPriority.NORMAL)
    public void onUserJoin(PlayerJoinEvent e) {
        Player player = e.getPlayer();
        this.isPassJoin.add(player.getUniqueId());
        if (!this.isLoaded(player) && !this.toCreate.contains(player.getUniqueId())) {
            return;
        }
        U user = this.getOrLoadUser(player);
        if (user == null) {
            return;
        }
        this.onUserLoad(user);
        EngineUserLoadEvent<CodexDataPlugin, U> event = new EngineUserLoadEvent<CodexDataPlugin, U>((CodexDataPlugin)this.plugin, user);
        ((CodexDataPlugin)this.plugin).getPluginManager().callEvent(event);
        this.isPassJoin.remove(((IAbstractUser)user).getUUID());
    }

    @EventHandler(priority=EventPriority.NORMAL)
    public void onUserQuit(PlayerQuitEvent e) {
        Player player = e.getPlayer();
        this.unloadUser(player);
    }

    static class SaveTask
    extends ITask<P> {
        final /* synthetic */ IUserManager this$0;

        SaveTask(P plugin) {
            this.this$0 = this$0;
            super(plugin, ((CodexPlugin)plugin).cfg().dataSaveInterval * 60, true);
        }

        @Override
        public void action() {
            this.this$0.autosave();
        }
    }
}

