/*
 * Decompiled with CFR 0.152.
 */
package studio.magemonkey.codex.hooks;

import java.util.Collections;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import net.citizensnpcs.api.CitizensAPI;
import net.citizensnpcs.api.npc.NPC;
import org.bukkit.entity.Entity;
import org.bukkit.entity.LivingEntity;
import org.bukkit.entity.Player;
import org.bukkit.plugin.Plugin;
import org.jetbrains.annotations.NotNull;
import org.mcmonkey.sentinel.SentinelTrait;
import studio.magemonkey.codex.CodexEngine;
import studio.magemonkey.codex.hooks.external.IMythicHook;
import studio.magemonkey.codex.hooks.external.VaultHK;
import studio.magemonkey.codex.hooks.external.WorldGuardHK;

public class Hooks {
    private static final CodexEngine ENGINE = CodexEngine.get();
    public static final String VAULT = "Vault";
    public static final String CITIZENS = "Citizens";
    public static final String PLACEHOLDER_API = "PlaceholderAPI";
    public static final String MYTHIC_MOBS = "MythicMobs";
    public static final String WORLD_GUARD = "WorldGuard";

    @NotNull
    public static String getPermGroup(@NotNull Player p) {
        VaultHK vault = ENGINE.getVault();
        return vault != null ? vault.getPlayerGroup(p).toLowerCase() : "";
    }

    @NotNull
    public static Set<String> getPermissionGroups(@NotNull Player p) {
        VaultHK vault = ENGINE.getVault();
        return vault != null ? vault.getPlayerGroups(p) : Collections.emptySet();
    }

    public static long getGroupValueLong(@NotNull Player player, @NotNull Map<String, Long> map, boolean isNegaBetter) {
        Set<String> groups = Hooks.getPermissionGroups(player);
        Optional<Map.Entry> opt = map.entrySet().stream().filter(entry -> ((String)entry.getKey()).equalsIgnoreCase("default") || groups.contains(entry.getKey())).sorted((entry1, entry2) -> {
            long val1 = (Long)entry1.getValue();
            long val2 = (Long)entry2.getValue();
            if (isNegaBetter && val2 < 0L) {
                return 1;
            }
            if (isNegaBetter && val1 < 0L) {
                return -1;
            }
            return (int)(val2 - val1);
        }).findFirst();
        return opt.isPresent() ? (Long)opt.get().getValue() : -1L;
    }

    public static int getGroupValueInt(@NotNull Player player, @NotNull Map<String, Integer> map, boolean isNegaBetter) {
        Set<String> groups = Hooks.getPermissionGroups(player);
        Optional<Map.Entry> opt = map.entrySet().stream().filter(entry -> ((String)entry.getKey()).equalsIgnoreCase("default") || groups.contains(entry.getKey())).sorted((entry1, entry2) -> {
            int val1 = (Integer)entry1.getValue();
            int val2 = (Integer)entry2.getValue();
            if (isNegaBetter && val2 < 0) {
                return 1;
            }
            if (isNegaBetter && val1 < 0) {
                return -1;
            }
            return val2 - val1;
        }).findFirst();
        return opt.isPresent() ? (Integer)opt.get().getValue() : -1;
    }

    public static double getGroupValueDouble(@NotNull Player player, @NotNull Map<String, Double> map, boolean isNegaBetter) {
        Set<String> groups = Hooks.getPermissionGroups(player);
        Optional<Map.Entry> opt = map.entrySet().stream().filter(entry -> ((String)entry.getKey()).equalsIgnoreCase("default") || groups.contains(entry.getKey())).sorted((entry1, entry2) -> {
            double val1 = (Double)entry1.getValue();
            double val2 = (Double)entry2.getValue();
            if (isNegaBetter && val2 < 0.0) {
                return 1;
            }
            if (isNegaBetter && val1 < 0.0) {
                return -1;
            }
            return (int)(val2 - val1);
        }).findFirst();
        return opt.isPresent() ? (Double)opt.get().getValue() : -1.0;
    }

    @NotNull
    public static String getPrefix(@NotNull Player p) {
        VaultHK vault = ENGINE.getVault();
        return vault != null ? vault.getPrefix(p) : "";
    }

    @NotNull
    public static String getSuffix(@NotNull Player p) {
        VaultHK vault = ENGINE.getVault();
        return vault != null ? vault.getSuffix(p) : "";
    }

    public static boolean isNPC(@NotNull Entity e) {
        return Hooks.hasPlugin(CITIZENS) && CitizensAPI.getNPCRegistry().isNPC(e);
    }

    public static boolean isMythic(@NotNull Entity e) {
        IMythicHook mobsHK = ENGINE.getMythicMobs();
        return mobsHK != null && mobsHK.isMythicMob(e);
    }

    public static boolean hasPlugin(@NotNull String plugin) {
        Plugin p = ENGINE.getPluginManager().getPlugin(plugin);
        return p != null;
    }

    public static boolean hasPlaceholderAPI() {
        return Hooks.hasPlugin(PLACEHOLDER_API);
    }

    public static boolean canFights(@NotNull Entity attacker, @NotNull Entity victim) {
        WorldGuardHK wg;
        if (attacker.equals((Object)victim)) {
            return false;
        }
        if (victim.isInvulnerable() || !(victim instanceof LivingEntity)) {
            return false;
        }
        if (Hooks.isNPC(victim)) {
            if (!Hooks.hasPlugin("Sentinel")) {
                return false;
            }
            NPC npc = CitizensAPI.getNPCRegistry().getNPC(victim);
            if (!npc.hasTrait(SentinelTrait.class)) {
                return false;
            }
        }
        if ((wg = ENGINE.getWorldGuard()) != null) {
            return wg.canFights(attacker, victim);
        }
        return true;
    }
}

