/*
 * Decompiled with CFR 0.152.
 */
package studio.magemonkey.codex.hooks.external;

import io.lumine.xikage.mythicmobs.MythicMobs;
import io.lumine.xikage.mythicmobs.api.exceptions.InvalidMobTypeException;
import io.lumine.xikage.mythicmobs.mobs.ActiveMob;
import io.lumine.xikage.mythicmobs.mobs.MythicMob;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nullable;
import org.bukkit.Location;
import org.bukkit.entity.Entity;
import org.bukkit.entity.LivingEntity;
import org.jetbrains.annotations.NotNull;
import studio.magemonkey.codex.CodexEngine;
import studio.magemonkey.codex.hooks.HookState;
import studio.magemonkey.codex.hooks.NHook;
import studio.magemonkey.codex.hooks.external.IMythicHook;

public class MythicMobsHK
extends NHook<CodexEngine>
implements IMythicHook {
    private MythicMobs mm;

    public MythicMobsHK(CodexEngine plugin) {
        super(plugin);
    }

    @Override
    @NotNull
    protected HookState setup() {
        this.mm = MythicMobs.inst();
        return HookState.SUCCESS;
    }

    @Override
    public void shutdown() {
    }

    @Override
    public boolean isMythicMob(@NotNull Entity e) {
        return this.mm.getAPIHelper().isMythicMob(e);
    }

    @Override
    public String getMythicNameByEntity(@NotNull Entity e) {
        return this.mm.getAPIHelper().getMythicMobInstance(e).getType().getInternalName();
    }

    public MythicMob getMythicInstance(@NotNull Entity e) {
        return this.mm.getAPIHelper().getMythicMobInstance(e).getType();
    }

    @Override
    public boolean isDropTable(@NotNull String table) {
        return this.mm.getDropManager().getDropTable(table) != null && MythicMobs.inst().getDropManager().getDropTable(table).isPresent();
    }

    @Override
    public double getLevel(@NotNull Entity e) {
        return this.mm.getAPIHelper().getMythicMobInstance(e).getLevel();
    }

    @Override
    @NotNull
    public List<String> getMythicIds() {
        return new ArrayList<String>(this.mm.getMobManager().getMobNames());
    }

    @Override
    public void setSkillDamage(@NotNull Entity e, double d) {
        if (!this.isMythicMob(e)) {
            return;
        }
        ActiveMob am1 = this.mm.getMobManager().getMythicMobInstance(e);
        am1.setLastDamageSkillAmount(d);
    }

    @Override
    public void castSkill(@NotNull Entity e, @NotNull String skill) {
        this.mm.getAPIHelper().castSkill(e, skill);
    }

    @Override
    public void killMythic(@NotNull Entity e) {
        if (!this.mm.getAPIHelper().getMythicMobInstance(e).isDead()) {
            this.mm.getAPIHelper().getMythicMobInstance(e).setDead();
            e.remove();
        }
    }

    @Override
    public boolean isValid(@NotNull String name) {
        MythicMob koke = this.mm.getAPIHelper().getMythicMob(name);
        return koke != null;
    }

    @Override
    @NotNull
    public String getName(@NotNull String mobId) {
        MythicMob koke = this.mm.getAPIHelper().getMythicMob(mobId);
        return koke != null ? koke.getDisplayName().get() : mobId;
    }

    @Override
    @Nullable
    public Entity spawnMythicMob(@NotNull String name, @NotNull Location loc, int level) {
        try {
            MythicMob koke = this.mm.getAPIHelper().getMythicMob(name);
            Entity e = this.mm.getAPIHelper().spawnMythicMob(koke, loc, level);
            return e;
        }
        catch (InvalidMobTypeException e) {
            e.printStackTrace();
            return null;
        }
    }

    @Override
    public void taunt(LivingEntity target, LivingEntity source, double amount) {
        if (amount > 0.0) {
            MythicMobs.inst().getAPIHelper().addThreat((Entity)target, source, amount);
        } else if (amount < 0.0) {
            MythicMobs.inst().getAPIHelper().reduceThreat((Entity)target, source, -amount);
        }
    }
}

