/*
 * Decompiled with CFR 0.152.
 */
package studio.magemonkey.codex.items.providers;

import org.bukkit.Bukkit;
import org.bukkit.inventory.ItemStack;
import org.jetbrains.annotations.Nullable;
import studio.magemonkey.codex.items.ItemType;
import studio.magemonkey.codex.items.exception.MissingProviderException;

public interface ICodexItemProvider<T extends ItemType> {
    default public void assertEnabled() throws MissingProviderException {
        if (!Bukkit.getPluginManager().isPluginEnabled(this.pluginName())) {
            throw new MissingProviderException(this.pluginName() + " is not enabled!");
        }
    }

    public String pluginName();

    public String getNamespace();

    public Category getCategory();

    @Nullable
    public T getItem(String var1);

    @Nullable
    public T getItem(ItemStack var1);

    public boolean isCustomItem(ItemStack var1);

    public boolean isCustomItemOfId(ItemStack var1, String var2);

    public static enum Category {
        VANILLA,
        MOD,
        EXTERNAL,
        PRO;

    }
}

