/*
 * Decompiled with CFR 0.152.
 */
package studio.magemonkey.codex.legacy.command;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.bukkit.Bukkit;
import org.bukkit.command.Command;
import org.bukkit.command.CommandExecutor;
import org.bukkit.command.CommandSender;
import org.bukkit.command.ConsoleCommandSender;
import org.bukkit.command.TabCompleter;
import org.bukkit.entity.Player;
import org.bukkit.plugin.Plugin;
import org.jetbrains.annotations.Nullable;
import studio.magemonkey.codex.util.messages.MessageData;
import studio.magemonkey.codex.util.messages.MessageUtil;

public abstract class RiseCommand
implements CommandExecutor,
TabCompleter {
    protected Plugin plugin;
    private final String name;
    private String description;
    private String usage;
    private final ArrayList<String> aliases = new ArrayList();
    private RiseCommand parentCommand = null;
    private final HashSet<RiseCommand> children = new HashSet();
    private final Command bukkitCommand;

    public RiseCommand(Plugin plugin, String name, String description, String usage, List<String> aliases, RiseCommand parentCommand) {
        RiseCommand parent;
        this.plugin = plugin;
        this.name = name.toLowerCase();
        this.setDescription(description);
        this.setUsage(usage);
        this.setParentCommand(parentCommand);
        for (String alias : aliases) {
            this.aliases.add(alias.toLowerCase());
        }
        if (parentCommand == null) {
            plugin.getServer().getPluginCommand(name).setExecutor((CommandExecutor)this);
            plugin.getServer().getPluginCommand(name).setTabCompleter((TabCompleter)this);
        }
        RiseCommand riseCommand = parent = this.hasParentCommand() ? this.getParentCommand() : this;
        while (parent != null && parent.hasParentCommand()) {
            parent = parent.getParentCommand();
        }
        this.bukkitCommand = Bukkit.getServer().getPluginCommand(parent.getName());
    }

    public RiseCommand(Plugin plugin, String name, String description, String usage) {
        this(plugin, name, description, usage, Collections.singletonList(name), null);
    }

    public RiseCommand(String name, List<String> aliases, Plugin plugin) {
        this(plugin, name, "", "", aliases, null);
    }

    public RiseCommand(String name, List<String> aliases, RiseCommand parentCommand) {
        this(parentCommand != null ? parentCommand.plugin : null, name, "", "", aliases, parentCommand);
    }

    public RiseCommand(String name, List<String> aliases) {
        this(name, aliases, (RiseCommand)null);
    }

    protected boolean isPlayer(CommandSender sender) {
        return sender instanceof Player;
    }

    private void setParentCommand(RiseCommand parent) {
        this.parentCommand = parent;
        if (parent != null) {
            parent.addChild(this);
        }
    }

    public RiseCommand getParentCommand() {
        return this.parentCommand;
    }

    public boolean hasParentCommand() {
        return this.parentCommand != null;
    }

    public HashSet<RiseCommand> getChildren() {
        return this.children;
    }

    public void addChild(RiseCommand command) {
        this.children.add(command);
    }

    public RiseCommand getChild(String[] args) {
        if (args.length == 0) {
            return null;
        }
        for (RiseCommand child : this.children) {
            if (!child.isAlias(args[0])) continue;
            return child;
        }
        return null;
    }

    public String getName() {
        return this.name;
    }

    public boolean isAlias(String cmd) {
        return this.name.equalsIgnoreCase(cmd) || this.aliases.contains(cmd.toLowerCase());
    }

    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
        if (this.getBukkitCommand() != null) {
            this.getBukkitCommand().setDescription(description);
        }
    }

    public String getUsage() {
        return this.usage;
    }

    public void setUsage(String usage) {
        this.usage = usage;
        if (this.getBukkitCommand() != null) {
            this.getBukkitCommand().setUsage(usage);
        }
    }

    public void sendUsage(String usage, CommandSender sender, RiseCommand command, String[] args) {
        ArrayList<String> strs = new ArrayList<String>(20);
        RiseCommand cmd = command;
        while (cmd.hasParentCommand()) {
            strs.add(cmd.getName());
            cmd = cmd.getParentCommand();
        }
        StringBuilder sb = new StringBuilder(100);
        for (int i = strs.size() - 1; i >= 0; --i) {
            sb.append((String)strs.get(i));
            if (i == 0) continue;
            sb.append(' ');
        }
        String s = sb.toString();
        MessageUtil.sendMessage(usage, sender, new MessageData("text", (String)(s.isEmpty() ? "" : s + " ") + StringUtils.join((Object[])args, (String)" ")));
    }

    public boolean checkPermission(CommandSender sender, String permission) {
        return sender instanceof ConsoleCommandSender || sender.hasPermission(permission);
    }

    public Command getBukkitCommand() {
        return this.bukkitCommand;
    }

    public boolean onCommand(CommandSender sender, Command command, String label, String[] args) {
        RiseCommand child = this.getChild(args);
        if (args.length == 0 || child == null) {
            this.runCommand(sender, this, label, args);
        } else {
            String[] tempargs = new String[args.length - 1];
            System.arraycopy(args, 1, tempargs, 0, args.length - 1);
            child.onCommand(sender, command, label, tempargs);
        }
        return true;
    }

    public abstract void runCommand(CommandSender var1, RiseCommand var2, String var3, String[] var4);

    @Nullable
    public List<String> onTabComplete(CommandSender commandSender, Command command, String label, String[] strings) {
        return null;
    }
}

