/*
 * Decompiled with CFR 0.152.
 */
package studio.magemonkey.codex.legacy.item;

import java.util.Map;
import lombok.Generated;
import org.apache.commons.lang3.builder.ToStringBuilder;
import org.apache.commons.lang3.builder.ToStringStyle;
import org.bukkit.Color;
import org.bukkit.configuration.serialization.SerializableAs;
import org.bukkit.inventory.meta.ItemMeta;
import org.bukkit.inventory.meta.LeatherArmorMeta;
import studio.magemonkey.codex.legacy.item.DataBuilder;
import studio.magemonkey.codex.util.ItemUtils;
import studio.magemonkey.codex.util.SerializationBuilder;
import studio.magemonkey.risecore.legacy.util.DeserializationWorker;

@SerializableAs(value="Codex_LeatherArmorMeta")
public class LeatherArmorBuilder
extends DataBuilder {
    private int red;
    private int green;
    private int blue;

    public LeatherArmorBuilder(Map<String, Object> map) {
        DeserializationWorker w = DeserializationWorker.start(map);
        Color color = ItemUtils.simpleDeserializeColor(w.getString("color"));
        if (color == null) {
            return;
        }
        this.color(color);
    }

    public LeatherArmorBuilder red(int red) {
        this.red = red;
        return this;
    }

    public LeatherArmorBuilder green(int green) {
        this.green = green;
        return this;
    }

    public LeatherArmorBuilder blue(int blue) {
        this.blue = blue;
        return this;
    }

    public LeatherArmorBuilder color(int red, int green, int blue) {
        this.red = red;
        this.green = green;
        this.blue = blue;
        return this;
    }

    public LeatherArmorBuilder color(int[] rgb) {
        if (rgb.length != 3) {
            throw new IllegalArgumentException("size of rgb array must be: 3");
        }
        this.red = rgb[0];
        this.green = rgb[1];
        this.blue = rgb[2];
        return this;
    }

    public LeatherArmorBuilder color(Color color) {
        this.red = color.getRed();
        this.green = color.getGreen();
        this.blue = color.getBlue();
        return this;
    }

    @Override
    public void apply(ItemMeta itemMeta) {
        if (!(itemMeta instanceof LeatherArmorMeta)) {
            return;
        }
        LeatherArmorMeta meta = (LeatherArmorMeta)itemMeta;
        meta.setColor(Color.fromRGB((int)this.red, (int)this.green, (int)this.blue));
    }

    @Override
    public LeatherArmorBuilder use(ItemMeta itemMeta) {
        if (!(itemMeta instanceof LeatherArmorMeta)) {
            return null;
        }
        LeatherArmorMeta meta = (LeatherArmorMeta)itemMeta;
        return meta.getColor() != null ? this.color(meta.getColor()) : this;
    }

    @Override
    public String getType() {
        return "leather";
    }

    @Override
    public Map<String, Object> serialize() {
        SerializationBuilder b = SerializationBuilder.start(2).append(super.serialize());
        b.append("color", (Object)ItemUtils.simpleSerializeColor(Color.fromRGB((int)this.red, (int)this.green, (int)this.blue)));
        return b.build();
    }

    public String toString() {
        return new ToStringBuilder((Object)this, ToStringStyle.SHORT_PREFIX_STYLE).appendSuper(super.toString()).append("red", this.red).append("green", this.green).append("blue", this.blue).toString();
    }

    public static LeatherArmorBuilder start() {
        return new LeatherArmorBuilder();
    }

    @Generated
    public int getRed() {
        return this.red;
    }

    @Generated
    public int getGreen() {
        return this.green;
    }

    @Generated
    public int getBlue() {
        return this.blue;
    }

    @Generated
    public LeatherArmorBuilder() {
    }
}

