/*
 * Decompiled with CFR 0.152.
 */
package studio.magemonkey.codex.legacy.utils;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import net.md_5.bungee.api.ChatColor;
import net.md_5.bungee.api.chat.BaseComponent;
import net.md_5.bungee.api.chat.ClickEvent;
import net.md_5.bungee.api.chat.HoverEvent;
import net.md_5.bungee.api.chat.TextComponent;
import net.md_5.bungee.api.chat.TranslatableComponent;
import net.md_5.bungee.chat.ComponentSerializer;
import net.md_5.bungee.chat.TextComponentSerializer;
import net.md_5.bungee.chat.TranslatableComponentSerializer;
import studio.magemonkey.codex.legacy.utils.ChatColorUtils;

public final class ComponentUtils {
    private static final Gson gson = new GsonBuilder().registerTypeAdapter(BaseComponent.class, (Object)new ComponentSerializer()).registerTypeAdapter(TextComponent.class, (Object)new TextComponentSerializer()).registerTypeAdapter(TranslatableComponent.class, (Object)new TranslatableComponentSerializer()).create();
    private static final Pattern url = Pattern.compile("^(?:(https?)://)?([-\\w_\\.]{2,}\\.[a-z]{2,4})(/\\S*)?$");
    private static final Pattern format = Pattern.compile("%(?:(\\d+)\\$)?([A-Za-z%]|$)");

    private ComponentUtils() {
    }

    public static BaseComponent[] parse(String json) {
        BaseComponent[] baseComponentArray;
        if (json.startsWith("[")) {
            baseComponentArray = (BaseComponent[])gson.fromJson(json, BaseComponent[].class);
        } else {
            BaseComponent[] baseComponentArray2 = new BaseComponent[1];
            baseComponentArray = baseComponentArray2;
            baseComponentArray2[0] = (BaseComponent)gson.fromJson(json, BaseComponent.class);
        }
        return baseComponentArray;
    }

    public static boolean isEmpty(BaseComponent component) {
        boolean emptyExtra;
        List extra = component.getExtra();
        if (extra != null) {
            Iterator iterator = extra.iterator();
            while (iterator.hasNext()) {
                if (!ComponentUtils.isEmpty((BaseComponent)iterator.next())) continue;
                iterator.remove();
            }
        }
        boolean bl = emptyExtra = extra == null || extra.isEmpty();
        if (component instanceof TextComponent) {
            String text = ((TextComponent)component).getText();
            return emptyExtra && (text == null || text.isEmpty());
        }
        if (component instanceof TranslatableComponent) {
            String translate = ((TranslatableComponent)component).getTranslate();
            return emptyExtra && (translate == null || translate.isEmpty());
        }
        return emptyExtra;
    }

    public static BaseComponent[] fromLegacyText(String message) {
        ArrayList<TextComponent> components = new ArrayList<TextComponent>(20);
        StringBuilder builder = new StringBuilder();
        TextComponent component = new TextComponent("");
        TextComponent builderComponent = new TextComponent("");
        Matcher matcher = url.matcher(message);
        for (int i = 0; i < message.length(); ++i) {
            char c = message.charAt(i);
            if (c == '\n') {
                if (builder.length() > 0) {
                    builderComponent.setText(builder.toString());
                    component.addExtra((BaseComponent)builderComponent);
                    builderComponent = new TextComponent("");
                    builder = new StringBuilder();
                }
                components.add(component);
                component = new TextComponent("");
                continue;
            }
            if (c == '\u00a7') {
                ChatColor pos;
                if ((c = message.charAt(++i)) >= 'A' && c <= 'Z') {
                    c = (char)(c + 32);
                }
                if ((pos = ChatColor.getByChar((char)c)) == null) continue;
                if (builder.length() > 0) {
                    builderComponent.setText(builder.toString());
                    component.addExtra((BaseComponent)builderComponent);
                    builderComponent = new TextComponent("");
                    builder = new StringBuilder();
                }
                if (pos.equals((Object)ChatColor.BOLD)) {
                    builderComponent.setBold(Boolean.TRUE);
                    continue;
                }
                if (pos.equals((Object)ChatColor.ITALIC)) {
                    builderComponent.setItalic(Boolean.TRUE);
                    continue;
                }
                if (pos.equals((Object)ChatColor.UNDERLINE)) {
                    builderComponent.setUnderlined(Boolean.TRUE);
                    continue;
                }
                if (pos.equals((Object)ChatColor.STRIKETHROUGH)) {
                    builderComponent.setStrikethrough(Boolean.TRUE);
                    continue;
                }
                if (pos.equals((Object)ChatColor.MAGIC)) {
                    builderComponent.setObfuscated(Boolean.TRUE);
                    continue;
                }
                if (pos.equals((Object)ChatColor.RESET)) {
                    pos = ChatColor.WHITE;
                    continue;
                }
                builderComponent = new TextComponent("");
                builderComponent.setColor(pos);
                continue;
            }
            int var10 = message.indexOf(32, i);
            if (var10 == -1) {
                var10 = message.length();
            }
            if (matcher.region(i, var10).find()) {
                if (builder.length() > 0) {
                    builderComponent.setText(builder.toString());
                    component.addExtra((BaseComponent)builderComponent);
                    builderComponent = new TextComponent("");
                    builder = new StringBuilder();
                }
                String urlString = message.substring(i, var10);
                builderComponent.setText(urlString);
                builderComponent.setClickEvent(new ClickEvent(ClickEvent.Action.OPEN_URL, (String)(urlString.startsWith("http") ? urlString : "http://" + urlString)));
                component.addExtra((BaseComponent)builderComponent);
                builderComponent = new TextComponent("");
                i += var10 - i - 1;
                continue;
            }
            builder.append(c);
        }
        if (builder.length() > 0) {
            builderComponent.setText(builder.toString());
            component.addExtra((BaseComponent)builderComponent);
        }
        components.add(component);
        return components.toArray(new BaseComponent[components.size()]);
    }

    public static String toString(BaseComponent[] components) {
        return gson.toJson((Object)components);
    }

    public static String toString(BaseComponent components) {
        return gson.toJson((Object)components);
    }

    public static String toPlainText(BaseComponent[] component) {
        if (component.length == 0) {
            return "";
        }
        StringBuilder sb = new StringBuilder(100 * component.length);
        sb.append(component[0].toPlainText());
        if (component.length > 1) {
            for (int i = 1; i < component.length; ++i) {
                BaseComponent baseComponent = component[i];
                sb.append('\n');
                sb.append(baseComponent.toPlainText());
            }
        }
        return sb.toString();
    }

    public static String toLegacyText(BaseComponent[] component) {
        if (component.length == 0) {
            return "";
        }
        StringBuilder sb = new StringBuilder(100 * component.length);
        sb.append(ComponentUtils.toLegacyText(component[0]));
        if (component.length > 1) {
            for (int i = 1; i < component.length; ++i) {
                BaseComponent baseComponent = component[i];
                sb.append('\n');
                sb.append(ComponentUtils.toLegacyText(baseComponent));
            }
        }
        return sb.toString();
    }

    public static String toLegacyText(BaseComponent this_) {
        StringBuilder builder = new StringBuilder();
        ComponentUtils.toLegacyText(this_, builder);
        return builder.toString();
    }

    static void toLegacyText(BaseComponent this_, StringBuilder builder) {
        ComponentUtils.toLegacyText(this_, builder, true);
    }

    static void toLegacyText(BaseComponent this_, StringBuilder builder, boolean checkType) {
        List extra;
        if (checkType) {
            if (this_ instanceof TextComponent) {
                ComponentUtils.toLegacyText((TextComponent)this_, builder);
                return;
            }
            if (this_ instanceof TranslatableComponent) {
                ComponentUtils.toLegacyText((TranslatableComponent)this_, builder);
                return;
            }
        }
        if ((extra = this_.getExtra()) != null) {
            for (BaseComponent e : extra) {
                ComponentUtils.toLegacyText(e, builder);
            }
        }
    }

    static void toLegacyText(TranslatableComponent this_, StringBuilder builder) {
        String trans = this_.getTranslate();
        Matcher matcher = format.matcher(trans);
        int position = 0;
        int i = 0;
        while (matcher.find(position)) {
            int pos = matcher.start();
            if (pos != position) {
                ComponentUtils.addFormat((BaseComponent)this_, builder);
                builder.append(trans.substring(position, pos));
            }
            position = matcher.end();
            String formatCode = matcher.group(2);
            switch (formatCode.charAt(0)) {
                case '%': {
                    ComponentUtils.addFormat((BaseComponent)this_, builder);
                    builder.append('%');
                    break;
                }
                case 'd': 
                case 's': {
                    String withIndex = matcher.group(1);
                    ComponentUtils.toLegacyText((BaseComponent)this_.getWith().get(withIndex != null ? Integer.parseInt(withIndex) - 1 : i++), builder);
                }
            }
        }
        if (trans.length() != position) {
            ComponentUtils.addFormat((BaseComponent)this_, builder);
            builder.append(trans.substring(position, trans.length()));
        }
        ComponentUtils.toLegacyText((BaseComponent)this_, builder, false);
    }

    static void addFormat(BaseComponent this_, StringBuilder builder) {
        ChatColor colorRaw = this_.getColorRaw();
        if (colorRaw != null) {
            builder.append(this_.getColor());
        }
        if (this_.isBold()) {
            builder.append(ChatColor.BOLD);
        }
        if (this_.isItalic()) {
            builder.append(ChatColor.ITALIC);
        }
        if (this_.isUnderlined()) {
            builder.append(ChatColor.UNDERLINE);
        }
        if (this_.isStrikethrough()) {
            builder.append(ChatColor.STRIKETHROUGH);
        }
        if (this_.isObfuscated()) {
            builder.append(ChatColor.MAGIC);
        }
    }

    static void toLegacyText(TextComponent this_, StringBuilder builder) {
        ComponentUtils.addFormat((BaseComponent)this_, builder);
        String text = this_.getText();
        if (text != null) {
            builder.append(text);
        }
        ComponentUtils.toLegacyText((BaseComponent)this_, builder, false);
    }

    public static boolean canBeLegacy(BaseComponent[] component) {
        for (BaseComponent baseComponent : component) {
            if (ComponentUtils.canBeLegacy(baseComponent)) continue;
            return false;
        }
        return true;
    }

    public static boolean canBeLegacy(BaseComponent component) {
        if (component.getClickEvent() != null) {
            return false;
        }
        if (component.getHoverEvent() != null) {
            return false;
        }
        List extra = component.getExtra();
        if (extra == null || extra.isEmpty()) {
            return true;
        }
        for (BaseComponent baseComponent : extra) {
            if (ComponentUtils.canBeLegacy(baseComponent)) continue;
            return false;
        }
        return true;
    }

    public static BaseComponent[] safeParse(String json) {
        return ComponentUtils.safeParse(json, false);
    }

    public static BaseComponent[] safeParse(String json, boolean color) {
        try {
            BaseComponent[] baseComponentArray = ComponentSerializer.parse((String)json);
        }
        catch (Exception exception) {
            // empty catch block
        }
        return color ? ChatColorUtils.translateAlternateColorCodes(json) : ComponentUtils.fromLegacyText(json);
    }

    public static BaseComponent[][] safeParseMulti(String[] json, boolean color) {
        BaseComponent[][] result = new BaseComponent[json.length][];
        for (int i = 0; i < json.length; ++i) {
            result[i] = ComponentUtils.safeParse(json[i], color);
        }
        return result;
    }

    public static int replace(BaseComponent this_, String text, BaseComponent component, int limit) {
        return ComponentUtils.replace_(null, this_, text, component, limit);
    }

    public static int replace(BaseComponent this_, String text, BaseComponent component) {
        return ComponentUtils.replace(this_, text, component, -1);
    }

    public static boolean replaceOnce(BaseComponent this_, String text, BaseComponent component) {
        return ComponentUtils.replace(this_, text, component, 1) != 1;
    }

    public static int replace(BaseComponent this_, String text, String repl, int limit) {
        return ComponentUtils.replace_(null, this_, text, repl, limit);
    }

    public static int replace(BaseComponent this_, String text, String repl) {
        return ComponentUtils.replace(this_, text, repl, -1);
    }

    public static boolean replaceOnce(BaseComponent this_, String text, String repl) {
        return ComponentUtils.replace(this_, text, repl, 1) != 1;
    }

    static int replace_(BaseComponent component_, TranslatableComponent this_, String text, BaseComponent component, int limit) {
        List with;
        String translate = this_.getTranslate();
        int startIndex = translate.indexOf(text);
        if (startIndex != -1) {
            int endIndex = startIndex + text.length();
            this_.setTranslate(translate.substring(0, startIndex) + ComponentUtils.toLegacyText(component) + translate.substring(endIndex));
            if (--limit == 0) {
                return 0;
            }
        }
        if ((with = this_.getWith()) != null) {
            for (BaseComponent w : with) {
                limit = ComponentUtils.replace_((BaseComponent)this_, w, text, component, limit);
                if (limit != 0) continue;
                return 0;
            }
        }
        return ComponentUtils.replace_(component_, (BaseComponent)this_, text, component, limit, false);
    }

    static int replace_(BaseComponent component_, TranslatableComponent this_, String text, String repl, int limit) {
        List with;
        String translate = this_.getTranslate();
        int startIndex = translate.indexOf(text);
        if (startIndex != -1) {
            int endIndex = startIndex + text.length();
            this_.setTranslate(translate.substring(0, startIndex) + repl + translate.substring(endIndex));
            if (--limit == 0) {
                return 0;
            }
        }
        if ((with = this_.getWith()) != null) {
            for (BaseComponent w : with) {
                limit = ComponentUtils.replace_((BaseComponent)this_, w, text, repl, limit);
                if (limit != 0) continue;
                return 0;
            }
        }
        return ComponentUtils.replace_(component_, (BaseComponent)this_, text, repl, limit, false);
    }

    static int replace_(BaseComponent component_, TextComponent this_, String text, BaseComponent component, int limit) {
        String thisText = this_.getText();
        if (thisText == null) {
            return ComponentUtils.replace_(component_, (BaseComponent)this_, text, component, limit, false);
        }
        int startIndex = thisText.indexOf(text);
        if (startIndex != -1) {
            int endIndex = startIndex + text.length();
            String pre = thisText.substring(0, startIndex);
            String post = thisText.substring(endIndex);
            this_.setText(pre);
            ArrayList<BaseComponent> extra = this_.getExtra();
            if (extra != null) {
                extra.addAll(0, Arrays.asList(component.duplicate(), new TextComponent(post)));
            } else {
                extra = new ArrayList<BaseComponent>(2);
                this_.setExtra(extra);
                extra.add(component.duplicate());
                extra.add((BaseComponent)new TextComponent(post));
            }
            if (--limit == 0) {
                return 0;
            }
        }
        return ComponentUtils.replace_(component_, (BaseComponent)this_, text, component, limit, false);
    }

    static int replace_(BaseComponent component_, TextComponent this_, String text, String repl, int limit) {
        String thisText = this_.getText();
        if (thisText == null) {
            return ComponentUtils.replace_(component_, (BaseComponent)this_, text, repl, limit, false);
        }
        int startIndex = thisText.indexOf(text);
        if (startIndex != -1) {
            int endIndex = startIndex + text.length();
            this_.setText(thisText.substring(0, startIndex) + repl + thisText.substring(endIndex));
            if (--limit == 0) {
                return 0;
            }
        }
        return ComponentUtils.replace_(component_, (BaseComponent)this_, text, repl, limit, false);
    }

    static int replace_(BaseComponent component_, BaseComponent this_, String text, BaseComponent component, int limit) {
        return ComponentUtils.replace_(component_, this_, text, component, limit, true);
    }

    static int replace_(BaseComponent component_, BaseComponent this_, String text, BaseComponent component, int limit, boolean checkType) {
        List extra;
        if (checkType) {
            if (this_ instanceof TextComponent) {
                return ComponentUtils.replace_(component_, (TextComponent)this_, text, component, limit);
            }
            if (this_ instanceof TranslatableComponent) {
                return ComponentUtils.replace_(component_, (TranslatableComponent)this_, text, component, limit);
            }
        }
        if ((extra = this_.getExtra()) != null) {
            for (BaseComponent bs : extra) {
                limit = ComponentUtils.replace_(this_, bs, text, component, limit);
                if (limit != 0) continue;
                return 0;
            }
        }
        if (this_.getHoverEvent() != null && (limit = ComponentUtils.replace_(this_, this_.getHoverEvent(), text, component, limit)) == 0) {
            return 0;
        }
        if (this_.getClickEvent() != null && (limit = ComponentUtils.replace_(this_, this_.getClickEvent(), text, component, limit)) == 0) {
            return 0;
        }
        return limit;
    }

    static int replace_(BaseComponent component_, BaseComponent this_, String text, String repl, int limit) {
        return ComponentUtils.replace_(component_, this_, text, repl, limit, true);
    }

    static int replace_(BaseComponent component_, BaseComponent this_, String text, String repl, int limit, boolean checkType) {
        List extra;
        if (checkType) {
            if (this_ instanceof TextComponent) {
                return ComponentUtils.replace_(component_, (TextComponent)this_, text, repl, limit);
            }
            if (this_ instanceof TranslatableComponent) {
                return ComponentUtils.replace_(component_, (TranslatableComponent)this_, text, repl, limit);
            }
        }
        if ((extra = this_.getExtra()) != null) {
            for (BaseComponent bs : extra) {
                limit = ComponentUtils.replace_(this_, bs, text, repl, limit);
                if (limit != 0) continue;
                return 0;
            }
        }
        if (this_.getHoverEvent() != null && (limit = ComponentUtils.replace_(this_, this_.getHoverEvent(), text, repl, limit)) == 0) {
            return 0;
        }
        if (this_.getClickEvent() != null && (limit = ComponentUtils.replace_(this_, this_.getClickEvent(), text, repl, limit)) == 0) {
            return 0;
        }
        return limit;
    }

    static int replace_(BaseComponent component_, ClickEvent this_, String text, String repl, int limit) {
        int startIndex = this_.getValue().indexOf(text);
        if (startIndex != -1) {
            int endIndex = startIndex + text.length();
            component_.setClickEvent(new ClickEvent(this_.getAction(), this_.getValue().substring(0, startIndex) + repl + this_.getValue().substring(endIndex)));
            if (--limit == 0) {
                return 0;
            }
        }
        return limit;
    }

    static int replace_(BaseComponent component_, ClickEvent this_, String text, BaseComponent component, int limit) {
        int startIndex = this_.getValue().indexOf(text);
        if (startIndex != -1) {
            int endIndex = startIndex + text.length();
            component_.setClickEvent(new ClickEvent(this_.getAction(), this_.getValue().substring(0, startIndex) + ComponentUtils.toLegacyText(component) + this_.getValue().substring(endIndex)));
            if (--limit == 0) {
                return 0;
            }
        }
        return limit;
    }

    static int replace_(BaseComponent component_, HoverEvent this_, String text, BaseComponent component, int limit) {
        BaseComponent[] value = this_.getValue();
        if (value != null) {
            for (BaseComponent bs : value) {
                if ((limit = ComponentUtils.replace_(null, bs, text, component, limit)) != 0) continue;
                return 0;
            }
        }
        return limit;
    }

    static int replace_(BaseComponent component_, HoverEvent this_, String text, String repl, int limit) {
        BaseComponent[] value = this_.getValue();
        if (value != null) {
            for (BaseComponent bs : value) {
                if ((limit = ComponentUtils.replace_(null, bs, text, repl, limit)) != 0) continue;
                return 0;
            }
        }
        return limit;
    }

    public static ClickEvent duplicate(ClickEvent this_) {
        return new ClickEvent(this_.getAction(), this_.getValue());
    }

    public static HoverEvent duplicate(HoverEvent this_) {
        BaseComponent[] value = this_.getValue();
        if (value == null) {
            return new HoverEvent(this_.getAction(), Collections.EMPTY_LIST);
        }
        BaseComponent[] valueCpy = new BaseComponent[value.length];
        for (int i = 0; i < value.length; ++i) {
            valueCpy[i] = value[i].duplicate();
        }
        return new HoverEvent(this_.getAction(), valueCpy);
    }
}

