/*
 * Decompiled with CFR 0.152.
 */
package studio.magemonkey.codex.manager.api.gui;

import java.util.ArrayList;
import java.util.List;
import org.bukkit.Material;
import org.bukkit.entity.Player;
import org.bukkit.event.inventory.ClickType;
import org.bukkit.event.inventory.InventoryClickEvent;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.ItemMeta;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import studio.magemonkey.codex.manager.api.gui.GuiClick;
import studio.magemonkey.codex.util.NamespaceResolver;
import studio.magemonkey.codex.util.StringUT;

public class JIcon {
    private final Material m;
    private final int amount;
    private String name;
    private List<String> lore;
    private boolean enchanted;
    private ItemStack item;
    private GuiClick click;

    public JIcon(@NotNull JIcon clon) {
        this(clon.m, clon.amount);
        this.item = clon.item != null ? new ItemStack(clon.item) : null;
        this.lore = clon.lore != null ? new ArrayList<String>(clon.lore) : null;
        this.enchanted = clon.enchanted;
        this.click = clon.click;
    }

    public JIcon(@NotNull Material m, int amount) {
        this.m = m;
        this.amount = amount;
    }

    public JIcon(@NotNull Material m) {
        this(m, 1);
    }

    public JIcon(@NotNull ItemStack item) {
        this.m = item.getType();
        this.amount = item.getAmount();
        this.item = new ItemStack(item);
    }

    @NotNull
    public JIcon setName(@NotNull String name) {
        this.name = StringUT.color(name);
        return this;
    }

    @NotNull
    public JIcon setLore(@NotNull List<String> s) {
        this.lore = StringUT.color(s);
        return this;
    }

    @NotNull
    public JIcon addLore(String ... s) {
        if (this.lore == null) {
            this.lore = new ArrayList<String>();
        }
        for (String s1 : s) {
            this.lore.add(StringUT.color(s1));
        }
        return this;
    }

    @NotNull
    public JIcon setEnchanted(boolean b) {
        this.enchanted = b;
        return this;
    }

    @NotNull
    public JIcon clearLore() {
        if (this.lore != null) {
            this.lore.clear();
        } else {
            this.lore = new ArrayList<String>();
        }
        return this;
    }

    @Nullable
    public GuiClick getClick() {
        return this.click;
    }

    @NotNull
    public JIcon setClick(@Nullable GuiClick click) {
        this.click = click;
        return this;
    }

    public void click(@NotNull Player p, @NotNull ClickType type, @NotNull InventoryClickEvent e) {
        if (this.click == null) {
            return;
        }
        this.click.click(p, (Enum<?>)type, e);
    }

    @NotNull
    public ItemStack build() {
        ItemMeta meta;
        if (this.item == null) {
            this.item = new ItemStack(this.m, this.amount);
        }
        if ((meta = this.item.getItemMeta()) == null) {
            return this.item;
        }
        if (this.name != null && !this.name.isEmpty()) {
            meta.setDisplayName(this.name);
        }
        if (this.lore != null && !this.lore.isEmpty()) {
            meta.setLore(this.lore);
        }
        if (this.enchanted) {
            meta.addEnchant(NamespaceResolver.getEnchantment("POWER", "ARROW_DAMAGE"), 1, true);
        }
        this.item.setItemMeta(meta);
        return this.item;
    }
}

