/*
 * Decompiled with CFR 0.152.
 */
package studio.magemonkey.codex.mccore.chat;

import java.util.ArrayList;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.bukkit.Bukkit;
import org.bukkit.ChatColor;
import org.bukkit.configuration.ConfigurationSection;
import org.bukkit.entity.Player;
import studio.magemonkey.codex.CodexEngine;
import studio.magemonkey.codex.mccore.chat.Prefix;
import studio.magemonkey.codex.mccore.config.ISavable;

public class ChatData
implements ISavable {
    CodexEngine plugin = (CodexEngine)Bukkit.getPluginManager().getPlugin("Codex");
    ArrayList<Prefix> pluginPrefixes = new ArrayList();
    ArrayList<Prefix> unlockedPrefixes = new ArrayList();
    Prefix playerPrefix;
    String playerName;
    String displayName;

    ChatData(String playerName) {
        this.playerName = playerName;
        this.displayName = playerName;
    }

    ChatData(ConfigurationSection config, String playerName) {
        this(playerName);
        this.load(config);
    }

    public String getChatTag() {
        Object tag = "<";
        for (Prefix prefix : this.pluginPrefixes) {
            tag = (String)tag + String.valueOf(prefix.braceColor) + "[" + prefix.text + String.valueOf(prefix.braceColor) + "]";
        }
        if (this.playerPrefix != null) {
            tag = (String)tag + String.valueOf(this.playerPrefix.braceColor) + "[" + this.playerPrefix.text + String.valueOf(this.playerPrefix.braceColor) + "]";
        }
        return (String)tag + String.valueOf(ChatColor.WHITE) + " " + this.displayName + ">";
    }

    public String getDisplayName() {
        return this.displayName;
    }

    public void setDisplayName(String displayName) {
        this.displayName = displayName;
    }

    public Prefix getPrefix() {
        return this.playerPrefix;
    }

    void setPrefix(String prefix) {
        for (Prefix unlocked : this.unlockedPrefixes) {
            if (!unlocked.textWithoutColor.equalsIgnoreCase(prefix)) continue;
            this.playerPrefix = unlocked;
            this.updateDisplayName();
            return;
        }
    }

    public Prefix getPrefix(String pluginName) {
        for (Prefix prefix : this.pluginPrefixes) {
            if (!prefix.pluginName.equalsIgnoreCase(pluginName)) continue;
            return prefix;
        }
        return null;
    }

    public List<Prefix> getUnlockedPrefixes(String pluginName) {
        ArrayList<Prefix> prefixes = new ArrayList<Prefix>();
        for (Prefix prefix : this.unlockedPrefixes) {
            if (!prefix.pluginName.equalsIgnoreCase(pluginName)) continue;
            prefixes.add(prefix);
        }
        return prefixes;
    }

    public boolean unlockPrefix(Prefix prefix, boolean apply) {
        if (this.hasPrefix(prefix.textWithoutColor)) {
            return false;
        }
        this.unlockedPrefixes.add(prefix);
        Player player = Bukkit.getPlayer((String)this.playerName);
        player.sendMessage("You unlocked the prefix: " + prefix.text);
        if (apply) {
            this.setPrefix(prefix.textWithoutColor);
        } else {
            player.sendMessage("    - Equip it by typing: /setprefix " + prefix.textWithoutColor);
        }
        return true;
    }

    public boolean removePrefix(String pluginName, String prefixText) {
        prefixText = ChatColor.stripColor((String)prefixText);
        for (Prefix prefix : this.unlockedPrefixes) {
            if (!prefix.textWithoutColor.equalsIgnoreCase(prefixText) || !prefix.pluginName.equalsIgnoreCase(pluginName)) continue;
            this.unlockedPrefixes.remove(prefix);
            Bukkit.getPlayer((String)this.playerName).sendMessage("You lost the prefix " + prefix.text);
            if (this.playerPrefix == prefix) {
                this.playerPrefix = null;
                this.updateDisplayName();
            }
            return true;
        }
        return false;
    }

    public void removePrefixes(String pluginName) {
        for (int i = 0; i < this.unlockedPrefixes.size(); ++i) {
            if (!this.unlockedPrefixes.get((int)i).pluginName.equalsIgnoreCase(pluginName)) continue;
            if (this.unlockedPrefixes.get(i) == this.playerPrefix) {
                this.playerPrefix = null;
                this.updateDisplayName();
            }
            this.unlockedPrefixes.remove(i);
            Bukkit.getPlayer((String)this.playerName).sendMessage("You lost the prefix " + this.unlockedPrefixes.get((int)i).text);
            --i;
        }
    }

    public void setPluginPrefix(Prefix prefix) {
        if (prefix == null || StringUtils.isBlank((CharSequence)prefix.text)) {
            return;
        }
        Prefix currentPrefix = this.getPrefix(prefix.pluginName);
        if (currentPrefix != null) {
            this.pluginPrefixes.remove(currentPrefix);
        }
        this.pluginPrefixes.add(0, prefix);
        this.updateDisplayName();
    }

    public void clearPluginPrefix(String pluginName) {
        Prefix prefix = this.getPrefix(pluginName);
        if (prefix != null) {
            this.pluginPrefixes.remove(prefix);
        }
        this.updateDisplayName();
    }

    public boolean hasPrefix(String prefixText) {
        for (Prefix unlocked : this.unlockedPrefixes) {
            if (!unlocked.textWithoutColor.equalsIgnoreCase(prefixText)) continue;
            return true;
        }
        return false;
    }

    boolean isPrefixAvailable(String pluginName, String prefixText) {
        prefixText = ChatColor.stripColor((String)prefixText);
        for (Prefix prefix : this.unlockedPrefixes) {
            if (!prefix.pluginName.equalsIgnoreCase(pluginName) || !prefix.textWithoutColor.equalsIgnoreCase(prefixText)) continue;
            return true;
        }
        return false;
    }

    void updateDisplayName() {
        Player player;
        if (!this.plugin.isChatEnabled()) {
            return;
        }
        Object name = "";
        for (Prefix prefix : this.pluginPrefixes) {
            if (prefix == null || StringUtils.isBlank((CharSequence)prefix.text)) continue;
            name = (String)name + String.valueOf(prefix.braceColor) + "[" + prefix.text + String.valueOf(prefix.braceColor) + "]";
        }
        if (this.playerPrefix != null && !StringUtils.isBlank((CharSequence)this.playerPrefix.text)) {
            name = (String)name + String.valueOf(this.playerPrefix.braceColor) + "[" + this.playerPrefix.text + String.valueOf(this.playerPrefix.braceColor) + "]";
        }
        if (((String)name).length() > 0) {
            name = (String)name + " ";
        }
        if ((player = Bukkit.getPlayer((String)this.playerName)) != null) {
            if (this.displayName.equalsIgnoreCase(this.playerName)) {
                this.displayName = player.getName();
            }
            player.setDisplayName((String)name + String.valueOf(ChatColor.WHITE) + this.displayName);
        }
    }

    @Override
    public void save(ConfigurationSection config, String base) {
        config.set(base + "name", (Object)this.displayName);
        config.set(base + "unlocked", this.unlockedList());
        config.set(base + "prefixes", this.setList());
        if (this.playerPrefix != null) {
            config.set(base + "prefix", (Object)this.playerPrefix.toString());
        }
    }

    void load(ConfigurationSection config) {
        for (String prefix : config.getStringList(this.playerName.toLowerCase() + ".prefixes")) {
            this.pluginPrefixes.add(new Prefix(prefix));
        }
        this.unlockedPrefixes.clear();
        List unlocked = config.getStringList(this.playerName.toLowerCase() + ".unlocked");
        for (String prefix : unlocked) {
            this.unlockedPrefixes.add(new Prefix(prefix));
        }
        this.displayName = config.contains(this.playerName.toLowerCase() + ".name") ? config.getString(this.playerName.toLowerCase() + ".name") : this.playerName.toLowerCase();
        if (config.contains(this.playerName + ".prefix")) {
            this.playerPrefix = new Prefix(config.getString(this.playerName + ".prefix"));
        }
        this.updateDisplayName();
    }

    private List<String> setList() {
        ArrayList<String> list = new ArrayList<String>();
        for (Prefix prefix : this.pluginPrefixes) {
            list.add(prefix == null ? null : prefix.toString());
        }
        return list;
    }

    private List<String> unlockedList() {
        ArrayList<String> list = new ArrayList<String>();
        for (Prefix prefix : this.unlockedPrefixes) {
            list.add(prefix.toString());
        }
        return list;
    }
}

