/*
 * Decompiled with CFR 0.152.
 */
package studio.magemonkey.codex.mccore.chat;

import org.bukkit.ChatColor;
import org.bukkit.command.CommandSender;
import org.bukkit.plugin.Plugin;
import studio.magemonkey.codex.mccore.chat.Chat;
import studio.magemonkey.codex.mccore.chat.ChatData;
import studio.magemonkey.codex.mccore.chat.ChatNodes;
import studio.magemonkey.codex.mccore.commands.CommandHandler;
import studio.magemonkey.codex.mccore.commands.ICommand;
import studio.magemonkey.codex.mccore.commands.SenderType;

class PrefixCommand
implements ICommand {
    PrefixCommand() {
    }

    @Override
    public void execute(CommandHandler handler, Plugin plugin, CommandSender sender, String[] args) {
        ChatData data = Chat.getPlayerData(sender.getName());
        if (data != null && args.length == 1) {
            if (data.hasPrefix(args[0])) {
                data.setPrefix(args[0]);
                sender.sendMessage(String.valueOf(ChatColor.DARK_GREEN) + "The prefix has been set!");
            } else {
                sender.sendMessage(String.valueOf(ChatColor.DARK_RED) + "You do not have that prefix!");
            }
        } else {
            handler.displayUsage(sender);
        }
    }

    @Override
    public String getPermissionNode() {
        return ChatNodes.PREFIX.getNode();
    }

    @Override
    public String getArgsString() {
        return "<prefix>";
    }

    @Override
    public String getDescription() {
        return "Sets your prefix";
    }

    @Override
    public SenderType getSenderType() {
        return SenderType.PLAYER_ONLY;
    }
}

