/*
 * Decompiled with CFR 0.152.
 */
package studio.magemonkey.codex.mccore.commands;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.bukkit.ChatColor;
import org.bukkit.command.Command;
import org.bukkit.command.CommandExecutor;
import org.bukkit.command.CommandSender;
import org.bukkit.command.PluginCommand;
import org.bukkit.entity.Player;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.java.JavaPlugin;
import studio.magemonkey.codex.mccore.commands.CommandManager;
import studio.magemonkey.codex.mccore.commands.ICommand;
import studio.magemonkey.codex.mccore.commands.SenderType;
import studio.magemonkey.codex.mccore.util.TextSizer;

public abstract class CommandHandler
implements CommandExecutor {
    protected static final String BREAK = String.valueOf(ChatColor.STRIKETHROUGH) + String.valueOf(ChatColor.DARK_GRAY) + "-----------------------------------------------------";
    protected final Map<String, ICommand> commands = new HashMap<String, ICommand>();
    protected final Plugin plugin;
    protected final String label;
    protected String title;

    public CommandHandler(Plugin plugin, String title, String command) {
        this.plugin = plugin;
        this.title = title;
        this.label = command;
        this.registerCommands();
        PluginCommand cmd = ((JavaPlugin)plugin).getCommand(command);
        if (cmd != null) {
            cmd.setExecutor((CommandExecutor)this);
        }
    }

    public CommandHandler(Plugin plugin, String command) {
        this(plugin, command, command);
    }

    public Plugin getPlugin() {
        return this.plugin;
    }

    public String getLabel() {
        return this.label.toLowerCase();
    }

    protected void registerCommand(String command, ICommand executor) {
        this.commands.put(command, executor);
    }

    public boolean onCommand(CommandSender sender, Command cmd, String label, String[] args) {
        if (args.length == 0) {
            this.displayUsage(sender);
        } else if (this.commands.containsKey(args[0].toLowerCase())) {
            ICommand command = this.commands.get(args[0].toLowerCase());
            if (sender.hasPermission(command.getPermissionNode())) {
                command.execute(this, this.plugin, sender, CommandManager.trimArgs(args));
            } else {
                sender.sendMessage(String.valueOf(ChatColor.DARK_RED) + "You do not have permission to do that");
            }
        } else {
            try {
                int page = Integer.parseInt(args[0]);
                this.displayUsage(sender, page);
            }
            catch (Exception e) {
                this.displayUsage(sender);
            }
        }
        return true;
    }

    @Deprecated
    protected String[] trimArgs(String[] args) {
        return CommandManager.trimArgs(args);
    }

    public void displayUsage(CommandSender sender) {
        this.displayUsage(sender, 1);
    }

    public void displayUsage(CommandSender sender, int page) {
        if (page < 1) {
            page = 1;
        }
        ArrayList<String> keys = new ArrayList<String>(this.commands.keySet());
        Collections.sort(keys);
        int validKeys = 0;
        for (String key : keys) {
            if (!this.canUseCommand(sender, this.commands.get(key))) continue;
            ++validKeys;
        }
        if (validKeys == 0) {
            sender.sendMessage(String.valueOf(ChatColor.GRAY) + "   No commands available");
            return;
        }
        int maxPage = (validKeys + 6) / 7;
        if (page > maxPage) {
            page = maxPage;
        }
        sender.sendMessage(BREAK);
        sender.sendMessage(String.valueOf(ChatColor.DARK_GREEN) + this.title + " - Command Usage" + (String)(maxPage > 1 ? " (Page " + page + "/" + maxPage + ")" : ""));
        int maxSize = 0;
        int index = 0;
        for (String key : keys) {
            int size;
            if (!this.canUseCommand(sender, this.commands.get(key)) || ++index <= (page - 1) * 7 || index > page * 7 || (size = TextSizer.measureString(key + " " + this.commands.get(key).getArgsString())) <= maxSize) continue;
            maxSize = size;
        }
        maxSize += 4;
        index = 0;
        for (String key : keys) {
            if (!this.canUseCommand(sender, this.commands.get(key)) || ++index <= (page - 1) * 7 || index > page * 7) continue;
            sender.sendMessage(String.valueOf(ChatColor.GOLD) + "/" + this.label.toLowerCase() + " " + TextSizer.expand(key + " " + String.valueOf(ChatColor.LIGHT_PURPLE) + this.commands.get(key).getArgsString() + String.valueOf(ChatColor.GRAY), maxSize, false) + String.valueOf(ChatColor.GRAY) + "- " + this.commands.get(key).getDescription());
        }
        sender.sendMessage(BREAK);
    }

    protected boolean canUseCommand(CommandSender sender, ICommand command) {
        if (command.getSenderType() == SenderType.CONSOLE_ONLY && sender instanceof Player) {
            return false;
        }
        if (command.getSenderType() == SenderType.PLAYER_ONLY && !(sender instanceof Player)) {
            return false;
        }
        return sender.hasPermission(command.getPermissionNode());
    }

    protected abstract void registerCommands();
}

