/*
 * Decompiled with CFR 0.152.
 */
package studio.magemonkey.codex.mccore.config;

import java.io.File;
import java.util.logging.Level;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.java.JavaPlugin;
import studio.magemonkey.codex.mccore.config.parse.DataSection;
import studio.magemonkey.codex.mccore.config.parse.YAMLParser;

public class CommentedConfig {
    private final YAMLParser yamlParser = new YAMLParser();
    private final String fileName;
    private final JavaPlugin plugin;
    private File configFile;
    private DataSection data;
    private DataSection defaults;
    private boolean fileTimings = false;

    public CommentedConfig(JavaPlugin plugin, String name) {
        this.plugin = plugin;
        this.fileName = name + ".yml";
        this.fileTimings = plugin.getConfig().getBoolean("file-timings", false);
        this.configFile = new File(plugin.getDataFolder().getAbsolutePath() + "/" + this.fileName);
        try {
            String path = this.configFile.getAbsolutePath();
            if (new File(path.substring(0, path.lastIndexOf(File.separator))).mkdirs()) {
                plugin.getLogger().info("Created a new folder for config files");
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public JavaPlugin getPlugin() {
        return this.plugin;
    }

    public String getFileName() {
        return this.fileName.replace(".yml", "");
    }

    public void clear() {
        if (this.data == null) {
            this.reload();
        }
        this.data.clear();
    }

    public void reload() {
        long start = System.currentTimeMillis();
        boolean exists = this.data != null;
        this.data = this.yamlParser.parseFile(this.configFile);
        if (this.fileTimings) {
            this.plugin.getLogger().info((exists ? "Reloaded " : "Loaded ") + this.fileName + " in " + (System.currentTimeMillis() - start) + "ms");
        }
    }

    public DataSection getConfig() {
        if (this.data == null) {
            this.reload();
        }
        return this.data;
    }

    public File getConfigFile() {
        return this.configFile;
    }

    public void save() {
        if (this.data != null) {
            try {
                this.data.dump(this.configFile);
            }
            catch (Exception ex) {
                this.plugin.getLogger().log(Level.SEVERE, "Could not save config to " + String.valueOf(this.configFile), ex);
            }
        }
    }

    public void saveDefaultConfig() {
        if (!this.configFile.exists()) {
            if (this.defaults == null) {
                this.defaults = this.yamlParser.parseResource((Plugin)this.plugin, this.fileName);
            }
            this.defaults.dump(this.configFile);
        }
    }

    public void checkDefaults() {
        if (this.defaults == null) {
            this.defaults = this.yamlParser.parseResource((Plugin)this.plugin, this.fileName);
        }
        if (this.data == null) {
            this.reload();
        }
        this.data.applyDefaults(this.defaults);
    }

    public void trim() {
        if (this.defaults == null) {
            this.defaults = this.yamlParser.parseResource((Plugin)this.plugin, this.fileName);
        }
        if (this.data == null) {
            this.reload();
        }
        this.data.trim(this.defaults);
    }
}

