/*
 * Decompiled with CFR 0.152.
 */
package studio.magemonkey.codex.mccore.config;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.UUID;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.bukkit.Bukkit;
import org.bukkit.ChatColor;
import org.bukkit.Location;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;
import org.bukkit.plugin.java.JavaPlugin;
import studio.magemonkey.codex.mccore.config.CommentedConfig;
import studio.magemonkey.codex.mccore.config.CustomFilter;
import studio.magemonkey.codex.mccore.config.FilterType;
import studio.magemonkey.codex.mccore.util.TextFormatter;
import studio.magemonkey.codex.mccore.util.TextSizer;

public class CommentedLanguageConfig
extends CommentedConfig {
    private static final String EXPAND_FONT_REGEX = "\\{expandFront\\(([^,]+),([0-9]+),([0-9]+)\\)\\}";
    private static final Pattern EXPAND_FRONT = Pattern.compile("\\{expandFront\\(([^,]+),([0-9]+),([0-9]+)\\)\\}");
    private static final String EXPAND_BACK_REGEX = "\\{expandBack\\(([^,]+),([0-9]+),([0-9]+)\\)\\}";
    private static final Pattern EXPAND_BACK = Pattern.compile("\\{expandBack\\(([^,]+),([0-9]+),([0-9]+)\\)\\}");

    public CommentedLanguageConfig(JavaPlugin plugin, String file) {
        super(plugin, file);
        this.saveDefaultConfig();
        this.trim();
        this.checkDefaults();
    }

    public List<String> getMessage(String key, String def) {
        List<String> msg = this.getMessage(key);
        return msg != null ? msg : Collections.singletonList(def);
    }

    public List<String> getMessage(String key) {
        return this.getMessage(key, false, FilterType.NONE, new CustomFilter[0]);
    }

    public List<String> getMessage(String key, boolean player, FilterType filterType, CustomFilter ... filters) {
        List<Object> lines;
        if (!this.getConfig().has(key)) {
            return null;
        }
        if (this.getConfig().isList(key)) {
            lines = this.getConfig().getList(key);
        } else {
            lines = new ArrayList();
            lines.add(this.getConfig().getString(key));
        }
        ArrayList<String> result = new ArrayList<String>();
        for (String string : lines) {
            if (string.isEmpty()) continue;
            StringBuilder sb = new StringBuilder(string);
            for (CustomFilter filter : filters) {
                filter.apply(sb);
            }
            if (filterType == FilterType.COLOR || filterType == FilterType.ALL) {
                TextFormatter.colorString(sb);
            }
            if (filterType == FilterType.SPECIAL || filterType == FilterType.ALL) {
                this.filterSizer(sb, true, player);
                this.filterSizer(sb, false, player);
                this.filterBreak(sb);
            }
            sb.append(ChatColor.RESET);
            result.add(sb.toString());
        }
        return result;
    }

    private void filterSizer(StringBuilder sb, boolean front, boolean player) {
        Pattern regex = front ? EXPAND_FRONT : EXPAND_BACK;
        Matcher match = regex.matcher(sb);
        int size = sb.length();
        while (match.find()) {
            int playerSize = Integer.parseInt(match.group(2));
            int consoleSize = Integer.parseInt(match.group(3));
            String string = match.group(1);
            if (player) {
                sb.replace(match.start() + sb.length() - size, match.end(), TextSizer.measureString(string) > playerSize - 2 ? string : TextSizer.expand(string, playerSize, front));
                continue;
            }
            sb.replace(match.start() + sb.length() - size, match.end(), string.length() > consoleSize ? string : TextSizer.expandConsole(string, consoleSize, front));
        }
    }

    private void filterBreak(StringBuilder sb) {
        int index = sb.indexOf("{break}");
        if (index >= 0) {
            sb.delete(index, index + 7);
            String without = sb.toString();
            int size = TextSizer.measureString(without);
            for (int i = 0; i < (320 - size) / 6; ++i) {
                sb.insert(index, '-');
            }
        }
    }

    public void sendMessage(String key, CommandSender target) {
        this.sendMessage(key, target, FilterType.NONE, new CustomFilter[0]);
    }

    public void sendMessage(String key, CommandSender target, FilterType filterType, CustomFilter ... filters) {
        List<String> lines = this.getMessage(key, target instanceof Player, filterType, filters);
        for (String line : lines) {
            target.sendMessage(line);
        }
    }

    public void sendMessage(String key, Location loc, double radius) {
        this.sendMessage(key, loc, radius, FilterType.NONE, new CustomFilter[0]);
    }

    public void sendMessage(String key, Location loc, double radius, FilterType filterType, CustomFilter ... filters) {
        radius *= radius;
        List<String> lines = this.getMessage(key, true, filterType, filters);
        for (Player player : loc.getWorld().getPlayers()) {
            if (!(player.getLocation().distanceSquared(loc) < radius)) continue;
            lines.forEach(arg_0 -> ((Player)player).sendMessage(arg_0));
        }
    }

    public void sendMessage(String key, Collection<UUID> targetIds) {
        this.sendMessage(key, targetIds, FilterType.NONE, new CustomFilter[0]);
    }

    public void sendMessage(String key, Collection<UUID> targetIds, FilterType filterType, CustomFilter ... filters) {
        List<String> lines = this.getMessage(key, true, filterType, filters);
        if (lines == null) {
            return;
        }
        for (UUID id : targetIds) {
            Player target = Bukkit.getPlayer((UUID)id);
            if (target == null) continue;
            lines.forEach(arg_0 -> ((Player)target).sendMessage(arg_0));
        }
    }
}

