/*
 * Decompiled with CFR 0.152.
 */
package studio.magemonkey.codex.mccore.scoreboard;

import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import org.bukkit.Bukkit;
import org.bukkit.entity.Player;
import org.bukkit.scoreboard.DisplaySlot;
import org.bukkit.scoreboard.Objective;
import org.bukkit.scoreboard.Scoreboard;
import studio.magemonkey.codex.CodexEngine;
import studio.magemonkey.codex.mccore.scoreboard.Board;
import studio.magemonkey.codex.mccore.scoreboard.PlayerBoards;
import studio.magemonkey.codex.mccore.scoreboard.Team;

public class BoardManager {
    private static final Map<String, PlayerBoards> players = new HashMap<String, PlayerBoards>();
    private static final Map<String, String> teams = new HashMap<String, String>();
    private static Scoreboard scoreboard;
    private static boolean scoreboardUsed;

    static void init(Player player) {
        BoardManager.init();
        if (scoreboardUsed && player != null) {
            player.setScoreboard(scoreboard);
        }
    }

    public static void init() {
        if (scoreboard != null) {
            return;
        }
        if (Bukkit.getScoreboardManager() == null) {
            throw new IllegalStateException("Scoreboard manager is null");
        }
        scoreboard = Bukkit.getScoreboardManager().getNewScoreboard();
    }

    public static PlayerBoards getPlayerBoards(String player) {
        if (!players.containsKey(player.toLowerCase())) {
            players.put(player.toLowerCase(), new PlayerBoards(player));
        }
        return players.get(player.toLowerCase());
    }

    public static void registerTeam(Team team) {
        BoardManager.init();
        org.bukkit.scoreboard.Team sbTeam = scoreboard.getTeam(team.getName());
        if (sbTeam == null) {
            sbTeam = scoreboard.registerNewTeam(team.getName());
            sbTeam.setAllowFriendlyFire(true);
            sbTeam.setCanSeeFriendlyInvisibles(false);
        }
        BoardManager.updateTeam(team);
    }

    public static void updateTeam(Team team) {
        BoardManager.init();
        org.bukkit.scoreboard.Team sbTeam = scoreboard.getTeam(team.getName());
        if (sbTeam == null) {
            return;
        }
        if (team.getPrefix() != null) {
            sbTeam.setPrefix(team.getPrefix());
        }
        if (team.getSuffix() != null) {
            sbTeam.setSuffix(team.getSuffix());
        }
        BoardManager.getAllPlayerBoards().forEach(playerBoards -> {
            Board activeBoard = playerBoards.getActiveBoard();
            if (activeBoard == null) {
                return;
            }
            Scoreboard pBoard = activeBoard.getScoreboard();
            org.bukkit.scoreboard.Team pTeam = pBoard.getTeam(team.getName());
            if (pTeam != null) {
                return;
            }
            pTeam = pBoard.registerNewTeam(team.getName());
            pTeam.setAllowFriendlyFire(true);
            pTeam.setCanSeeFriendlyInvisibles(false);
        });
    }

    public static void setTeam(String player, String team) {
        try {
            BoardManager.enableScoreboard();
            org.bukkit.scoreboard.Team sTeam = scoreboard.getTeam(team);
            if (sTeam == null) {
                sTeam = scoreboard.registerNewTeam(team);
            }
            sTeam.addEntry(player);
            teams.put(player, team);
            BoardManager.getAllPlayerBoards().forEach(playerBoards -> {
                Board activeBoard = playerBoards.getActiveBoard();
                if (activeBoard == null) {
                    return;
                }
                Scoreboard pBoard = activeBoard.getScoreboard();
                org.bukkit.scoreboard.Team pTeam = pBoard.getTeam(team);
                if (pTeam == null) {
                    pTeam = pBoard.registerNewTeam(team);
                }
                pTeam.addEntry(player);
            });
        }
        catch (NoSuchMethodError noSuchMethodError) {
            // empty catch block
        }
    }

    public static void clearTeam(String player) {
        if (!teams.containsKey(player)) {
            return;
        }
        BoardManager.init();
        String teamName = teams.remove(player);
        org.bukkit.scoreboard.Team sbTeam = scoreboard.getTeam(teamName);
        if (sbTeam != null) {
            sbTeam.removeEntry(player);
        }
        BoardManager.getAllPlayerBoards().forEach(playerBoards -> {
            Board activeBoard = playerBoards.getActiveBoard();
            if (activeBoard == null) {
                return;
            }
            Scoreboard pBoard = activeBoard.getScoreboard();
            org.bukkit.scoreboard.Team pTeam = pBoard.getTeam(teamName);
            if (pTeam != null) {
                pTeam.removeEntry(player);
            }
        });
    }

    public static void setTextBelowNames(String t) {
        BoardManager.enableScoreboard();
        Objective objective = scoreboard.getObjective(DisplaySlot.BELOW_NAME);
        if (objective == null) {
            objective = scoreboard.registerNewObjective("dummy", "dummy");
            objective.setDisplaySlot(DisplaySlot.BELOW_NAME);
        }
        objective.setDisplayName(t);
    }

    private static void enableScoreboard() {
        if (scoreboardUsed) {
            return;
        }
        BoardManager.init();
        Bukkit.getOnlinePlayers().forEach(player -> player.setScoreboard(scoreboard));
        scoreboardUsed = true;
    }

    public static void setBelowNameScore(String player, int score) {
        if (!scoreboardUsed) {
            throw new IllegalStateException("Cannot set below name score before text");
        }
        BoardManager.init();
        Objective objective = scoreboard.getObjective(DisplaySlot.BELOW_NAME);
        if (objective == null) {
            CodexEngine.get().warn("Failed to update below-name score since the objective is missing");
            return;
        }
        objective.getScore(player).setScore(score);
        BoardManager.getAllPlayerBoards().forEach(playerBoards -> {
            Board activeBoard = playerBoards.getActiveBoard();
            if (activeBoard == null) {
                return;
            }
            Scoreboard pBoard = activeBoard.getScoreboard();
            Objective obj = pBoard.getObjective(DisplaySlot.BELOW_NAME);
            if (obj == null) {
                obj = pBoard.registerNewObjective("dummy", "dummy");
                obj.setDisplaySlot(DisplaySlot.BELOW_NAME);
            }
            obj.getScore(player).setScore(score);
        });
    }

    public static void clearScore(String player) {
        BoardManager.init();
        scoreboard.resetScores(player);
        BoardManager.getAllPlayerBoards().forEach(playerBoards -> {
            Board activeBoard = playerBoards.getActiveBoard();
            if (activeBoard == null) {
                return;
            }
            Scoreboard pBoard = activeBoard.getScoreboard();
            pBoard.resetScores(player);
        });
    }

    public static Collection<PlayerBoards> getAllPlayerBoards() {
        return players.values();
    }

    @Deprecated
    public static void setGlobalHealthBar(String label) {
        BoardManager.setTextBelowNames(label);
    }

    public static void addGlobalScoreboard(Board board) {
        players.values().forEach(player -> player.addBoard(board));
    }

    public static void clearPluginBoards(String plugin) {
        players.values().forEach(player -> player.removeBoards(plugin));
    }

    public static void clearPlayer(String name) {
        players.remove(name.toLowerCase());
    }

    public static void update(Scoreboard update) {
        if (scoreboard == null) {
            return;
        }
        scoreboard.getTeams().forEach(team -> {
            org.bukkit.scoreboard.Team sbTeam = update.getTeam(team.getName());
            if (sbTeam == null) {
                sbTeam = update.registerNewTeam(team.getName());
            }
            sbTeam.setAllowFriendlyFire(team.allowFriendlyFire());
            sbTeam.setCanSeeFriendlyInvisibles(team.canSeeFriendlyInvisibles());
            sbTeam.setDisplayName(team.getDisplayName());
            sbTeam.setPrefix(team.getPrefix());
            sbTeam.setSuffix(team.getSuffix());
            team.getEntries().forEach(arg_0 -> ((org.bukkit.scoreboard.Team)sbTeam).addEntry(arg_0));
        });
        scoreboard.getObjectives().forEach(objective -> {
            Objective obj = update.getObjective(objective.getName());
            if (obj == null) {
                try {
                    obj = update.registerNewObjective(objective.getName(), objective.getTrackedCriteria(), objective.getDisplayName());
                }
                catch (NoSuchMethodError e) {
                    obj = update.registerNewObjective(objective.getName(), objective.getCriteria(), objective.getDisplayName());
                }
            }
            obj.setDisplaySlot(objective.getDisplaySlot());
            obj.setDisplayName(objective.getDisplayName());
            Objective finalObj = obj;
            Objects.requireNonNull(objective.getScoreboard()).getEntries().forEach(entry -> finalObj.getScore(entry).setScore(objective.getScore(entry).getScore()));
        });
    }

    static {
        scoreboardUsed = false;
    }
}

