/*
 * Decompiled with CFR 0.152.
 */
package studio.magemonkey.codex.mccore.util;

import java.util.List;
import java.util.stream.Collectors;
import org.bukkit.ChatColor;

public class TextFormatter {
    private static final String COLOR_REGEX = "([0-9a-fk-orA-FL-OR])";

    public static String format(String string) {
        if (string == null || string.isEmpty()) {
            return string;
        }
        String[] pieces = string.split("[ _]");
        StringBuilder result = new StringBuilder(pieces[0].substring(0, 1).toUpperCase() + pieces[0].substring(1).toLowerCase());
        for (int i = 1; i < pieces.length; ++i) {
            result.append(" ").append(pieces[i].substring(0, 1).toUpperCase()).append(pieces[i].substring(1).toLowerCase());
        }
        return result.toString();
    }

    public static String colorString(String string) {
        return TextFormatter.colorString(string, '&');
    }

    public static String colorString(String string, char token) {
        if (string == null) {
            return null;
        }
        return string.replaceAll(token + COLOR_REGEX, "\u00a7$1");
    }

    public static void colorString(StringBuilder sb) {
        TextFormatter.colorString(sb, '&');
    }

    public static void colorString(StringBuilder sb, char token) {
        if (sb == null) {
            return;
        }
        String t = "" + token;
        int index = sb.indexOf(t);
        while (index >= 0 && index < sb.length() - 1) {
            ChatColor color = ChatColor.getByChar((char)sb.charAt(index + 1));
            if (color != null) {
                sb.setCharAt(index, '\u00a7');
            }
            index = sb.indexOf(t, index + 1);
        }
    }

    public static List<String> colorStringList(List<String> list) {
        return TextFormatter.colorStringList(list, '&');
    }

    public static List<String> colorStringList(List<String> list, char token) {
        return list.stream().map(string -> TextFormatter.colorString(string, token)).collect(Collectors.toList());
    }
}

