/*
 * Decompiled with CFR 0.152.
 */
package studio.magemonkey.codex.mccore.util;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import org.bukkit.ChatColor;

public class TextSizer {
    private static final HashMap<Character, Byte> lengths = new HashMap<Character, Byte>(){
        {
            this.put(Character.valueOf('~'), (byte)7);
            this.put(Character.valueOf('@'), (byte)7);
            this.put(Character.valueOf('f'), (byte)5);
            this.put(Character.valueOf('k'), (byte)5);
            this.put(Character.valueOf('\"'), (byte)5);
            this.put(Character.valueOf('<'), (byte)5);
            this.put(Character.valueOf('>'), (byte)5);
            this.put(Character.valueOf('{'), (byte)5);
            this.put(Character.valueOf('}'), (byte)5);
            this.put(Character.valueOf('('), (byte)5);
            this.put(Character.valueOf(')'), (byte)5);
            this.put(Character.valueOf('*'), (byte)5);
            this.put(Character.valueOf('I'), (byte)4);
            this.put(Character.valueOf('t'), (byte)4);
            this.put(Character.valueOf(' '), (byte)4);
            this.put(Character.valueOf('['), (byte)4);
            this.put(Character.valueOf(']'), (byte)4);
            this.put(Character.valueOf('l'), (byte)3);
            this.put(Character.valueOf('\''), (byte)3);
            this.put(Character.valueOf('|'), (byte)2);
            this.put(Character.valueOf('.'), (byte)2);
            this.put(Character.valueOf(';'), (byte)2);
            this.put(Character.valueOf(':'), (byte)2);
            this.put(Character.valueOf('!'), (byte)2);
            this.put(Character.valueOf('`'), (byte)2);
            this.put(Character.valueOf(','), (byte)2);
            this.put(Character.valueOf('i'), (byte)2);
        }
    };

    public static int measureString(String message) {
        if (message == null) {
            throw new IllegalArgumentException("Invalid string - null");
        }
        int boldBonus = 0;
        boolean skip = false;
        int index = 0;
        int size = 0;
        for (char c : message.toCharArray()) {
            if (skip) {
                skip = false;
                ++index;
                continue;
            }
            if (c == '\u00a7') {
                skip = true;
                if (message.length() > index + 1) {
                    if (message.charAt(index + 1) == 'l') {
                        boldBonus = 1;
                    } else if (message.charAt(index + 1) == 'r') {
                        boldBonus = 0;
                    }
                }
            } else {
                size = lengths.containsKey(Character.valueOf(c)) ? (size += lengths.get(Character.valueOf(c)) + boldBonus) : (size += 6 + boldBonus);
            }
            ++index;
        }
        return size;
    }

    public static String expand(String message, int size, boolean front) {
        if (message == null) {
            throw new IllegalArgumentException("Invalid string - null");
        }
        int currentSize = TextSizer.measureString(message);
        if (currentSize == size) {
            return message;
        }
        if (currentSize > size) {
            throw new IllegalArgumentException("Invalid string - larger than desired size");
        }
        if (currentSize == size - 1) {
            throw new IllegalArgumentException("Invalid string - one pixel off and unable to match desired size");
        }
        if (front) {
            return TextSizer.expandFront(message, currentSize, size);
        }
        return TextSizer.expandBack(message, currentSize, size);
    }

    public static List<String> expand(List<String> messages, boolean front) {
        if (messages.size() == 0) {
            return messages;
        }
        int maxSize = 0;
        for (String message : messages) {
            int size = TextSizer.measureString(message);
            if (size <= maxSize) continue;
            maxSize = size;
        }
        maxSize += 4;
        ArrayList<String> result = new ArrayList<String>();
        for (String message : messages) {
            result.add(TextSizer.expand(message, maxSize, front));
        }
        return result;
    }

    public static String expandConsole(String message, int size, boolean front) {
        if (message == null) {
            throw new IllegalArgumentException("Invalid string - null");
        }
        int currentSize = ChatColor.stripColor((String)message).length();
        if (currentSize == size) {
            return message;
        }
        if (currentSize > size) {
            throw new IllegalArgumentException("Invalid string - larger than desired size");
        }
        StringBuilder sb = new StringBuilder(size);
        sb.append(message);
        for (int i = 0; i < size - currentSize; ++i) {
            if (front) {
                sb.insert(0, ' ');
                continue;
            }
            sb.append(' ');
        }
        return sb.toString();
    }

    private static String expandBack(String message, int currentSize, int size) {
        StringBuilder sb = new StringBuilder(message);
        while (currentSize < size - 3 && currentSize != size - 5) {
            sb.append(' ');
            currentSize += 4;
        }
        if (currentSize < size - 2) {
            sb.append(ChatColor.BLACK);
            sb.append('\'');
            currentSize += 3;
        }
        if (currentSize < size - 1) {
            sb.append(ChatColor.BLACK);
            sb.append('`');
        }
        sb.append(ChatColor.RESET);
        return sb.toString();
    }

    private static String expandFront(String message, int currentSize, int size) {
        StringBuilder sb = new StringBuilder(message);
        while (currentSize < size - 3 && currentSize != size - 5) {
            sb.insert(0, ' ');
            currentSize += 4;
        }
        if ((size - currentSize) % 2 == 1) {
            sb.insert(0, ChatColor.RESET);
            sb.insert(0, '\'');
            sb.insert(0, ChatColor.BLACK);
            currentSize += 3;
        }
        if ((size - currentSize) % 4 == 2) {
            sb.insert(0, ChatColor.RESET);
            sb.insert(0, '`');
            sb.insert(0, ChatColor.BLACK);
        }
        return sb.toString();
    }

    public static List<String> split(List<String> messages, boolean vertical, TextAlignment ... alignments) {
        int i;
        int columnCount = alignments.length;
        int rowCount = (messages.size() + columnCount - 1) / columnCount;
        String[] rows = new String[rowCount];
        for (i = 0; i < rowCount; ++i) {
            rows[i] = "";
        }
        for (i = 0; i < columnCount; ++i) {
            int j;
            List<String> column = new ArrayList<String>();
            for (j = 0; j < rowCount && i * rowCount + j < messages.size(); ++j) {
                int index = j * columnCount + i;
                if (vertical) {
                    index = j + i * rowCount;
                }
                column.add(messages.get(index));
            }
            column = TextSizer.expand(column, alignments[i] == TextAlignment.RIGHT);
            j = 0;
            while (i < column.size()) {
                int n = j;
                rows[n] = rows[n] + column.get(j);
                ++j;
            }
        }
        return Arrays.asList(rows);
    }

    public static List<String> split(String message, int maxSize) {
        String[] stringArray;
        ArrayList<String> result = new ArrayList<String>();
        if (TextSizer.measureString(message) <= maxSize) {
            result.add(message);
            return result;
        }
        if (message.contains(" ")) {
            stringArray = message.split(" ");
        } else {
            String[] stringArray2 = new String[1];
            stringArray = stringArray2;
            stringArray2[0] = message;
        }
        String[] pieces = stringArray;
        Object current = "";
        for (int i = 0; i < pieces.length; ++i) {
            if (((String)current).length() == 0) {
                while (TextSizer.measureString(pieces[i]) <= maxSize) {
                    char[] chars = pieces[i].toCharArray();
                    Object temp = "";
                    int index = 0;
                    while (TextSizer.measureString((String)temp) <= maxSize) {
                        temp = (String)temp + chars[index++];
                    }
                    result.add(((String)temp).substring(0, ((String)temp).length() - 1));
                    pieces[i] = pieces[i].substring(index - 1);
                }
                current = (String)current + pieces[i];
                continue;
            }
            String temp = (String)current + pieces[i];
            if (TextSizer.measureString(temp) > maxSize) {
                result.add((String)current);
                current = pieces[i];
                continue;
            }
            current = temp;
        }
        result.add((String)current);
        return result;
    }

    public static String createLine(String begin, String end, String fill) {
        int startingSize = TextSizer.measureString(begin) + TextSizer.measureString(end);
        int fillCount = (320 - startingSize) / TextSizer.measureString(fill);
        StringBuilder sb = new StringBuilder(begin);
        for (int i = 0; i < fillCount; ++i) {
            sb.append(fill);
        }
        sb.append(end);
        return sb.toString();
    }

    public static String createLine(String begin, String end, String fill, ChatColor fillColor) {
        int startingSize = TextSizer.measureString(begin) + TextSizer.measureString(end);
        int fillCount = (320 - startingSize) / TextSizer.measureString(fill);
        StringBuilder sb = new StringBuilder(begin);
        sb.append(fillColor);
        for (int i = 0; i < fillCount; ++i) {
            sb.append(fill);
        }
        sb.append(ChatColor.RESET);
        sb.append(end);
        return sb.toString();
    }

    public static String createLine(String middle, String fill, ChatColor fillColor) {
        int startingSize = TextSizer.measureString(middle);
        StringBuilder sb = new StringBuilder(middle);
        sb.insert(0, ChatColor.RESET);
        sb.append(fillColor);
        int fillCount = (320 - startingSize) / TextSizer.measureString(fill);
        for (int i = 0; i < fillCount / 2; ++i) {
            sb.insert(0, fill);
            sb.append(fill);
        }
        sb.insert(0, fillColor);
        return sb.toString();
    }

    public static enum TextAlignment {
        LEFT,
        RIGHT;

    }
}

