/*
 * Decompiled with CFR 0.152.
 */
package studio.magemonkey.codex.util;

import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.util.List;
import java.util.stream.Collectors;
import org.bukkit.Bukkit;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;
import org.bukkit.inventory.ItemStack;
import org.jetbrains.annotations.NotNull;
import studio.magemonkey.codex.util.ItemUT;

public class PlayerUT {
    public static void execCmd(@NotNull Player player, @NotNull String cmd) {
        Player cs = player;
        boolean op = false;
        if (cmd.startsWith("[OP]")) {
            cmd = cmd.replace("[OP]", "");
            if (!player.isOp()) {
                op = true;
                player.setOp(op);
            }
        } else if (cmd.startsWith("[CONSOLE]")) {
            cmd = cmd.replace("[CONSOLE]", "");
            cs = Bukkit.getConsoleSender();
        }
        cmd = cmd.trim().replace("%player%", player.getName());
        Bukkit.dispatchCommand((CommandSender)cs, (String)cmd);
        if (op) {
            player.setOp(false);
        }
    }

    @NotNull
    public static List<String> getPlayerNames() {
        List<String> list = Bukkit.getServer().getOnlinePlayers().stream().map(Player::getName).collect(Collectors.toList());
        return list;
    }

    @NotNull
    public static String getIP(@NotNull Player player) {
        InetSocketAddress inet = player.getAddress();
        return inet == null ? "null" : PlayerUT.getIP(inet.getAddress());
    }

    @NotNull
    public static String getIP(@NotNull InetAddress inet) {
        return inet.toString().replace("\\/", "").replace("/", "");
    }

    public static void setExp(@NotNull Player player, long amount) {
        if ((amount += (long)PlayerUT.getTotalExperience(player)) > Integer.MAX_VALUE) {
            amount = Integer.MAX_VALUE;
        }
        if (amount < 0L) {
            amount = 0L;
        }
        PlayerUT.setTotalExperience(player, (int)amount);
    }

    public static void setTotalExperience(@NotNull Player player, int exp) {
        if (exp < 0) {
            throw new IllegalArgumentException("Experience is negative!");
        }
        player.setExp(0.0f);
        player.setLevel(0);
        player.setTotalExperience(0);
        int amount = exp;
        while (amount > 0) {
            int expToLevel = PlayerUT.getExpAtLevel(player);
            if ((amount -= expToLevel) >= 0) {
                player.giveExp(expToLevel);
                continue;
            }
            player.giveExp(amount += expToLevel);
            amount = 0;
        }
    }

    private static int getExpAtLevel(@NotNull Player player) {
        return PlayerUT.getExpAtLevel(player.getLevel());
    }

    public static int getExpAtLevel(int level) {
        if (level <= 15) {
            return 2 * level + 7;
        }
        if (level >= 16 && level <= 30) {
            return 5 * level - 38;
        }
        return 9 * level - 158;
    }

    public static int getExpToLevel(int level) {
        int exp = 0;
        for (int currentLevel = 0; currentLevel < level; ++currentLevel) {
            exp += PlayerUT.getExpAtLevel(currentLevel);
        }
        if (exp < 0) {
            exp = Integer.MAX_VALUE;
        }
        return exp;
    }

    public static int getTotalExperience(@NotNull Player player) {
        int exp = Math.round((float)PlayerUT.getExpAtLevel(player) * player.getExp());
        int currentLevel = player.getLevel();
        while (currentLevel > 0) {
            exp += PlayerUT.getExpAtLevel(--currentLevel);
        }
        if (exp < 0) {
            exp = Integer.MAX_VALUE;
        }
        return exp;
    }

    public static int getExpUntilNextLevel(@NotNull Player player) {
        int exp = Math.round((float)PlayerUT.getExpAtLevel(player) * player.getExp());
        int nextLevel = player.getLevel();
        return PlayerUT.getExpAtLevel(nextLevel) - exp;
    }

    public static boolean hasEmptyInventory(@NotNull Player player) {
        for (ItemStack item : player.getInventory().getContents()) {
            if (ItemUT.isAir(item)) continue;
            return false;
        }
        return true;
    }

    public static int countItem(@NotNull Player player, @NotNull ItemStack item) {
        int userHas = 0;
        for (ItemStack itemHas : player.getInventory().getContents()) {
            if (ItemUT.isAir(itemHas) || !itemHas.isSimilar(item)) continue;
            userHas += itemHas.getAmount();
        }
        return userHas;
    }
}

