/*
 * Decompiled with CFR 0.152.
 */
package studio.magemonkey.codex.util;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.zip.ZipEntry;
import java.util.zip.ZipOutputStream;

public class Zipper {
    private List<String> filesListInDir = new ArrayList<String>();

    public static void createBackupZip(File dir) {
        String date = new SimpleDateFormat("dd-MM-yyyy").format(new Date());
        String zipDirName = dir.getName() + "_backup_" + date + ".zip";
        Zipper zipFiles = new Zipper();
        zipFiles.zipDirectory(dir, zipDirName);
    }

    private void zipDirectory(File dir, String zipDirName) {
        try {
            this.populateFilesList(dir);
            FileOutputStream fos = new FileOutputStream(zipDirName);
            ZipOutputStream zos = new ZipOutputStream(fos);
            for (String filePath : this.filesListInDir) {
                int len;
                ZipEntry ze = new ZipEntry(filePath.substring(dir.getAbsolutePath().length() + 1, filePath.length()));
                zos.putNextEntry(ze);
                FileInputStream fis = new FileInputStream(filePath);
                byte[] buffer = new byte[1024];
                while ((len = fis.read(buffer)) > 0) {
                    zos.write(buffer, 0, len);
                }
                zos.closeEntry();
                fis.close();
            }
            zos.close();
            fos.close();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    private void populateFilesList(File dir) throws IOException {
        File[] files;
        for (File file : files = dir.listFiles()) {
            if (file.isFile()) {
                this.filesListInDir.add(file.getAbsolutePath());
                continue;
            }
            this.populateFilesList(file);
        }
    }
}

