/*
 * Decompiled with CFR 0.152.
 */
package studio.magemonkey.codex.util.actions;

import com.google.common.collect.Sets;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.UnaryOperator;
import me.clip.placeholderapi.PlaceholderAPI;
import org.bukkit.entity.Entity;
import org.bukkit.entity.Player;
import org.jetbrains.annotations.NotNull;
import studio.magemonkey.codex.CodexPlugin;
import studio.magemonkey.codex.config.api.JYML;
import studio.magemonkey.codex.hooks.Hooks;
import studio.magemonkey.codex.util.actions.ActionSection;
import studio.magemonkey.codex.util.actions.actions.IActionExecutor;
import studio.magemonkey.codex.util.actions.conditions.IConditionValidator;
import studio.magemonkey.codex.util.actions.params.IParamResult;
import studio.magemonkey.codex.util.actions.targets.ITargetSelector;

public class ActionManipulator {
    private CodexPlugin<?> plugin;
    private Map<String, ActionSection> actions;

    public ActionManipulator(@NotNull CodexPlugin<?> plugin, @NotNull ActionManipulator copy) {
        this.plugin = plugin;
        this.actions = new LinkedHashMap<String, ActionSection>();
        for (Map.Entry<String, ActionSection> en : copy.getActions().entrySet()) {
            this.actions.put(en.getKey(), new ActionSection(en.getValue()));
        }
    }

    public ActionManipulator(@NotNull CodexPlugin<?> plugin, @NotNull JYML cfg, @NotNull String path) {
        this.plugin = plugin;
        this.actions = new LinkedHashMap<String, ActionSection>();
        for (String id : cfg.getSection(path)) {
            String path2 = path + "." + id + ".";
            if (!cfg.getSection(path2 + "target-selectors").isEmpty()) {
                ArrayList selectorsUpdated = new ArrayList();
                for (String selectorId : cfg.getSection(path2 + "target-selectors")) {
                    List selectors = cfg.getStringList(path2 + "target-selectors." + selectorId);
                    selectors.replaceAll(str -> str + " ~name: " + selectorId + ";");
                    selectorsUpdated.addAll(selectors);
                }
                cfg.set(path2 + "target-selectors", null);
                cfg.set(path2 + "target-selectors", selectorsUpdated);
                cfg.saveChanges();
            }
            List targetSelectors = cfg.getStringList(path2 + "target-selectors");
            List conditionList = cfg.getStringList(path2 + "conditions.list");
            String conditionActionOnFail = cfg.getString(path2 + "conditions.actions-on-fail", "");
            List actionExecutors = cfg.getStringList(path2 + "action-executors");
            ActionSection engine = new ActionSection(targetSelectors, conditionList, conditionActionOnFail, actionExecutors);
            this.actions.put(id.toLowerCase(), engine);
        }
    }

    @NotNull
    public ActionManipulator replace(@NotNull UnaryOperator<String> func) {
        ActionManipulator manipulatorCopy = new ActionManipulator(this.plugin, this);
        for (ActionSection copyEngine : manipulatorCopy.getActions().values()) {
            copyEngine.getActionExecutors().replaceAll(func);
            copyEngine.getConditions().replaceAll(func);
            copyEngine.getTargetSelectors().replaceAll(func);
        }
        return manipulatorCopy;
    }

    @NotNull
    public Map<String, ActionSection> getActions() {
        return this.actions;
    }

    public void process(@NotNull Entity exec) {
        this.process(exec, Collections.emptyMap());
    }

    public void process(@NotNull Entity exec, @NotNull Map<String, Set<Entity>> targetMap2) {
        if (this.actions.isEmpty()) {
            return;
        }
        String id = new ArrayList<String>(this.actions.keySet()).get(0);
        this.process(exec, id, targetMap2);
    }

    public void process(@NotNull Entity exec, @NotNull String id) {
        this.process(exec, id, Collections.emptyMap());
    }

    public void process(@NotNull Entity exec, @NotNull String id, @NotNull Map<String, Set<Entity>> targetMap2) {
        String key;
        ActionSection ae = this.actions.get(id.toLowerCase());
        if (ae == null) {
            return;
        }
        HashMap<String, Set<Entity>> targetMap = new HashMap<String, Set<Entity>>();
        targetMap2.forEach((fromKey, fromVal) -> targetMap.merge((String)fromKey, (Set<Entity>)fromVal, (old, now) -> {
            HashSet set = new HashSet(old);
            set.addAll(now);
            return set;
        }));
        Player p = null;
        if (Hooks.hasPlugin("PlaceholderAPI") && exec instanceof Player) {
            p = (Player)exec;
        }
        for (String selector : ae.getTargetSelectors()) {
            if (p != null) {
                selector = PlaceholderAPI.setPlaceholders((Player)p, (String)selector);
            }
            String selectorKey = selector.split(" ")[0].replace("[", "").replace("]", "");
            ITargetSelector targetSelector = this.plugin.getActionsManager().getTargetSelector(selectorKey);
            if (targetSelector == null) {
                this.plugin.error("Invalid target selector '" + selectorKey + "' in '" + selector + "' !");
                continue;
            }
            IParamResult result = targetSelector.getParamResult(selector);
            String targetId = result.getParamValue("NAME").getString("default");
            HashSet<Entity> targets = new HashSet<Entity>();
            targetSelector.select(exec, targets, selector);
            targetMap.merge(targetId, targets, (old, now) -> {
                HashSet set = new HashSet(old);
                set.addAll(now);
                return set;
            });
        }
        for (String condition : ae.getConditions()) {
            if (p != null) {
                condition = PlaceholderAPI.setPlaceholders((Player)p, (String)condition);
            }
            key = condition.split(" ")[0].replace("[", "").replace("]", "");
            IConditionValidator validator = this.plugin.getActionsManager().getConditionValidator(key);
            if (validator == null) {
                this.plugin.error("Invalid condition validator '" + key + "' in '" + condition + "' !");
                continue;
            }
            if (validator.process(exec, targetMap, condition, this)) continue;
            this.process(exec, ae.getConditionFailActions());
            return;
        }
        for (String action : ae.getActionExecutors()) {
            if (p != null) {
                action = PlaceholderAPI.setPlaceholders((Player)p, (String)action);
            }
            key = action.split(" ")[0].replace("[", "").replace("]", "");
            IActionExecutor executor = this.plugin.getActionsManager().getActionExecutor(key);
            if (executor == null) {
                this.plugin.error("Invalid action executor '" + key + "' in '" + action + "' !");
                continue;
            }
            executor.process(exec, targetMap, action, this);
        }
    }

    public static boolean processConditions(@NotNull CodexPlugin<?> plugin, @NotNull Entity exec, @NotNull List<String> condis) {
        return ActionManipulator.processConditions(plugin, exec, condis, Collections.emptyMap());
    }

    public static boolean processConditions(@NotNull CodexPlugin<?> plugin, @NotNull Entity exec, @NotNull List<String> condis, @NotNull Map<String, Set<Entity>> targetMap2) {
        HashMap<String, Set<Entity>> targetMap = new HashMap<String, Set<Entity>>();
        targetMap.put("default", Sets.newHashSet((Object[])new Entity[]{exec}));
        targetMap2.forEach((fromKey, fromVal) -> targetMap.merge((String)fromKey, (Set<Entity>)fromVal, (old, now) -> {
            HashSet set = new HashSet(old);
            set.addAll(now);
            return set;
        }));
        Player p = null;
        if (Hooks.hasPlugin("PlaceholderAPI") && exec instanceof Player) {
            p = (Player)exec;
        }
        for (String condition : condis) {
            if (p != null) {
                condition = PlaceholderAPI.setPlaceholders((Player)p, (String)condition);
            }
            String key = condition.split(" ")[0].replace("[", "").replace("]", "");
            IConditionValidator validator = plugin.getActionsManager().getConditionValidator(key);
            if (validator == null) {
                plugin.error("Invalid condition validator '" + key + "' in '" + condition + "' !");
                continue;
            }
            if (validator.process(exec, targetMap, condition)) continue;
            return false;
        }
        return true;
    }
}

