/*
 * Decompiled with CFR 0.152.
 */
package studio.magemonkey.codex.util.actions.actions.list;

import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.bukkit.entity.Entity;
import org.bukkit.entity.EntityType;
import org.bukkit.entity.Player;
import org.bukkit.plugin.Plugin;
import org.bukkit.scheduler.BukkitRunnable;
import org.jetbrains.annotations.NotNull;
import studio.magemonkey.codex.CodexPlugin;
import studio.magemonkey.codex.util.StringUT;
import studio.magemonkey.codex.util.actions.actions.IActionExecutor;
import studio.magemonkey.codex.util.actions.params.IParamResult;

public class Action_ProgressBar
extends IActionExecutor {
    public Action_ProgressBar(@NotNull CodexPlugin<?> plugin) {
        super(plugin, "PROGRESS_BAR");
    }

    @Override
    @NotNull
    public List<String> getDescription() {
        return this.plugin.lang().Codex_Editor_Actions_Action_ProgressBar_Desc.asList();
    }

    @Override
    public void registerParams() {
        this.registerParam("TARGET");
        this.registerParam("DURATION");
        this.registerParam("TITLES_TITLE");
        this.registerParam("TITLES_SUBTITLE");
        this.registerParam("BAR_COLOR_EMPTY");
        this.registerParam("BAR_COLOR_FILL");
    }

    @Override
    protected void execute(@NotNull Entity exe, @NotNull Set<Entity> targets, @NotNull IParamResult result) {
        int dura = (int)((double)result.getParamValue("DURATION").getInt(0) / 20.0);
        if (dura <= 0) {
            return;
        }
        String title = result.getParamValue("TITLES_TITLE").getString("");
        String subtitle = result.getParamValue("TITLES_SUBTITLE").getString("");
        String c1 = result.getParamValue("BAR_COLOR_EMPTY").getString("");
        String c2 = result.getParamValue("BAR_COLOR_FILL").getString("");
        HashSet<Player> users = new HashSet<Player>();
        for (Entity e : targets) {
            if (e.getType() != EntityType.PLAYER) continue;
            Player p = (Player)e;
            users.add(p);
        }
        this.playAnimDelay(users, dura, title, subtitle, c1, c2);
    }

    @Override
    public boolean mustHaveTarget() {
        return true;
    }

    private void playAnimDelay(Set<Player> p, int time, String title, String ch, String c1, String c2) {
        double pers = 20 / time;
        double step = 20.0 / pers;
        AnimDelay a = new AnimDelay(p, (int)step, title, ch, c1, c2);
        a.runTaskTimer((Plugin)this.plugin, 0L, (int)step);
    }

    public static class AnimDelay
    extends BukkitRunnable {
        private Set<Player> players;
        private int progress = 0;
        private int step;
        private String title;
        private String c1;
        private String c2;
        private String bar;

        public AnimDelay(Set<Player> p, int step, String title, String ch, String c1, String c2) {
            this.players = p;
            this.step = step;
            this.title = StringUT.color(title);
            this.c1 = StringUT.color(c1);
            this.c2 = StringUT.color(c2);
            StringBuffer sb = new StringBuffer();
            for (int i = 0; i < 20; ++i) {
                sb.insert(i, ch);
            }
            this.bar = sb.toString();
        }

        public void run() {
            if (this.progress >= 20) {
                this.cancel();
                return;
            }
            this.paintBar();
            ++this.progress;
        }

        private void paintBar() {
            String kist = this.bar;
            StringBuffer sb = new StringBuffer(kist);
            sb.setLength(sb.length());
            sb.insert(0, this.c2);
            if (this.progress < 20) {
                sb.insert(this.progress + this.c1.length() + 1, this.c1);
            }
            kist = sb.toString();
            for (Player pl : this.players) {
                pl.sendTitle(this.title, kist, 0, this.step, 20);
            }
        }
    }
}

