/*
 * Decompiled with CFR 0.152.
 */
package studio.magemonkey.codex.util.messages;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import net.md_5.bungee.api.chat.BaseComponent;
import net.md_5.bungee.api.chat.TextComponent;
import org.bukkit.Bukkit;
import org.bukkit.ChatColor;
import org.bukkit.command.CommandSender;
import org.bukkit.configuration.ConfigurationSection;
import org.bukkit.configuration.file.FileConfiguration;
import org.bukkit.plugin.Plugin;
import org.jetbrains.annotations.NotNull;
import studio.magemonkey.codex.CodexEngine;
import studio.magemonkey.codex.bungee.BungeeUtil;
import studio.magemonkey.codex.legacy.placeholder.PlaceholderItem;
import studio.magemonkey.codex.legacy.placeholder.PlaceholderType;
import studio.magemonkey.codex.legacy.riseitem.DarkRiseItem;
import studio.magemonkey.codex.legacy.utils.ComponentUtils;
import studio.magemonkey.codex.util.ItemUtils;
import studio.magemonkey.codex.util.messages.MessageData;

public class MessageUtil {
    public static Map<String, Object> messages = new HashMap<String, Object>();

    public static void load(FileConfiguration config, Plugin plugin) {
        MessageUtil.reload(config, plugin);
    }

    public static void reload(FileConfiguration config, Plugin plugin) {
        Map<String, Object> temp = MessageUtil.getMessages((ConfigurationSection)config);
        for (String s : temp.keySet()) {
            messages.remove(s);
        }
        messages.putAll(temp);
        CodexEngine.get().getLogger().info("Mapped all language data for " + plugin.getName() + ".");
    }

    public static Map<String, Object> getMessages(@NotNull ConfigurationSection section) {
        HashMap<String, Object> temp = new HashMap<String, Object>();
        for (String entry : section.getValues(false).keySet()) {
            String id;
            String string = id = section.getCurrentPath().trim().isEmpty() ? entry : section.getCurrentPath() + "." + entry;
            if (section.get(entry) instanceof ConfigurationSection) {
                temp.putAll(MessageUtil.getMessages((ConfigurationSection)section.get(entry)));
                continue;
            }
            if (section.get(entry) instanceof ArrayList) {
                temp.put(id, section.get(entry));
                continue;
            }
            if (section.get(entry).toString().contains("\n")) {
                ArrayList<String> array = new ArrayList<String>(Arrays.asList(section.get(entry).toString().split("\n")));
                temp.put(id, array);
                continue;
            }
            temp.put(id, section.get(entry).toString());
        }
        return temp;
    }

    public static void sendMessage(CommandSender player, BaseComponent ... comps) {
        ArrayList<BaseComponent> send = new ArrayList<BaseComponent>();
        for (BaseComponent component : comps) {
            if (component instanceof TextComponent && ((TextComponent)component).getText().equalsIgnoreCase("\n")) {
                player.spigot().sendMessage(send.toArray(new BaseComponent[0]));
                send.clear();
                continue;
            }
            send.add(component);
        }
        if (!send.isEmpty()) {
            player.spigot().sendMessage(send.toArray(new BaseComponent[0]));
        }
    }

    public static void sendMessage(String key, CommandSender player, MessageData ... replace) {
        BaseComponent[] comps = MessageUtil.getMessageAsComponent(key, replace);
        MessageUtil.sendMessage(player, comps);
    }

    public static List<String> getString(String key) {
        ArrayList<String> ret = new ArrayList<String>();
        if (!messages.containsKey(key)) {
            ret.add(key);
            return ret;
        }
        Object msg = messages.get(key);
        if (msg == null) {
            ret.add(key);
        } else {
            try {
                ((List)msg).forEach(e -> ret.add((String)e));
            }
            catch (ClassCastException e2) {
                ret.add(msg.toString());
            }
        }
        return ItemUtils.fixColors(ret);
    }

    public static BaseComponent[] getMessageAsComponent(String path, MessageData ... replace) {
        ArrayList<Object> components = new ArrayList<Object>();
        List<String> msgs = MessageUtil.getString(path);
        HashMap placeholders = new HashMap();
        Map data = Arrays.stream(replace).collect(Collectors.toMap(MessageData::getName, messageData -> messageData, (a, b) -> b, HashMap::new));
        Pattern pat = Pattern.compile("\\$<(.*?)>");
        msgs.stream().map(pat::matcher).forEach(mat -> {
            while (mat.find()) {
                PlaceholderItem it = PlaceholderType.getQualifiedItem(mat.group(1));
                if (it == null) continue;
                String id = "$<" + mat.group(1) + ">";
                placeholders.put(id, it);
            }
        });
        for (String send : msgs) {
            BaseComponent[] comps;
            if (send.equalsIgnoreCase("false")) continue;
            for (BaseComponent component : comps = ComponentUtils.fromLegacyText(send)) {
                for (Map.Entry entry : placeholders.entrySet()) {
                    PlaceholderItem holder = (PlaceholderItem)entry.getValue();
                    String id = (String)entry.getKey();
                    if (!component.toPlainText().contains(id)) continue;
                    Object translated = holder.apply(((MessageData)data.get(holder.getType().getId())).getObject(), null);
                    if (translated instanceof BaseComponent) {
                        ComponentUtils.replace(component, id, (BaseComponent)translated);
                        continue;
                    }
                    ComponentUtils.replace(component, id, translated.toString());
                }
                for (MessageData datum : replace) {
                    String check = "$<" + datum.getName() + ">";
                    if (!component.toPlainText().contains(check)) continue;
                    if (datum.getObject() instanceof BaseComponent) {
                        ComponentUtils.replace(component, check, (BaseComponent)datum.getObject());
                        continue;
                    }
                    ComponentUtils.replace(component, check, datum.getObject().toString());
                }
                components.add(component);
            }
            if (msgs.size() <= 1) continue;
            components.add(new TextComponent("\n"));
        }
        return components.toArray(new BaseComponent[0]);
    }

    public static String getMessageAsString(String path, String def, MessageData ... data) {
        return MessageUtil.getMessageAsString(path, def, false, data);
    }

    public static String getMessageAsString(String path, String def, boolean stripColor, MessageData ... data) {
        if (!messages.containsKey(path)) {
            path = def;
        }
        BaseComponent[] strs = MessageUtil.getMessageAsComponent(path, data);
        StringBuilder bob = new StringBuilder();
        for (BaseComponent str : strs) {
            bob.append(str.toLegacyText());
        }
        return stripColor ? ChatColor.stripColor((String)bob.toString()) : bob.toString();
    }

    public static String getReplacement(String string) {
        string = "$<" + (String)string + ">";
        return string;
    }

    private static MessageData[] translateSpecial(MessageData ... data) {
        ArrayList<MessageData> rep = new ArrayList<MessageData>();
        for (MessageData md : data) {
            if (md.getName().equalsIgnoreCase("item")) {
                DarkRiseItem it = (DarkRiseItem)md.getObject();
                rep.add(new MessageData("riseItem.name", it.getName()));
                rep.add(new MessageData("riseItem.id", it.getId()));
                continue;
            }
            rep.add(md);
        }
        return rep.toArray(new MessageData[0]);
    }

    public static void broadcastMessage(String key, MessageData ... data) {
        Bukkit.getServer().getOnlinePlayers().forEach(online -> MessageUtil.sendMessage(key, (CommandSender)online, data));
        MessageUtil.sendMessage(key, (CommandSender)Bukkit.getConsoleSender(), data);
    }

    public static void broadcastNetworkMessage(String key, MessageData ... data) {
        if (!CodexEngine.IS_BUNGEE) {
            MessageUtil.broadcastMessage(key, data);
        } else {
            BungeeUtil.broadcastMessage(MessageUtil.getMessageAsString(key, key, false, data));
        }
    }
}

