/*
 * Decompiled with CFR 0.152.
 */
package studio.magemonkey.codex.util.reflection;

import com.google.common.collect.Multimap;
import com.mojang.authlib.GameProfile;
import io.netty.channel.Channel;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataInput;
import java.io.DataInputStream;
import java.io.DataOutput;
import java.io.DataOutputStream;
import java.lang.reflect.Constructor;
import java.lang.reflect.Method;
import java.math.BigInteger;
import java.util.AbstractList;
import java.util.Collection;
import java.util.Random;
import org.bukkit.Location;
import org.bukkit.World;
import org.bukkit.block.Block;
import org.bukkit.block.Chest;
import org.bukkit.entity.Player;
import org.bukkit.inventory.ItemStack;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import studio.magemonkey.codex.CodexEngine;
import studio.magemonkey.codex.util.Reflex;
import studio.magemonkey.codex.util.random.Rnd;
import studio.magemonkey.codex.util.reflection.ReflectionManager;
import studio.magemonkey.codex.util.reflection.ReflectionUtil;

public class DefaultReflectionUtil
implements ReflectionUtil {
    @Override
    public Object newNBTTagCompound() {
        try {
            Class<?> nbtTagClass = this.getNMSClass("NBTTagCompound");
            return nbtTagClass.getConstructor(new Class[0]).newInstance(new Object[0]);
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    @Override
    public Object newNBTTagList() {
        try {
            Class<?> nbtTagClass = this.getNMSClass("NBTTagList");
            return nbtTagClass.getConstructor(new Class[0]).newInstance(new Object[0]);
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    @Override
    public ItemStack toBukkitCopy(Object nmsItem) {
        try {
            Class<?> craftItem = this.getCraftClass("inventory.CraftItemStack");
            Method asBukkitCopy = Reflex.getMethod(craftItem, "asBukkitCopy", this.getNMSClass("ItemStack"));
            if (asBukkitCopy == null) {
                return null;
            }
            return (ItemStack)Reflex.invokeMethod(asBukkitCopy, null, nmsItem);
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    @Override
    public Object save(Object nmsItem, Object nbtCompound) {
        try {
            Method save = Reflex.getMethod(nmsItem.getClass(), "save", nbtCompound.getClass());
            return Reflex.invokeMethod(save, nmsItem, nbtCompound);
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    @Override
    public Object getConnection(Player player) {
        try {
            Class<?> craftPlayerClass = this.getCraftClass("entity.CraftPlayer");
            Method getHandle = Reflex.getMethod(craftPlayerClass, "getHandle", new Class[0]);
            Object nmsPlayer = Reflex.invokeMethod(getHandle, this.getCraftPlayer(player), new Object[0]);
            Object con = Reflex.getFieldValue(nmsPlayer, "playerConnection");
            return con;
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    @Override
    public Object getEntity(Object craftEntity) {
        try {
            Class<?> craftClass = this.getNMSClass("Entity");
            Method getHandle = Reflex.getMethod(craftClass, "getHandle", new Class[0]);
            return craftClass.cast(getHandle.invoke(craftEntity, new Object[0]));
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    @Override
    public Channel getChannel(Player p) {
        try {
            Object conn = this.getConnection(p);
            Object manager = Reflex.getFieldValue(conn, "networkManager");
            Channel channel = (Channel)Reflex.getFieldValue(manager, "channel");
            return channel;
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    @Override
    public void sendPacket(Player p, Object packet) {
        Object conn = this.getConnection(p);
        Class<?> packetClass = null;
        try {
            packetClass = this.getNMSClass("Packet");
        }
        catch (ClassNotFoundException e) {
            e.printStackTrace();
        }
        Method sendMethod = Reflex.getMethod(conn.getClass(), "sendPacket", packetClass);
        Reflex.invokeMethod(sendMethod, conn, packet);
    }

    @Override
    public void sendAttackPacket(Player p, int id) {
        try {
            Object craftPlayer = this.getCraftPlayer(p);
            Object entity = this.getEntity(craftPlayer);
            Class<?> packetClass = this.getNMSClass("PacketPlayOutAnimation");
            Constructor<?> ctor = Reflex.getConstructor(packetClass, entity.getClass(), Integer.TYPE);
            Object packet = Reflex.invokeConstructor(ctor, entity, id);
            this.sendPacket(p, packet);
        }
        catch (ClassNotFoundException e) {
            CodexEngine.get().getLogger().warning("Could not send attack packet.");
            e.printStackTrace();
        }
    }

    @Override
    public void openChestAnimation(Block chest, boolean open) {
        if (chest.getState() instanceof Chest) {
            Location lo = chest.getLocation();
            World bWorld = lo.getWorld();
            if (bWorld == null) {
                return;
            }
            try {
                Class<?> worldClass = this.getNMSClass("World");
                Class<?> craftWorld = this.getCraftClass("CraftWorld");
                Class<?> blockClass = this.getNMSClass("Block");
                Class<?> blockPosClass = this.getNMSClass("BlockPosition");
                Object nmsWorld = worldClass.cast(bWorld);
                Method getHandle = ReflectionManager.MINOR_VERSION >= 8 ? Reflex.getMethod(nmsWorld.getClass(), "getWorld", new Class[0]) : Reflex.getMethod(nmsWorld.getClass(), "getHandle", new Class[0]);
                Object world = craftWorld.cast(Reflex.invokeMethod(getHandle, nmsWorld, new Object[0]));
                Method playBlockAction = Reflex.getMethod(craftWorld, "playBlockAction", blockPosClass, blockClass, Integer.TYPE, Integer.TYPE);
                Constructor<?> ctor = Reflex.getConstructor(blockPosClass, Double.TYPE, Double.TYPE, Double.TYPE);
                Object position = Reflex.invokeConstructor(ctor, lo.getX(), lo.getY(), lo.getZ());
                Method getType = Reflex.getMethod(world.getClass(), "getType", blockPosClass);
                Class<?> blockData = this.getNMSClass("IBlockData");
                Object data = blockData.cast(Reflex.invokeMethod(getType, world, position));
                Method getBlock = Reflex.getMethod(blockData, "getBlock", new Class[0]);
                Reflex.invokeMethod(playBlockAction, world, position, getBlock.invoke(data, new Object[0]), 1, open ? 1 : 0);
            }
            catch (Exception e) {
                CodexEngine.get().getLogger().warning("Problem sending chest animation");
                e.printStackTrace();
            }
        }
    }

    @Override
    public String toBase64(@NotNull ItemStack item) {
        try {
            ByteArrayOutputStream outputStream = new ByteArrayOutputStream();
            DataOutputStream dataOutput = new DataOutputStream(outputStream);
            Object nbtTagListItems = this.newNBTTagList();
            Object nbtTagCompoundItem = this.newNBTTagCompound();
            Object nmsItem = this.getNMSCopy(item);
            this.save(nmsItem, nbtTagCompoundItem);
            Method add = Reflex.getMethod(AbstractList.class, "add", Object.class);
            Reflex.invokeMethod(add, nbtTagListItems, nbtTagCompoundItem);
            Class<?> compressedClass = this.getNMSClass("NBTCompressedStreamTools");
            Method a = Reflex.getMethod(compressedClass, "a", nbtTagCompoundItem.getClass(), DataOutput.class);
            Reflex.invokeMethod(a, null, nbtTagCompoundItem, dataOutput);
            String str = new BigInteger(1, outputStream.toByteArray()).toString(32);
            return str;
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    @Override
    public ItemStack fromBase64(@NotNull String data) {
        try {
            Class<?> compressedClass;
            ByteArrayInputStream inputStream = new ByteArrayInputStream(new BigInteger(data, 32).toByteArray());
            try {
                compressedClass = this.getNMSClass("NBTCompressedStreamTools");
            }
            catch (ClassNotFoundException e) {
                compressedClass = Reflex.getClass("net.minecraft.nbt", "NBTCompressedStreamTools");
            }
            Method nbtA = Reflex.getMethod(compressedClass, "a", DataInput.class);
            Object nbtTagCompoundRoot = Reflex.invokeMethod(nbtA, null, new DataInputStream(inputStream));
            Class<?> nmsItemClass = this.getNMSClass("ItemStack");
            Class<?> compoundClass = this.getNMSClass("NBTTagCompound");
            Method a = Reflex.getMethod(nmsItemClass, "a", compoundClass);
            Object nmsItem = Reflex.invokeMethod(a, null, nbtTagCompoundRoot);
            Method asBukkitCopy = Reflex.getMethod(this.getCraftClass("inventory.CraftItemStack"), "asBukkitCopy", nmsItemClass);
            ItemStack item = (ItemStack)Reflex.invokeMethod(asBukkitCopy, null, nmsItem);
            return item;
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    @Override
    public ItemStack damageItem(@NotNull ItemStack item, int amount, @Nullable Player player) {
        try {
            Object nmsStack = this.getNMSCopy(item);
            Object nmsPlayer = player != null ? this.getEntity(this.getCraftPlayer(player)) : null;
            Method isDamaged = Reflex.getMethod(nmsStack.getClass(), "a", Integer.TYPE, Random.class, this.getNMSClass("EntityPlayer"));
            Reflex.invokeMethod(isDamaged, nmsStack, amount, Rnd.rnd, nmsPlayer);
            return this.toBukkitCopy(nmsStack);
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    public Multimap<Object, Object> getAttributes(@NotNull ItemStack itemStack) {
        try {
            Method a;
            Object tool;
            Object nmsItem = this.getNMSCopy(itemStack);
            Method getItem = Reflex.getMethod(nmsItem.getClass(), ReflectionManager.MINOR_VERSION > 17 ? "c" : "getItem", new Class[0]);
            Object item = Reflex.invokeMethod(getItem, nmsItem, new Object[0]);
            Class<?> enumItemSlotClass = this.getNMSClass("EnumItemSlot");
            Class<?> itemArmorClass = this.getNMSClass("ItemArmor");
            Class<?> itemToolClass = this.getNMSClass("ItemTool");
            Class<?> itemSwordClass = this.getNMSClass("ItemSword");
            Class<?> itemTridentClass = this.getNMSClass("ItemTrident");
            Enum mainhand = (Enum)Reflex.invokeMethod(Reflex.getMethod(enumItemSlotClass, "fromName", String.class), null, "mainhand");
            if (itemArmorClass.isInstance(item)) {
                Object tool2 = itemArmorClass.cast(item);
                Method b = Reflex.getMethod(itemArmorClass, "b", new Class[0]);
                Object bObj = Reflex.invokeMethod(b, tool2, new Object[0]);
                Method a2 = Reflex.getMethod(itemArmorClass, "a", enumItemSlotClass);
                return (Multimap)Reflex.invokeMethod(a2, tool2, bObj);
            }
            if (itemToolClass.isInstance(item)) {
                tool = itemToolClass.cast(item);
                a = Reflex.getMethod(itemToolClass, "a", enumItemSlotClass);
            } else if (itemSwordClass.isInstance(item)) {
                tool = itemSwordClass.cast(item);
                a = Reflex.getMethod(itemSwordClass, "a", enumItemSlotClass);
            } else if (itemTridentClass.isInstance(item)) {
                tool = itemTridentClass.cast(item);
                a = Reflex.getMethod(itemTridentClass, "a", enumItemSlotClass);
            } else {
                return null;
            }
            return (Multimap)Reflex.invokeMethod(a, tool, mainhand);
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    @Override
    public double getAttributeValue(@NotNull ItemStack item, @NotNull Object attribute) {
        double value = 0.0;
        try {
            Class<?> attributeModifierClass = this.getNMSClass("AttributeModifier");
            if (attribute.getClass().getSuperclass().getSimpleName().equals("IAttribute")) {
                Class<?> iAttributeClass = this.getNMSClass("IAttribute");
                Multimap<Object, Object> attMap = this.getAttributes(item);
                if (attMap == null) {
                    return 0.0;
                }
                Object atkDmg = iAttributeClass.cast(attribute);
                Method getName = Reflex.getMethod(iAttributeClass, "getName", new Class[0]);
                Collection att = attMap.get(Reflex.invokeMethod(getName, atkDmg, new Object[0]));
                Object mod = attributeModifierClass.cast(att == null || att.isEmpty() ? Integer.valueOf(0) : att.stream().findFirst().get());
                Method getAmount = Reflex.getMethod(attributeModifierClass, "getAmount", new Class[0]);
                value = (Double)Reflex.invokeMethod(getAmount, mod, new Object[0]);
            } else if (this.getNMSClass("AttributeBase").isInstance(attribute)) {
                Object mod;
                Class<?> attributeBaseClass = this.getNMSClass("AttributeBase");
                Multimap<Object, Object> attMap = this.getAttributes(item);
                if (attMap == null) {
                    return 0.0;
                }
                Collection att = attMap.get(attributeBaseClass.cast(attribute));
                Object v0 = mod = att != null && !att.isEmpty() ? attributeModifierClass.cast(att.stream().findFirst().get()) : null;
                if (mod != null) {
                    Method getAmount = Reflex.getMethod(attributeModifierClass, "getAmount", new Class[0]);
                    value = (Double)Reflex.invokeMethod(getAmount, mod, new Object[0]);
                } else {
                    value = 0.0;
                }
            }
            if (attribute.equals(this.getGenericAttribute("ATTACK_DAMAGE"))) {
                value += 1.0;
            } else if (attribute.equals(this.getGenericAttribute("ATTACK_SPEED"))) {
                value += 4.0;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return value;
    }

    @Override
    public double getDefaultDamage(@NotNull ItemStack itemStack) {
        return this.getAttributeValue(itemStack, this.getGenericAttribute("ATTACK_DAMAGE"));
    }

    @Override
    public double getDefaultSpeed(@NotNull ItemStack itemStack) {
        return this.getAttributeValue(itemStack, this.getGenericAttribute("ATTACK_SPEED"));
    }

    @Override
    public double getDefaultArmor(@NotNull ItemStack itemStack) {
        return this.getAttributeValue(itemStack, this.getGenericAttribute("ARMOR"));
    }

    @Override
    public double getDefaultToughness(@NotNull ItemStack itemStack) {
        return this.getAttributeValue(itemStack, this.getGenericAttribute("ARMOR_TOUGHNESS"));
    }

    @Override
    public Object getGenericAttribute(String field) {
        try {
            Class<?> attributes = this.getNMSClass("GenericAttributes");
            Object value = Reflex.getField(attributes, field).get(null);
            return value;
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    @Override
    public boolean isWeapon(@NotNull ItemStack itemStack) {
        try {
            Object nmsItem = this.getNMSCopy(itemStack);
            Method getItem = Reflex.getMethod(nmsItem.getClass(), "getItem", new Class[0]);
            Object item = Reflex.invokeMethod(getItem, nmsItem, new Object[0]);
            Class<?> swordClass = this.getNMSClass("ItemSword");
            Class<?> axeClass = this.getNMSClass("ItemAxe");
            Class<?> tridentClass = this.getNMSClass("ItemTrident");
            return swordClass.isInstance(item) || axeClass.isInstance(item) || tridentClass.isInstance(item);
        }
        catch (Exception e) {
            e.printStackTrace();
            return false;
        }
    }

    @Override
    public boolean isTool(@NotNull ItemStack itemStack) {
        try {
            Object nmsItem = this.getNMSCopy(itemStack);
            Method getItem = Reflex.getMethod(nmsItem.getClass(), "getItem", new Class[0]);
            Object item = Reflex.invokeMethod(getItem, nmsItem, new Object[0]);
            Class<?> toolClass = this.getNMSClass("ItemTool");
            return toolClass.isInstance(item);
        }
        catch (Exception e) {
            e.printStackTrace();
            return false;
        }
    }

    @Override
    public boolean isArmor(@NotNull ItemStack itemStack) {
        try {
            Object nmsItem = this.getNMSCopy(itemStack);
            Method getItem = Reflex.getMethod(nmsItem.getClass(), "getItem", new Class[0]);
            Object item = Reflex.invokeMethod(getItem, nmsItem, new Object[0]);
            Class<?> toolClass = this.getNMSClass("ItemArmor");
            return toolClass.isInstance(item);
        }
        catch (Exception e) {
            e.printStackTrace();
            return false;
        }
    }

    @Override
    public String fixColors(@NotNull String str) {
        try {
            Class<?> baseComponentClass;
            str = str.replace("\n", "%n%");
            try {
                baseComponentClass = this.getNMSClass("IChatBaseComponent");
            }
            catch (ClassNotFoundException e) {
                baseComponentClass = Reflex.getClass("net.minecraft.network.chat", "IChatBaseComponent");
            }
            Class<?> chatMessageClass = this.getCraftClass("util.CraftChatMessage");
            Method fromComponent = Reflex.getMethod(chatMessageClass, "fromComponent", baseComponentClass);
            Method fromStringOrNull = Reflex.getMethod(chatMessageClass, "fromStringOrNull", String.class);
            Object baseComponent = Reflex.invokeMethod(fromStringOrNull, null, str);
            String singleColor = (String)Reflex.invokeMethod(fromComponent, null, baseComponentClass.cast(baseComponent));
            return singleColor.replace("%n%", "\n");
        }
        catch (Exception e) {
            e.printStackTrace();
            return str;
        }
    }

    @Override
    public float getAttackCooldown(Player p) {
        try {
            Class<?> entityPlayerClass = this.getNMSClass("EntityPlayer");
            Class<?> entityHumanClass = this.getNMSClass("EntityHuman");
            Object craftPlayer = this.getCraftPlayer(p);
            Method getHandle = Reflex.getMethod(craftPlayer.getClass(), "getHandle", new Class[0]);
            Object ep = entityPlayerClass.cast(Reflex.invokeMethod(getHandle, craftPlayer, new Object[0]));
            if (ReflectionManager.MINOR_VERSION < 16) {
                Method s = Reflex.getMethod(entityHumanClass, "s", Float.TYPE);
                if (s == null) {
                    throw new NullPointerException("Could not find a \"s\" method using Reflection.");
                }
                return ((Float)Reflex.invokeMethod(s, entityHumanClass.cast(ep), Float.valueOf(0.0f))).floatValue();
            }
            Method getAttackCooldown = Reflex.getMethod(entityHumanClass, "getAttackCooldown", Float.TYPE);
            if (getAttackCooldown == null) {
                throw new NullPointerException("Could not find a \"getAttackCooldown\" method using Reflection.");
            }
            return ((Float)Reflex.invokeMethod(getAttackCooldown, entityHumanClass.cast(ep), Float.valueOf(0.0f))).floatValue();
        }
        catch (Exception e) {
            e.printStackTrace();
            return 0.0f;
        }
    }

    @Override
    public void changeSkull(Block b, String hash) {
        try {
            Class<?> tileSkullClass = this.getNMSClass("TileEntitySkull");
            Class<?> craftWorldClass = this.getCraftClass("CraftWorld");
            Class<?> blockAccessClass = this.getNMSClass("IBlockAccess");
            Class<?> blockPosClass = this.getNMSClass("BlockPosition");
            Constructor<?> ctor = Reflex.getConstructor(blockPosClass, Integer.TYPE, Integer.TYPE, Integer.TYPE);
            Method getHandle = Reflex.getMethod(craftWorldClass, "getHandle", new Class[0]);
            Method getTileEntity = Reflex.getMethod(blockAccessClass, "getTileEntity", blockPosClass);
            Object bPos = Reflex.invokeConstructor(ctor, b.getX(), b.getY(), b.getZ());
            Object worldServer = Reflex.invokeMethod(getHandle, craftWorldClass.cast(b.getWorld()), new Object[0]);
            Object skullTile = tileSkullClass.cast(Reflex.invokeMethod(getTileEntity, worldServer, bPos));
            Method setGameProfile = Reflex.getMethod(tileSkullClass, "setGameProfile", GameProfile.class);
            Reflex.invokeMethod(setGameProfile, skullTile, this.getNonPlayerProfile(hash));
            b.getState().update(true);
        }
        catch (Exception e) {
            CodexEngine.get().getLogger().warning("Could not update skull");
            e.printStackTrace();
        }
    }
}

