/*
 * Decompiled with CFR 0.152.
 */
package studio.magemonkey.codex.util.reflection;

import com.google.common.collect.Multimap;
import com.mojang.authlib.GameProfile;
import com.mojang.authlib.properties.Property;
import io.netty.channel.Channel;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.Collection;
import java.util.UUID;
import org.bukkit.Bukkit;
import org.bukkit.block.Block;
import org.bukkit.entity.LivingEntity;
import org.bukkit.entity.Player;
import org.bukkit.inventory.ItemStack;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import studio.magemonkey.codex.CodexEngine;
import studio.magemonkey.codex.core.Version;
import studio.magemonkey.codex.util.Reflex;
import studio.magemonkey.codex.util.reflection.ReflectionManager;

public interface ReflectionUtil {
    public Object newNBTTagCompound();

    public Object newNBTTagList();

    default public Object getNMSCopy(ItemStack item) {
        try {
            Class<?> craftItemClass = this.getCraftClass("inventory.CraftItemStack");
            Method asNMSCopy = Reflex.getMethod(craftItemClass, "asNMSCopy", ItemStack.class);
            return Reflex.invokeMethod(asNMSCopy, null, item);
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    public ItemStack toBukkitCopy(Object var1);

    public Object save(Object var1, Object var2);

    default public Class<?> getNMSClass(String nmsClassName) throws ClassNotFoundException {
        String version = ReflectionManager.VERSION + ".";
        String name = "net.minecraft.server." + version + nmsClassName;
        Class<?> nmsClass = Class.forName(name);
        return nmsClass;
    }

    default public Class<?> getCraftClass(String craftClassName) throws ClassNotFoundException {
        String pkg = Bukkit.getServer().getClass().getPackage().getName();
        String name = pkg + "." + craftClassName;
        Class<?> craftClass = Class.forName(name);
        return craftClass;
    }

    public Object getConnection(Player var1);

    default public Object getCraftPlayer(Player player) {
        try {
            Class<?> craftClass = this.getCraftClass("entity.CraftPlayer");
            return craftClass.cast(player);
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    public Object getEntity(Object var1);

    public Channel getChannel(Player var1);

    default public void sendPackets(Player player, Collection<Object> packets) {
        for (Object packet : packets) {
            this.sendPacket(player, packet);
        }
    }

    public void sendPacket(Player var1, Object var2);

    public void sendAttackPacket(Player var1, int var2);

    public void openChestAnimation(Block var1, boolean var2);

    default public String toJson(@NotNull ItemStack item) {
        try {
            Object nbtCompound = this.newNBTTagCompound();
            Object nmsItem = this.getNMSCopy(item);
            nbtCompound = this.save(nmsItem, nbtCompound);
            Method toString = Reflex.getMethod(nbtCompound.getClass(), "toString", new Class[0]);
            String js = (String)Reflex.invokeMethod(toString, nbtCompound, new Object[0]);
            if (js.length() > Short.MAX_VALUE) {
                ItemStack item2 = new ItemStack(item.getType());
                return this.toJson(item2);
            }
            return js;
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    public String toBase64(@NotNull ItemStack var1);

    public ItemStack fromBase64(@NotNull String var1);

    default public String getNbtString(@NotNull ItemStack item) {
        try {
            Object nmsCopy = this.getNMSCopy(item);
            Method getOrCreateTag = Reflex.getMethod(nmsCopy.getClass(), "getOrCreateTag", new Class[0]);
            Object tag = Reflex.invokeMethod(getOrCreateTag, nmsCopy, new Object[0]);
            Method asString = Reflex.getMethod(tag.getClass(), "asString", new Class[0]);
            return (String)Reflex.invokeMethod(asString, tag, new Object[0]);
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    public ItemStack damageItem(@NotNull ItemStack var1, int var2, @Nullable Player var3);

    public Multimap<?, ?> getAttributes(@NotNull ItemStack var1);

    public double getAttributeValue(@NotNull ItemStack var1, @NotNull Object var2);

    public double getDefaultDamage(@NotNull ItemStack var1);

    public double getDefaultSpeed(@NotNull ItemStack var1);

    public double getDefaultArmor(@NotNull ItemStack var1);

    public double getDefaultToughness(@NotNull ItemStack var1);

    public Object getGenericAttribute(String var1);

    public boolean isWeapon(@NotNull ItemStack var1);

    public boolean isTool(@NotNull ItemStack var1);

    public boolean isArmor(@NotNull ItemStack var1);

    public String fixColors(@NotNull String var1);

    public float getAttackCooldown(Player var1);

    public void changeSkull(Block var1, String var2);

    default public GameProfile getNonPlayerProfile(String hash) {
        UUID uid = UUID.randomUUID();
        GameProfile profile = new GameProfile(uid, uid.toString().substring(0, 8));
        profile.getProperties().put((Object)"textures", (Object)new Property("textures", hash));
        return profile;
    }

    default public void setKiller(LivingEntity entity, Player player) {
        try {
            Class<?> living = ReflectionManager.MINOR_VERSION >= 17 ? Reflex.getClass("net.minecraft.world.entity.EntityLiving") : Reflex.getNMSClass("EntityLiving");
            Method handle = Reflex.getCraftClass("entity.CraftEntity").getDeclaredMethod("getHandle", new Class[0]);
            Field killer = living.getDeclaredField(this.getKillerField());
            Field damageTime = living.getDeclaredField(this.getDamageTimeField());
            killer.setAccessible(true);
            damageTime.setAccessible(true);
            Object hit = handle.invoke((Object)entity, new Object[0]);
            Object source = handle.invoke((Object)player, new Object[0]);
            killer.set(hit, source);
            damageTime.set(hit, 100);
        }
        catch (Exception e) {
            CodexEngine.get().error("Could not set killer.");
            e.printStackTrace();
        }
    }

    default public String getNetworkManagerFieldName() {
        return switch (Version.CURRENT) {
            case Version.V1_16_R3 -> "networkManager";
            case Version.V1_17_R1, Version.V1_18_R1, Version.V1_18_R2 -> "a";
            case Version.V1_19_R1, Version.V1_19_R2 -> "b";
            case Version.V1_20_R2, Version.V1_20_R3 -> "c";
            case Version.V1_20_R4, Version.V1_21_R1 -> "e";
            default -> "h";
        };
    }

    default public String getChannelFieldName() {
        return switch (Version.CURRENT) {
            case Version.V1_16_R3 -> "channel";
            case Version.V1_17_R1, Version.V1_18_R1 -> "k";
            case Version.V1_20_R2, Version.V1_20_R3, Version.V1_20_R4, Version.V1_21_R1 -> "n";
            default -> "m";
        };
    }

    default public String getAttackCooldownMethodName() {
        return switch (Version.CURRENT) {
            case Version.V1_16_R3, Version.V1_17_R1 -> "getAttackCooldown";
            case Version.V1_18_R1, Version.V1_18_R2, Version.V1_19_R1 -> "v";
            case Version.V1_19_R2 -> "w";
            case Version.V1_19_R3 -> "z";
            case Version.V1_20_R2, Version.V1_20_R3 -> "B";
            case Version.V1_20_R4 -> "D";
            case Version.V1_21_R1 -> "F";
            default -> "A";
        };
    }

    default public String getKillerField() {
        return switch (Version.CURRENT) {
            case Version.V1_16_R3 -> "killer";
            case Version.V1_17_R1, Version.V1_18_R1, Version.V1_18_R2, Version.V1_19_R1, Version.V1_19_R2, Version.V1_20_R4, Version.V1_21_R1 -> "bc";
            case Version.V1_19_R3 -> "aX";
            case Version.V1_20_R2, Version.V1_20_R3 -> "aY";
            default -> "aZ";
        };
    }

    default public String getDamageTimeField() {
        return switch (Version.CURRENT) {
            case Version.V1_16_R3 -> "lastDamageByPlayerTime";
            case Version.V1_17_R1, Version.V1_18_R1, Version.V1_18_R2, Version.V1_19_R1, Version.V1_19_R2, Version.V1_20_R4, Version.V1_21_R1 -> "bd";
            case Version.V1_19_R3 -> "aY";
            case Version.V1_20_R2, Version.V1_20_R3 -> "aZ";
            default -> "ba";
        };
    }

    default public String getRegistryAccessMethodName() {
        return switch (Version.CURRENT) {
            case Version.V1_16_R3 -> "getServer";
            case Version.V1_17_R1, Version.V1_18_R1, Version.V1_18_R2, Version.V1_19_R1, Version.V1_19_R2, Version.V1_20_R2, Version.V1_20_R3, Version.V1_20_R4, Version.V1_21_R1, Version.V1_19_R3 -> "bc";
            default -> "b";
        };
    }
}

