/*
 * Decompiled with CFR 0.152.
 */
package studio.magemonkey.codex.util.reflection;

import com.google.common.collect.Multimap;
import com.mojang.authlib.GameProfile;
import io.netty.channel.Channel;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataInput;
import java.io.DataInputStream;
import java.io.DataOutput;
import java.io.DataOutputStream;
import java.lang.reflect.Constructor;
import java.lang.reflect.Method;
import java.math.BigInteger;
import java.util.AbstractList;
import java.util.Collection;
import java.util.Random;
import org.bukkit.Location;
import org.bukkit.World;
import org.bukkit.block.Block;
import org.bukkit.block.Chest;
import org.bukkit.block.Skull;
import org.bukkit.entity.Player;
import org.bukkit.inventory.ItemStack;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import studio.magemonkey.codex.CodexEngine;
import studio.magemonkey.codex.core.Version;
import studio.magemonkey.codex.util.Reflex;
import studio.magemonkey.codex.util.random.Rnd;
import studio.magemonkey.codex.util.reflection.ReflectionManager;
import studio.magemonkey.codex.util.reflection.ReflectionUtil;

public class Reflection_1_17
implements ReflectionUtil {
    private static final String DAMAGE_ATTRIBUTE = "f";
    private static final String SPEED_ATTRIBUTE = "h";
    private static final String ARMOR_ATTRIBUTE = "i";
    private static final String TOUGHNESS_ATTRIBUTE = "j";

    @Override
    public Object newNBTTagCompound() {
        try {
            Class<?> nbtTagClass = this.getClazz("net.minecraft.nbt.NBTTagCompound");
            return nbtTagClass.getConstructor(new Class[0]).newInstance(new Object[0]);
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    @Override
    public Object newNBTTagList() {
        try {
            Class<?> nbtTagClass = this.getClazz("net.minecraft.nbt.NBTTagList");
            return nbtTagClass.getConstructor(new Class[0]).newInstance(new Object[0]);
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    @Override
    public ItemStack toBukkitCopy(Object nmsItem) {
        try {
            Class<?> craftItem = this.getCraftClass("inventory.CraftItemStack");
            Method asBukkitCopy = Reflex.getMethod(craftItem, "asBukkitCopy", this.getClazz("net.minecraft.world.item.ItemStack"));
            if (asBukkitCopy == null) {
                return null;
            }
            return (ItemStack)Reflex.invokeMethod(asBukkitCopy, null, nmsItem);
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    @Override
    public Object save(Object nmsItem, Object nbtCompound) {
        try {
            Method save = Reflex.getMethod(nmsItem.getClass(), "save", nbtCompound.getClass());
            return Reflex.invokeMethod(save, nmsItem, nbtCompound);
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    public Class<?> getClazz(String classString) throws ClassNotFoundException {
        String name = classString;
        Class<?> clazz = Class.forName(name);
        return clazz;
    }

    @Override
    public Object getEntity(Object craftEntity) {
        try {
            Class<?> craftClass = this.getClazz("net.minecraft.world.entity.Entity");
            Class<?> craftEntityClass = this.getCraftClass("org.bukkit.entity.Entity");
            Method getHandle = Reflex.getMethod(craftEntityClass, "getHandle", new Class[0]);
            return craftClass.cast(getHandle.invoke(craftEntity, new Object[0]));
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    @Override
    public Channel getChannel(Player p) {
        String managerFieldName = this.getNetworkManagerFieldName();
        String channelFieldName = this.getChannelFieldName();
        Object conn = null;
        Object manager = null;
        Object channel = null;
        try {
            conn = this.getConnection(p);
            manager = Reflex.getFieldValue(conn, managerFieldName);
            channel = Reflex.getFieldValue(manager, channelFieldName);
            return (Channel)channel;
        }
        catch (ClassCastException e) {
            CodexEngine.get().error("Could not setup Channel for player.\n\nConnection: " + conn.toString() + "\nUsing Manager Field Name: " + managerFieldName + "\nManager: " + manager.toString() + "\nChannel Field name: " + channelFieldName + "\nChannel: " + channel.toString() + "\n");
            e.printStackTrace();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return null;
    }

    @Override
    public Object getConnection(Player player) {
        try {
            Class<?> craftPlayerClass = this.getCraftClass("entity.CraftPlayer");
            Method getHandle = Reflex.getMethod(craftPlayerClass, "getHandle", new Class[0]);
            Object nmsPlayer = Reflex.invokeMethod(getHandle, this.getCraftPlayer(player), new Object[0]);
            String fieldName = "b";
            Object con = Reflex.getFieldValue(nmsPlayer, fieldName);
            if (!con.getClass().getSimpleName().equals("PlayerConnection") && !con.getClass().getSimpleName().equals("GeneratedInterceptor")) {
                throw new ClassNotFoundException("Could not get connection from CraftPlayer using field " + fieldName + "\nNMS Player: " + String.valueOf(nmsPlayer) + "\n");
            }
            return con;
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    @Override
    public void sendPacket(Player p, Object packet) {
        Object conn = this.getConnection(p);
        Class<?> packetClass = null;
        try {
            packetClass = this.getClazz("net.minecraft.network.protocol.Packet");
        }
        catch (ClassNotFoundException e) {
            e.printStackTrace();
        }
        Method sendPacket = ReflectionManager.MINOR_VERSION == 17 ? Reflex.getMethod(conn.getClass(), "sendPacket", packetClass) : Reflex.getMethod(conn.getClass(), "a", packetClass);
        Reflex.invokeMethod(sendPacket, conn, packet);
    }

    @Override
    public void sendAttackPacket(Player p, int id) {
        try {
            Object craftPlayer = this.getCraftPlayer(p);
            Object entity = this.getEntity(craftPlayer);
            Class<?> packetClass = this.getClazz("net.minecraft.network.protocol.game.PacketPlayOutAnimation");
            Constructor<?> ctor = Reflex.getConstructor(packetClass, entity.getClass(), Integer.TYPE);
            Object packet = Reflex.invokeConstructor(ctor, entity, id);
            this.sendPacket(p, packet);
        }
        catch (ClassNotFoundException e) {
            CodexEngine.get().getLogger().warning("Could not send attack packet.");
            e.printStackTrace();
        }
    }

    @Override
    public void openChestAnimation(Block chest, boolean open) {
        if (chest.getState() instanceof Chest) {
            Location lo = chest.getLocation();
            World bWorld = lo.getWorld();
            if (bWorld == null) {
                return;
            }
            try {
                Class<?> worldClass = this.getClazz("net.minecraft.world.level.World");
                Class<?> craftWorld = this.getCraftClass("CraftWorld");
                Class<?> blockClass = this.getClazz("net.minecraft.world.level.block.Block");
                Class<?> blockPosClass = this.getClazz("net.minecraft.core.BlockPosition");
                Object cWorld = craftWorld.cast(bWorld);
                Method getHandle = Reflex.getMethod(cWorld.getClass(), "getHandle", new Class[0]);
                Object world = worldClass.cast(Reflex.invokeMethod(getHandle, cWorld, new Object[0]));
                Method playBlockAction = Reflex.getMethod(worldClass, ReflectionManager.MINOR_VERSION == 17 ? "playBlockAction" : "a", blockPosClass, blockClass, Integer.TYPE, Integer.TYPE);
                Constructor<?> ctor = Reflex.getConstructor(blockPosClass, Integer.TYPE, Integer.TYPE, Integer.TYPE);
                Object position = Reflex.invokeConstructor(ctor, (int)lo.getX(), (int)lo.getY(), (int)lo.getZ());
                Method getType = Reflex.getMethod(world.getClass(), ReflectionManager.MINOR_VERSION == 17 ? "getType" : "a_", blockPosClass);
                Class<?> blockData = this.getClazz("net.minecraft.world.level.block.state.IBlockData");
                Object data = blockData.cast(Reflex.invokeMethod(getType, world, position));
                Method getBlock = Reflex.getMethod(blockData, ReflectionManager.MINOR_VERSION == 17 ? "getBlock" : "b", new Class[0]);
                Reflex.invokeMethod(playBlockAction, world, position, getBlock.invoke(data, new Object[0]), 1, open ? 1 : 0);
            }
            catch (Exception e) {
                CodexEngine.get().getLogger().warning("Problem sending chest animation");
                e.printStackTrace();
            }
        }
    }

    @Override
    public String toBase64(@NotNull ItemStack item) {
        try {
            ByteArrayOutputStream outputStream = new ByteArrayOutputStream();
            DataOutputStream dataOutput = new DataOutputStream(outputStream);
            Object nbtTagListItems = this.newNBTTagList();
            Object nbtTagCompoundItem = this.newNBTTagCompound();
            Object nmsItem = this.getNMSCopy(item);
            this.save(nmsItem, nbtTagCompoundItem);
            Method add = Reflex.getMethod(AbstractList.class, "add", Object.class);
            Reflex.invokeMethod(add, nbtTagListItems, nbtTagCompoundItem);
            Class<?> compressedClass = this.getClazz("net.minecraft.nbt.NBTCompressedStreamTools");
            Method a = Reflex.getMethod(compressedClass, "a", nbtTagCompoundItem.getClass(), DataOutput.class);
            Reflex.invokeMethod(a, null, nbtTagCompoundItem, dataOutput);
            String str = new BigInteger(1, outputStream.toByteArray()).toString(32);
            return str;
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    @Override
    public ItemStack fromBase64(@NotNull String data) {
        try {
            Object nbtTagCompoundRoot;
            ByteArrayInputStream inputStream = new ByteArrayInputStream(new BigInteger(data, 32).toByteArray());
            try {
                Class<?> compressedClass = this.getClazz("net.minecraft.nbt.NBTCompressedStreamTools");
                Method a = Reflex.getMethod(compressedClass, "a", DataInput.class);
                nbtTagCompoundRoot = Reflex.invokeMethod(a, null, new DataInputStream(inputStream));
            }
            catch (ClassNotFoundException e) {
                e.printStackTrace();
                return null;
            }
            Class<?> nmsItemClass = this.getClazz("net.minecraft.world.item.ItemStack");
            Class<?> compoundClass = this.getClazz("net.minecraft.nbt.NBTTagCompound");
            Method a = Reflex.getMethod(nmsItemClass, "a", compoundClass);
            Object nmsItem = Reflex.invokeMethod(a, null, nbtTagCompoundRoot);
            Method asBukkitCopy = Reflex.getMethod(this.getCraftClass("inventory.CraftItemStack"), "asBukkitCopy", nmsItemClass);
            ItemStack item = (ItemStack)Reflex.invokeMethod(asBukkitCopy, null, nmsItem);
            return item;
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    @Override
    public ItemStack damageItem(@NotNull ItemStack item, int amount, @Nullable Player player) {
        try {
            Object nmsPlayer;
            Object nmsStack = this.getNMSCopy(item);
            Object object = nmsPlayer = player != null ? this.getEntity(this.getCraftPlayer(player)) : null;
            if (ReflectionManager.MINOR_VERSION == 19) {
                Class<?> randSourceClass = this.getClazz("net.minecraft.util.RandomSource");
                Method isDamaged = Reflex.getMethod(nmsStack.getClass(), "a", Integer.TYPE, randSourceClass, this.getClazz("net.minecraft.server.level.EntityPlayer"));
                Object randSource = Reflex.invokeMethod(Reflex.getMethod(randSourceClass, "c", new Class[0]), null, new Object[0]);
                Reflex.invokeMethod(isDamaged, nmsStack, amount, randSource, nmsPlayer);
            } else {
                Method isDamaged = Reflex.getMethod(nmsStack.getClass(), ReflectionManager.MINOR_VERSION == 17 ? "isDamaged" : "a", Integer.TYPE, Random.class, this.getClazz("net.minecraft.server.level.EntityPlayer"));
                Reflex.invokeMethod(isDamaged, nmsStack, amount, Rnd.rnd, nmsPlayer);
            }
            return this.toBukkitCopy(nmsStack);
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    @Override
    public Multimap<?, ?> getAttributes(@NotNull ItemStack itemStack) {
        try {
            Method getDefaultAttributeModifiers;
            Object tool;
            Object nmsItem = this.getNMSCopy(itemStack);
            Method getItem = Reflex.getMethod(nmsItem.getClass(), ReflectionManager.MINOR_VERSION > 17 ? "c" : "getItem", new Class[0]);
            Object item = Reflex.invokeMethod(getItem, nmsItem, new Object[0]);
            Class<?> enumItemSlotClass = this.getClazz("net.minecraft.world.entity.EnumItemSlot");
            Class<?> itemArmorClass = this.getClazz("net.minecraft.world.item.ItemArmor");
            Class<?> itemToolClass = this.getClazz("net.minecraft.world.item.ItemTool");
            Class<?> itemSwordClass = this.getClazz("net.minecraft.world.item.ItemSword");
            Class<?> itemTridentClass = this.getClazz("net.minecraft.world.item.ItemTrident");
            Enum mainhand = (Enum)Reflex.invokeMethod(Reflex.getMethod(enumItemSlotClass, ReflectionManager.MINOR_VERSION <= 17 ? "fromName" : "a", String.class), null, "mainhand");
            if (itemArmorClass.isInstance(item)) {
                Object tool2 = itemArmorClass.cast(item);
                Method getEquipmentSlot = Reflex.getMethod(itemArmorClass, "b", new Class[0]);
                Object armorEquipmentSlot = Reflex.invokeMethod(getEquipmentSlot, tool2, new Object[0]);
                if (Version.V1_19_R3.isCurrent()) {
                    armorEquipmentSlot = Reflex.invokeMethod(Reflex.getMethod(armorEquipmentSlot.getClass(), "a", new Class[0]), armorEquipmentSlot, new Object[0]);
                }
                Method getDefaultAttributeModifiers2 = Reflex.getMethod(itemArmorClass, "a", enumItemSlotClass);
                return (Multimap)Reflex.invokeMethod(getDefaultAttributeModifiers2, tool2, armorEquipmentSlot);
            }
            if (itemToolClass.isInstance(item)) {
                tool = itemToolClass.cast(item);
                getDefaultAttributeModifiers = Reflex.getMethod(itemToolClass, "a", enumItemSlotClass);
            } else if (itemSwordClass.isInstance(item)) {
                tool = itemSwordClass.cast(item);
                getDefaultAttributeModifiers = Reflex.getMethod(itemSwordClass, "a", enumItemSlotClass);
            } else if (itemTridentClass.isInstance(item)) {
                tool = itemTridentClass.cast(item);
                getDefaultAttributeModifiers = Reflex.getMethod(itemTridentClass, "a", enumItemSlotClass);
            } else {
                return null;
            }
            return (Multimap)Reflex.invokeMethod(getDefaultAttributeModifiers, tool, mainhand);
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    @Override
    public double getAttributeValue(@NotNull ItemStack item, @NotNull Object attribute) {
        try {
            Class<?> attributeModifierClass = this.getClazz("net.minecraft.world.entity.ai.attributes.AttributeModifier");
            Class<?> attributeBaseClass = this.getClazz("net.minecraft.world.entity.ai.attributes.AttributeBase");
            Multimap<?, ?> attMap = this.getAttributes(item);
            if (attMap == null || attMap.isEmpty()) {
                return 0.0;
            }
            Collection att = attMap.get(attributeBaseClass.cast(attribute));
            if (att == null || att.isEmpty()) {
                return 0.0;
            }
            Object mod = attributeModifierClass.cast(att.stream().findFirst().get());
            Method getAmount = Reflex.getMethod(attributeModifierClass, ReflectionManager.MINOR_VERSION == 17 ? "getAmount" : (Version.CURRENT == Version.V1_20_R3 ? "c" : "d"), new Class[0]);
            double value = (Double)Reflex.invokeMethod(getAmount, mod, new Object[0]);
            if (attribute.equals(this.getGenericAttribute(DAMAGE_ATTRIBUTE))) {
                value += 1.0;
            }
            return value;
        }
        catch (Exception e) {
            e.printStackTrace();
            return 0.0;
        }
    }

    @Override
    public double getDefaultDamage(@NotNull ItemStack itemStack) {
        return this.getAttributeValue(itemStack, this.getGenericAttribute(DAMAGE_ATTRIBUTE));
    }

    @Override
    public double getDefaultSpeed(@NotNull ItemStack itemStack) {
        return this.getAttributeValue(itemStack, this.getGenericAttribute(SPEED_ATTRIBUTE));
    }

    @Override
    public double getDefaultArmor(@NotNull ItemStack itemStack) {
        return this.getAttributeValue(itemStack, this.getGenericAttribute(ARMOR_ATTRIBUTE));
    }

    @Override
    public double getDefaultToughness(@NotNull ItemStack itemStack) {
        return this.getAttributeValue(itemStack, this.getGenericAttribute(TOUGHNESS_ATTRIBUTE));
    }

    @Override
    public Object getGenericAttribute(String field) {
        try {
            Class<?> attributes = this.getClazz("net.minecraft.world.entity.ai.attributes.GenericAttributes");
            Object value = Reflex.getField(attributes, field).get(null);
            if (Version.CURRENT.isAtLeast(Version.V1_20_R4)) {
                value = Reflex.invokeMethod(Reflex.getMethod(value.getClass(), "a", new Class[0]), value, new Object[0]);
            }
            return value;
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    @Override
    public boolean isWeapon(@NotNull ItemStack itemStack) {
        try {
            Object nmsItem = this.getNMSCopy(itemStack);
            Method getItem = Reflex.getMethod(nmsItem.getClass(), "getItem", new Class[0]);
            Object item = Reflex.invokeMethod(getItem, nmsItem, new Object[0]);
            Class<?> swordClass = this.getClazz("net.minecraft.world.item.ItemSword");
            Class<?> axeClass = this.getClazz("net.minecraft.world.item.ItemAxe");
            Class<?> tridentClass = this.getClazz("net.minecraft.world.item.ItemTrident");
            return swordClass.isInstance(item) || axeClass.isInstance(item) || tridentClass.isInstance(item);
        }
        catch (Exception e) {
            e.printStackTrace();
            return false;
        }
    }

    @Override
    public boolean isTool(@NotNull ItemStack itemStack) {
        try {
            Object nmsItem = this.getNMSCopy(itemStack);
            Method getItem = Reflex.getMethod(nmsItem.getClass(), "getItem", new Class[0]);
            Object item = Reflex.invokeMethod(getItem, nmsItem, new Object[0]);
            Class<?> toolClass = this.getClazz("net.minecraft.world.item.ItemTool");
            return toolClass.isInstance(item);
        }
        catch (Exception e) {
            e.printStackTrace();
            return false;
        }
    }

    @Override
    public boolean isArmor(@NotNull ItemStack itemStack) {
        try {
            Object nmsItem = this.getNMSCopy(itemStack);
            Method getItem = Reflex.getMethod(nmsItem.getClass(), "getItem", new Class[0]);
            Object item = Reflex.invokeMethod(getItem, nmsItem, new Object[0]);
            Class<?> armorClass = this.getClazz("net.minecraft.world.item.ItemArmor");
            return armorClass.isInstance(item);
        }
        catch (Exception e) {
            e.printStackTrace();
            return false;
        }
    }

    @Override
    public String fixColors(@NotNull String str) {
        try {
            str = str.replace("\n", "%n%");
            Class<?> baseComponentClass = this.getClazz("net.minecraft.network.chat.IChatBaseComponent");
            Class<?> chatMessageClass = this.getCraftClass("util.CraftChatMessage");
            Method fromComponent = Reflex.getMethod(chatMessageClass, "fromComponent", baseComponentClass);
            Method fromStringOrNull = Reflex.getMethod(chatMessageClass, "fromStringOrNull", String.class);
            Object baseComponent = Reflex.invokeMethod(fromStringOrNull, null, str);
            String singleColor = (String)Reflex.invokeMethod(fromComponent, null, baseComponentClass.cast(baseComponent));
            return singleColor.replace("%n%", "\n");
        }
        catch (Exception e) {
            e.printStackTrace();
            return str;
        }
    }

    @Override
    public float getAttackCooldown(Player p) {
        try {
            Class<?> entityPlayerClass = this.getClazz("net.minecraft.server.level.EntityPlayer");
            Class<?> entityHumanClass = this.getClazz("net.minecraft.world.entity.player.EntityHuman");
            Object craftPlayer = this.getCraftPlayer(p);
            Method getHandle = Reflex.getMethod(craftPlayer.getClass(), "getHandle", new Class[0]);
            Object ep = entityPlayerClass.cast(Reflex.invokeMethod(getHandle, craftPlayer, new Object[0]));
            Method getAttackCooldown = Reflex.getMethod(entityHumanClass, this.getAttackCooldownMethodName(), Float.TYPE);
            if (getAttackCooldown == null) {
                throw new NullPointerException("Could not find a \"getAttackCooldown\" method using Reflection. Attempting " + this.getAttackCooldownMethodName() + "(float)");
            }
            return ((Float)Reflex.invokeMethod(getAttackCooldown, entityHumanClass.cast(ep), Float.valueOf(0.0f))).floatValue();
        }
        catch (Exception e) {
            e.printStackTrace();
            return 0.0f;
        }
    }

    @Override
    public void changeSkull(Block b, String hash) {
        try {
            if (!(b.getState() instanceof Skull)) {
                return;
            }
            Skull skull = (Skull)b.getState();
            GameProfile profile = this.getNonPlayerProfile(hash);
            Reflex.setFieldValue(skull, "profile", profile);
            skull.update();
        }
        catch (Exception e) {
            CodexEngine.get().getLogger().warning("Could not update skull");
            e.printStackTrace();
        }
    }
}

