/*
 * Decompiled with CFR 0.152.
 */
package studio.magemonkey.codex.util.reflection;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataInput;
import java.io.DataInputStream;
import java.io.DataOutput;
import java.io.DataOutputStream;
import java.lang.reflect.Method;
import java.math.BigInteger;
import java.util.AbstractList;
import org.bukkit.Material;
import org.bukkit.entity.Player;
import org.bukkit.inventory.ItemStack;
import org.jetbrains.annotations.NotNull;
import studio.magemonkey.codex.CodexEngine;
import studio.magemonkey.codex.core.Version;
import studio.magemonkey.codex.util.Reflex;
import studio.magemonkey.codex.util.reflection.Reflection_1_18;

public class Reflection_1_20
extends Reflection_1_18 {
    @Override
    public Object getConnection(Player player) {
        try {
            Class<?> craftPlayerClass = this.getCraftClass("entity.CraftPlayer");
            Method getHandle = Reflex.getMethod(craftPlayerClass, "getHandle", new Class[0]);
            Object nmsPlayer = Reflex.invokeMethod(getHandle, this.getCraftPlayer(player), new Object[0]);
            String fieldName = "c";
            Object con = Reflex.getFieldValue(nmsPlayer, fieldName);
            if (!(con.getClass().getSimpleName().equals("PlayerConnection") || con.getClass().getSimpleName().equals("ServerGamePacketListenerImpl") || con.getClass().getSimpleName().equals("GeneratedInterceptor"))) {
                CodexEngine.get().getLogger().warning("Expected PlayerConnection, got " + con.getClass().getSimpleName() + " instead!");
                throw new ClassNotFoundException("Could not get connection from CraftPlayer using field " + fieldName + "\nNMS Player: " + String.valueOf(nmsPlayer) + "\n");
            }
            return con;
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    @Override
    public Object save(Object nmsItem, Object nbtCompound) {
        try {
            if (Version.CURRENT.isAtLeast(Version.V1_20_R4)) {
                Class<?> mcServerClass = this.getClazz("net.minecraft.server.MinecraftServer");
                Object serverInst = Reflex.invokeMethod(Reflex.getMethod(mcServerClass, "getServer", new Class[0]), null, new Object[0]);
                Class<?> providerClass = this.getClazz("net.minecraft.core.HolderLookup$a");
                Class<?> nbtBaseClass = this.getClazz("net.minecraft.nbt.NBTBase");
                Method registryAccess = Reflex.getMethod(serverInst.getClass(), this.getRegistryAccessMethodName(), new Class[0]);
                Method save = Reflex.getMethod(nmsItem.getClass(), "b", providerClass, nbtBaseClass);
                return Reflex.invokeMethod(save, nmsItem, Reflex.invokeMethod(registryAccess, serverInst, new Object[0]), nbtCompound);
            }
            Method save = Reflex.getMethod(nmsItem.getClass(), "b", nbtCompound.getClass());
            return Reflex.invokeMethod(save, nmsItem, nbtCompound);
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    @Override
    public String toBase64(@NotNull ItemStack item) {
        try {
            Object nmsItem;
            Object newCompound;
            ByteArrayOutputStream outputStream = new ByteArrayOutputStream();
            DataOutputStream dataOutput = new DataOutputStream(outputStream);
            Object nbtTagListItems = this.newNBTTagList();
            Object nbtTagCompoundItem = this.newNBTTagCompound();
            if (item != null && !item.getType().isAir() && (newCompound = this.save(nmsItem = this.getNMSCopy(item), nbtTagCompoundItem)) != null) {
                nbtTagCompoundItem = newCompound;
            }
            Method add = Reflex.getMethod(AbstractList.class, "add", Object.class);
            Reflex.invokeMethod(add, nbtTagListItems, nbtTagCompoundItem);
            Class<?> compressedClass = this.getClazz("net.minecraft.nbt.NBTCompressedStreamTools");
            Method a = Reflex.getMethod(compressedClass, "a", nbtTagCompoundItem.getClass(), DataOutput.class);
            Reflex.invokeMethod(a, null, nbtTagCompoundItem, dataOutput);
            String str = new BigInteger(1, outputStream.toByteArray()).toString(32);
            return str;
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    @Override
    public ItemStack fromBase64(@NotNull String data) {
        try {
            Object nmsItem;
            Object nbtTagCompoundRoot;
            ByteArrayInputStream inputStream = new ByteArrayInputStream(new BigInteger(data, 32).toByteArray());
            try {
                Class<?> compressedClass = this.getClazz("net.minecraft.nbt.NBTCompressedStreamTools");
                Method a = Reflex.getMethod(compressedClass, "a", DataInput.class);
                nbtTagCompoundRoot = Reflex.invokeMethod(a, null, new DataInputStream(inputStream));
            }
            catch (ClassNotFoundException e) {
                e.printStackTrace();
                return null;
            }
            Class<?> nmsItemClass = this.getClazz("net.minecraft.world.item.ItemStack");
            Class<?> compoundClass = this.getClazz("net.minecraft.nbt.NBTTagCompound");
            if (Version.CURRENT.isAtLeast(Version.V1_20_R4)) {
                Class<?> mcServerClass = this.getClazz("net.minecraft.server.MinecraftServer");
                Object serverInst = Reflex.invokeMethod(Reflex.getMethod(mcServerClass, "getServer", new Class[0]), null, new Object[0]);
                Class<?> providerClass = this.getClazz("net.minecraft.core.HolderLookup$a");
                Method parseOptional = Reflex.getMethod(nmsItemClass, "a", providerClass, compoundClass);
                Method registryAccess = Reflex.getMethod(serverInst.getClass(), this.getRegistryAccessMethodName(), new Class[0]);
                nmsItem = Reflex.invokeMethod(parseOptional, null, Reflex.invokeMethod(registryAccess, serverInst, new Object[0]), nbtTagCompoundRoot);
            } else {
                Method parse = Reflex.getMethod(nmsItemClass, "a", compoundClass);
                nmsItem = Reflex.invokeMethod(parse, null, nbtTagCompoundRoot);
            }
            if (nmsItem == null) {
                return new ItemStack(Material.AIR);
            }
            Method asBukkitCopy = Reflex.getMethod(this.getCraftClass("inventory.CraftItemStack"), "asBukkitCopy", nmsItemClass);
            ItemStack item = (ItemStack)Reflex.invokeMethod(asBukkitCopy, null, nmsItem);
            return item;
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }
}

