/*
 * Decompiled with CFR 0.152.
 */
package studio.magemonkey.risecore.legacy.util;

import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import java.util.function.Function;
import org.apache.commons.lang3.builder.ToStringBuilder;
import org.apache.commons.lang3.builder.ToStringStyle;
import org.bukkit.Bukkit;
import org.bukkit.Location;
import org.bukkit.configuration.ConfigurationSection;
import org.bukkit.configuration.serialization.ConfigurationSerializable;
import org.bukkit.enchantments.Enchantment;

public class DeserializationWorker {
    private final Map data;

    private DeserializationWorker(Map data) {
        this.data = data;
    }

    public static DeserializationWorker startUnsafe(Map data) {
        try {
            data.remove("==");
        }
        catch (Exception exception) {
            // empty catch block
        }
        return new DeserializationWorker(data);
    }

    public static DeserializationWorker start(Map<String, Object> data) {
        try {
            data.remove("==");
        }
        catch (Exception exception) {
            // empty catch block
        }
        return new DeserializationWorker(data);
    }

    public <T> T getTypedObject(String name) {
        if (!this.data.containsKey(name)) {
            return null;
        }
        return (T)this.data.get(name);
    }

    public <T> T getTypedObject(String name, Class<T> clazz) {
        return this.getTypedObject(name);
    }

    public <T> T getTypedObject(String name, T def) {
        if (!this.data.containsKey(name)) {
            return def;
        }
        return (T)this.data.get(name);
    }

    public <T extends ConfigurationSerializable> T deserialize(String name, Class<T> clazz) {
        return this.deserialize(name, clazz, null);
    }

    public <T extends ConfigurationSerializable> T deserialize(String name, Class<? extends T> clazz, T def) {
        Map<String, Object> section = this.getSection(name);
        if (section == null) {
            return def;
        }
        try {
            Constructor<T> ctor = clazz.getConstructor(Map.class);
            return (T)((ConfigurationSerializable)ctor.newInstance(section));
        }
        catch (IllegalAccessException | InstantiationException | NoSuchMethodException | InvocationTargetException e) {
            e.printStackTrace();
            return null;
        }
    }

    public <T extends ConfigurationSerializable> T deserialize(String name, T def) {
        return this.deserialize(name, def.getClass(), def);
    }

    public <T extends ConfigurationSerializable, C extends Collection<T>> C deserializeCollection(C collection, String name, Class<T> clazz) {
        return this.deserializeCollection(collection, name, clazz, Collections.emptyList());
    }

    public <T extends ConfigurationSerializable, C extends Collection<T>> C deserializeCollection(C collection, String name, Class<? extends T> clazz, Collection<? extends T> def) {
        def = def == null ? Collections.emptyList() : def;
        Object section = this.data.get(name);
        if (section == null) {
            collection.addAll(def);
            return collection;
        }
        List maps = (List)this.data.get(name);
        try {
            Constructor<T> ctor = clazz.getConstructor(Map.class);
            for (Map map : maps) {
                collection.add((ConfigurationSerializable)((ConfigurationSerializable)ctor.newInstance(map)));
            }
        }
        catch (IllegalAccessException | InstantiationException | NoSuchMethodException | InvocationTargetException e) {
            e.printStackTrace();
        }
        return collection;
    }

    public <K, V extends ConfigurationSerializable, C extends Map<K, V>> C deserializeSection(C map, String name, Class<? extends V> clazz, Function<String, K> keyFunc) {
        return this.deserializeSection(map, name, clazz, Collections.emptyMap(), keyFunc);
    }

    public <K, V extends ConfigurationSerializable, C extends Map<K, V>> C deserializeSection(C map, String name, Class<? extends V> clazz, Map<? extends K, ? extends V> def, Function<String, K> keyFunc) {
        def = def == null ? Collections.emptyMap() : def;
        Map<String, Object> section = this.getSection(name);
        if (section == null) {
            map.putAll(def);
            return map;
        }
        Map maps = (Map)this.data.get(name);
        try {
            Constructor<V> ctor = clazz.getConstructor(Map.class);
            for (Map.Entry entry : maps.entrySet()) {
                map.put(keyFunc.apply((String)entry.getKey()), (ConfigurationSerializable)((ConfigurationSerializable)ctor.newInstance(map)));
            }
        }
        catch (IllegalAccessException | InstantiationException | NoSuchMethodException | InvocationTargetException e) {
            e.printStackTrace();
        }
        return map;
    }

    public <V extends ConfigurationSerializable, C extends Map<String, V>> C deserializeSection(C map, String name, Class<? extends V> clazz) {
        return this.deserializeSection(map, name, clazz, Collections.emptyMap(), s -> s);
    }

    public <V extends ConfigurationSerializable, C extends Map<String, V>> C deserializeSection(C map, String name, Class<? extends V> clazz, Map<String, ? extends V> def) {
        return this.deserializeSection(map, name, clazz, def, s -> s);
    }

    public Object getObject(String name) {
        return this.getObject(name, null);
    }

    public Object getObject(String name, Object def) {
        if (!this.data.containsKey(name)) {
            return def;
        }
        return this.data.get(name);
    }

    public String getString(String name) {
        return this.getString(name, null);
    }

    public String getString(String name, String def) {
        if (!this.data.containsKey(name)) {
            return def;
        }
        Object obj = this.data.get(name);
        return obj == null ? null : obj.toString();
    }

    public UUID getUUID(String name) {
        return this.getUUID(name, null);
    }

    public UUID getUUID(String name, UUID def) {
        if (!this.data.containsKey(name)) {
            return def;
        }
        return UUID.fromString(this.data.get(name).toString());
    }

    public float getFloat(String name) {
        return this.getFloat(name, 0.0f);
    }

    public float getFloat(String name, float def) {
        if (!this.data.containsKey(name)) {
            return def;
        }
        return ((Number)this.data.get(name)).floatValue();
    }

    public double getDouble(String name) {
        return this.getDouble(name, 0.0);
    }

    public double getDouble(String name, double def) {
        if (!this.data.containsKey(name)) {
            return def;
        }
        return ((Number)this.data.get(name)).doubleValue();
    }

    public int getInt(String name) {
        return this.getInt(name, 0);
    }

    public int getInt(String name, int def) {
        if (!this.data.containsKey(name)) {
            return def;
        }
        return ((Number)this.data.get(name)).intValue();
    }

    public long getLong(String name) {
        return this.getLong(name, 0L);
    }

    public long getLong(String name, long def) {
        if (!this.data.containsKey(name)) {
            return def;
        }
        return ((Number)this.data.get(name)).longValue();
    }

    public boolean getBoolean(String name) {
        return this.getBoolean(name, false);
    }

    public boolean getBoolean(String name, boolean def) {
        if (!this.data.containsKey(name)) {
            return def;
        }
        Object obj = this.data.get(name);
        return obj instanceof Boolean ? (Boolean)obj : Boolean.parseBoolean(obj.toString());
    }

    public byte getByte(String name) {
        return this.getByte(name, (byte)0);
    }

    public byte getByte(String name, byte def) {
        if (!this.data.containsKey(name)) {
            return def;
        }
        return ((Number)this.data.get(name)).byteValue();
    }

    public short getShort(String name) {
        return this.getShort(name, (short)0);
    }

    public short getShort(String name, short def) {
        if (!this.data.containsKey(name)) {
            return def;
        }
        return ((Number)this.data.get(name)).shortValue();
    }

    public <T extends Enum<T>> T getEnum(String name, T def) {
        return this.getEnum(name, def.getDeclaringClass(), def);
    }

    public <T extends Enum<T>> T getEnum(String name, Class<T> enumClass) {
        return this.getEnum(name, enumClass, null);
    }

    public <T extends Enum<T>> T getEnum(String name, Class<T> enumClass, T def) {
        Enum[] consts;
        String constName = this.getString(name, def == null ? null : def.name());
        if (constName == null) {
            return def;
        }
        for (Enum enumConst : consts = (Enum[])enumClass.getEnumConstants()) {
            if (!enumConst.name().equals(constName)) continue;
            return (T)enumConst;
        }
        return def;
    }

    public Enchantment getEnchantment(String name) {
        return this.getEnchantment(name, null);
    }

    public Enchantment getEnchantment(String name, Enchantment def) {
        String enchName = this.getString(name, null);
        if (enchName == null) {
            return null;
        }
        return Enchantment.getByName((String)enchName);
    }

    public Location getLoc(String name) {
        return this.getLoc(name, null);
    }

    public Location getLoc(String name, Location def) {
        if (!this.data.containsKey(name)) {
            return def;
        }
        DeserializationWorker dw = DeserializationWorker.start((Map)this.data.get(name));
        String worldName = dw.getString("world");
        return new Location(worldName == null ? null : Bukkit.getWorld((String)worldName), (double)dw.getInt("x"), (double)dw.getInt("y"), (double)dw.getInt("z"), dw.getFloat("yaw"), dw.getFloat("pitch"));
    }

    public List<String> getStringListSafe(String name) {
        return this.getStringList(name, new ArrayList<String>(1));
    }

    public List<String> getStringList(String name) {
        return this.getStringList(name, null);
    }

    public List<String> getStringList(String name, List<String> def) {
        if (!this.data.containsKey(name)) {
            return def;
        }
        Object obj = this.data.get(name);
        if (obj instanceof Collection) {
            return new ArrayList<String>((Collection)this.data.get(name));
        }
        return obj instanceof String[] ? new ArrayList<String>(Arrays.asList((String[])obj)) : def;
    }

    public <T> Set<T> getHashSet(String name) {
        return this.getHashSet(name, null);
    }

    public <T> Set<T> getHashSet(String name, Set<T> def) {
        if (!this.data.containsKey(name)) {
            return def;
        }
        return new HashSet((Collection)this.data.get(name));
    }

    public <T> List<T> getList(String name) {
        return this.getList(name, null);
    }

    public <T> List<T> getList(String name, List<T> def) {
        if (!this.data.containsKey(name)) {
            return def;
        }
        return new ArrayList((Collection)this.data.get(name));
    }

    public Map<String, Object> getSection(String name) {
        return this.getSection(name, null);
    }

    public Map<String, Object> getSection(String name, Map<String, Object> def) {
        Object obj = this.data.get(name);
        if (obj == null) {
            return def;
        }
        if (obj instanceof ConfigurationSection) {
            return ((ConfigurationSection)obj).getValues(true);
        }
        return (Map)obj;
    }

    public Map<String, Object> getMap() {
        return this.data;
    }

    public String toString() {
        return new ToStringBuilder((Object)this, ToStringStyle.SHORT_PREFIX_STYLE).appendSuper(super.toString()).append("data", (Object)this.data).toString();
    }
}

