/*
 * Decompiled with CFR 0.152.
 */
package studio.magemonkey.codex.api.armor;

import lombok.Generated;
import org.bukkit.inventory.ItemStack;
import org.jetbrains.annotations.Nullable;
import studio.magemonkey.codex.util.constants.ItemHelper;

public enum ArmorType {
    BOOTS(36),
    LEGGINGS(37),
    CHESTPLATE(38),
    HELMET(39),
    OFFHAND(40),
    MAIN_HAND(-1);

    private final int slot;

    @Nullable
    public static ArmorType matchType(ItemStack itemStack) {
        if (ItemHelper.isAirOrNull(itemStack)) {
            return null;
        }
        String type = itemStack.getType().name();
        if (type.endsWith("_HELMET") || type.endsWith("_SKULL") || type.endsWith("_HEAD")) {
            return HELMET;
        }
        if (type.endsWith("_CHESTPLATE") || type.equals("ELYTRA")) {
            return CHESTPLATE;
        }
        if (type.endsWith("_LEGGINGS")) {
            return LEGGINGS;
        }
        if (type.endsWith("_BOOTS")) {
            return BOOTS;
        }
        if (type.equals("SHIELD")) {
            return OFFHAND;
        }
        return MAIN_HAND;
    }

    public boolean matchesSlot(int slot, int heldSlot) {
        switch (this.ordinal()) {
            case 4: 
            case 5: {
                return slot == 40 || slot == heldSlot;
            }
        }
        return this.slot == slot;
    }

    @Generated
    public int getSlot() {
        return this.slot;
    }

    @Generated
    private ArmorType(int slot) {
        this.slot = slot;
    }
}

