/*
 * Decompiled with CFR 0.152.
 */
package studio.magemonkey.codex.legacy.item;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import lombok.Generated;
import org.apache.commons.lang3.builder.ToStringBuilder;
import org.apache.commons.lang3.builder.ToStringStyle;
import org.bukkit.configuration.serialization.SerializableAs;
import org.bukkit.inventory.meta.BookMeta;
import org.bukkit.inventory.meta.ItemMeta;
import org.jetbrains.annotations.NotNull;
import studio.magemonkey.codex.legacy.item.DataBuilder;
import studio.magemonkey.codex.legacy.utils.Utils;
import studio.magemonkey.codex.util.DeserializationWorker;
import studio.magemonkey.codex.util.SerializationBuilder;

@SerializableAs(value="Codex_BookMeta")
public class BookDataBuilder
extends DataBuilder {
    private String title;
    private String author;
    private List<String> pages = new ArrayList<String>(10);

    public BookDataBuilder(Map<String, Object> map) {
        DeserializationWorker w = DeserializationWorker.start(map);
        this.title = w.getString("title");
        this.author = w.getString("author");
        this.pages = w.getTypedObject("pages", new ArrayList(3));
    }

    public BookDataBuilder title(String title) {
        this.title = title;
        return this;
    }

    public BookDataBuilder author(String author) {
        this.author = author;
        return this;
    }

    public BookDataBuilder newPage(String page) {
        this.pages.add(page);
        return this;
    }

    public BookDataBuilder newPage(String ... pages) {
        Collections.addAll(this.pages, pages);
        return this;
    }

    public BookDataBuilder newPage(Collection<String> pages) {
        this.pages.addAll(pages);
        return this;
    }

    public BookDataBuilder newPage(int index, String page) {
        this.pages.add(index, page);
        return this;
    }

    public BookDataBuilder newPage(int index, String ... pages) {
        return this.newPage(index, Arrays.asList(pages));
    }

    public BookDataBuilder newPage(int index, Collection<String> pages) {
        this.pages.addAll(index, pages);
        return this;
    }

    public BookDataBuilder setPage(int index, String page) {
        this.pages.set(index, page);
        return this;
    }

    public BookDataBuilder removePage(int index) {
        this.pages.remove(index);
        return this;
    }

    public BookDataBuilder removePage(String page) {
        this.pages.remove(page);
        return this;
    }

    public BookDataBuilder removePage(String ... pages) {
        return this.removePage(Arrays.asList(pages));
    }

    public BookDataBuilder removePage(Collection<String> pages) {
        this.pages.removeAll(pages);
        return this;
    }

    public BookDataBuilder clearPages() {
        this.pages.clear();
        return this;
    }

    public BookDataBuilder clearTitle() {
        this.title = null;
        return this;
    }

    public BookDataBuilder clearAuthor() {
        this.author = null;
        return this;
    }

    @Override
    public void apply(ItemMeta itemMeta) {
        if (!(itemMeta instanceof BookMeta)) {
            return;
        }
        BookMeta meta = (BookMeta)itemMeta;
        meta.setPages(Utils.fixColors(this.pages));
        meta.setAuthor(Utils.fixColors(this.author));
        meta.setTitle(Utils.fixColors(this.title));
    }

    @Override
    public BookDataBuilder use(ItemMeta itemMeta) {
        if (!(itemMeta instanceof BookMeta)) {
            return null;
        }
        BookMeta meta = (BookMeta)itemMeta;
        this.title = Utils.removeColors(meta.getTitle());
        this.author = Utils.removeColors(meta.getAuthor());
        this.pages = Utils.removeColors(new ArrayList<String>(meta.getPages()));
        return this;
    }

    @Override
    public String getType() {
        return "book";
    }

    public String toString() {
        return new ToStringBuilder((Object)this, ToStringStyle.SHORT_PREFIX_STYLE).appendSuper(super.toString()).append("title", (Object)this.title).append("author", (Object)this.author).append("pages", this.pages).toString();
    }

    @Override
    @NotNull
    public Map<String, Object> serialize() {
        SerializationBuilder b = SerializationBuilder.start(4).append(super.serialize());
        b.append("title", (Object)this.title);
        b.append("author", (Object)this.author);
        b.append("pages", this.pages);
        return b.build();
    }

    public static BookDataBuilder start() {
        return new BookDataBuilder();
    }

    @Generated
    public BookDataBuilder() {
    }
}

