/*
 * Decompiled with CFR 0.152.
 */
package studio.magemonkey.codex.legacy.item;

import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.Map;
import lombok.Generated;
import org.apache.commons.lang3.builder.ToStringBuilder;
import org.apache.commons.lang3.builder.ToStringStyle;
import org.bukkit.configuration.serialization.SerializableAs;
import org.bukkit.enchantments.Enchantment;
import org.bukkit.inventory.meta.EnchantmentStorageMeta;
import org.bukkit.inventory.meta.ItemMeta;
import org.jetbrains.annotations.NotNull;
import studio.magemonkey.codex.legacy.item.DataBuilder;
import studio.magemonkey.codex.util.SerializationBuilder;

@SerializableAs(value="Codex_EnchantmentStorageMeta")
public class EnchantmentStorageBuilder
extends DataBuilder {
    private Map<Enchantment, Integer> enchants = new LinkedHashMap<Enchantment, Integer>(3);

    public EnchantmentStorageBuilder(Map<String, Object> map) {
        for (Map.Entry<String, Object> entry : map.entrySet()) {
            if ("==".equals(entry.getKey()) || "TYPE".equals(entry.getKey())) continue;
            this.enchants.put(Enchantment.getByName((String)entry.getKey()), ((Number)entry.getValue()).intValue());
        }
    }

    public String toString() {
        return new ToStringBuilder((Object)this, ToStringStyle.SHORT_PREFIX_STYLE).appendSuper(super.toString()).append("enchants", this.enchants).toString();
    }

    public EnchantmentStorageBuilder enchant(Map<Enchantment, Integer> enchants) {
        this.enchants = enchants;
        return this;
    }

    public EnchantmentStorageBuilder enchant(Enchantment enchantment, int power) {
        this.enchants.put(enchantment, power);
        return this;
    }

    public EnchantmentStorageBuilder enchant(Enchantment enchantment) {
        this.enchant(enchantment, 1);
        return this;
    }

    public EnchantmentStorageBuilder unEnchant(Enchantment enchantment) {
        this.enchants.remove(enchantment);
        return this;
    }

    public EnchantmentStorageBuilder clear() {
        this.enchants.clear();
        return this;
    }

    @Override
    public void apply(ItemMeta itemMeta) {
        if (!(itemMeta instanceof EnchantmentStorageMeta)) {
            return;
        }
        EnchantmentStorageMeta meta = (EnchantmentStorageMeta)itemMeta;
        if (meta.hasStoredEnchants()) {
            HashSet enchs = new HashSet(meta.getStoredEnchants().keySet());
            for (Enchantment ench : enchs) {
                meta.removeStoredEnchant(ench);
            }
        }
        for (Map.Entry<Enchantment, Integer> entry : this.enchants.entrySet()) {
            meta.addStoredEnchant(entry.getKey(), entry.getValue().intValue(), true);
        }
    }

    @Override
    public EnchantmentStorageBuilder use(ItemMeta itemMeta) {
        if (!(itemMeta instanceof EnchantmentStorageMeta)) {
            return null;
        }
        EnchantmentStorageMeta meta = (EnchantmentStorageMeta)itemMeta;
        this.enchants = new LinkedHashMap<Enchantment, Integer>(meta.getStoredEnchants());
        return this;
    }

    @Override
    public String getType() {
        return "enchantment_book";
    }

    @Override
    @NotNull
    public Map<String, Object> serialize() {
        SerializationBuilder b = SerializationBuilder.start(this.enchants.size() + 1).append(super.serialize());
        for (Map.Entry<Enchantment, Integer> entry : this.enchants.entrySet()) {
            b.append(entry.getKey().getName(), (Object)entry.getValue());
        }
        return b.build();
    }

    public static EnchantmentStorageBuilder start() {
        return new EnchantmentStorageBuilder();
    }

    @Generated
    public Map<Enchantment, Integer> getEnchants() {
        return this.enchants;
    }

    @Generated
    public EnchantmentStorageBuilder() {
    }
}

