/*
 * Decompiled with CFR 0.152.
 */
package studio.magemonkey.codex.legacy.placeholder;

import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.function.Supplier;
import net.md_5.bungee.api.chat.BaseComponent;
import org.apache.commons.lang3.StringUtils;
import org.bukkit.plugin.Plugin;
import studio.magemonkey.codex.legacy.placeholder.BasePlaceholderData;
import studio.magemonkey.codex.legacy.placeholder.BasePlaceholderItem;
import studio.magemonkey.codex.legacy.placeholder.PlaceholderItem;
import studio.magemonkey.codex.legacy.placeholder.PlaceholderType;
import studio.magemonkey.codex.legacy.utils.ComponentUtils;

public interface PlaceholderData<T> {
    public static final Object[] EMPTY_OBJECTS = new Object[0];

    public String getFullName();

    public String getObjectName();

    public PlaceholderItem<T> getItem();

    default public Object[] getArguments() {
        return EMPTY_OBJECTS;
    }

    default public boolean containsSubPlaceholders() {
        return false;
    }

    default public Object[] getArguments(T obj) {
        Object[] args = this.getArguments();
        if (args.length == 0) {
            return EMPTY_OBJECTS;
        }
        if (this.containsSubPlaceholders()) {
            Object[] parsed = new Object[args.length];
            int i = 0;
            for (Object arg : args) {
                parsed[i++] = arg instanceof Supplier ? ((Supplier)arg).get() : arg;
            }
            return parsed;
        }
        return args;
    }

    default public Object apply(T obj) {
        return this.getItem().apply(obj, this.getArguments(obj));
    }

    default public String replace(String str, T obj) {
        Object result = this.apply(obj);
        if (result instanceof BaseComponent) {
            return StringUtils.replace((String)str, (String)this.getFullName(), (String)ComponentUtils.toLegacyText((BaseComponent)result));
        }
        return StringUtils.replace((String)str, (String)this.getFullName(), (String)result.toString());
    }

    default public BaseComponent replace(BaseComponent component, T obj) {
        Object result = this.apply(obj);
        if (result instanceof BaseComponent) {
            ComponentUtils.replace(component, this.getFullName(), (BaseComponent)result);
        } else {
            ComponentUtils.replace(component, this.getFullName(), result.toString());
        }
        return component;
    }

    public static <T> PlaceholderData<T> valueOf(String fullName, String objectName, PlaceholderItem<T> item) {
        PlaceholderData<?> cached = BasePlaceholderData.cache.get(fullName);
        if (cached != null) {
            return cached;
        }
        BasePlaceholderData<T> result = new BasePlaceholderData<T>(fullName, objectName, item);
        BasePlaceholderData.cache.put(fullName, result);
        return result;
    }

    public static Map<String, Collection<PlaceholderData<?>>> parseString(Plugin api, String str, boolean warn) {
        if (str == null) {
            return null;
        }
        HashMap result = new HashMap(3, 0.1f);
        StringBuilder key = null;
        char lastChar = '\u0000';
        for (char c : str.toCharArray()) {
            if (key == null) {
                if (c == '$') {
                    if (lastChar == '\\') continue;
                    lastChar = c;
                    continue;
                }
                if (lastChar == '$' && c == '<') {
                    key = new StringBuilder(64);
                    lastChar = c;
                    continue;
                }
                lastChar = c;
                continue;
            }
            if (c == '>') {
                String typeName;
                String typeID;
                String string = key.toString();
                int index = string.indexOf(46);
                boolean simple = index == -1;
                String value = string.substring(index + 1);
                Object fullName = "$<";
                String type = simple ? "" : string.substring(0, index);
                index = type.indexOf(58);
                if (index == -1) {
                    fullName = (String)fullName + type;
                    typeID = type;
                    typeName = type;
                } else {
                    typeID = type.substring(0, index);
                    typeName = type.substring(index + 1);
                    fullName = (String)fullName + typeID + ":" + typeName;
                }
                fullName = (String)fullName + (simple ? "" : ".") + value + ">";
                PlaceholderData<?> data = BasePlaceholderData.cache.get(fullName);
                if (data == null) {
                    PlaceholderType placeholderType = PlaceholderType.get(typeID);
                    if (placeholderType != null) {
                        PlaceholderItem<?> item = placeholderType.getItem(value);
                        if (item == null && simple) {
                            item = new BasePlaceholderItem<Object>(placeholderType, typeID, o -> o);
                        }
                        if (item != null) {
                            data = PlaceholderData.valueOf((String)fullName, typeName, item);
                        } else if (warn) {
                            api.getLogger().warning("Unknown placeholder item (" + value + ") in: " + (String)fullName + ", in string: " + str);
                        }
                    } else if (warn) {
                        api.getLogger().warning("Unknown placeholder type (" + typeID + ") in: " + (String)fullName + ", in string: " + str);
                    }
                }
                if (data != null) {
                    String dataID = simple ? value : data.getObjectName();
                    HashSet collection = (HashSet)result.get(dataID);
                    if (collection == null) {
                        collection = new HashSet(5, 0.1f);
                        result.put(dataID, collection);
                    }
                    collection.add(data);
                }
                key = null;
            } else if (c >= '0' && c <= '9' || c >= 'a' && c <= 'z' || c >= 'A' && c <= 'Z' || c == '_' || c == '.' || c == ':') {
                key.append(c);
            } else {
                key = null;
            }
            lastChar = c;
        }
        return result;
    }
}

