/*
 * Decompiled with CFR 0.152.
 */
package studio.magemonkey.codex.legacy.riseitem;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import lombok.Generated;
import org.apache.commons.lang3.DoubleRange;
import org.apache.commons.lang3.builder.ToStringBuilder;
import org.apache.commons.lang3.builder.ToStringStyle;
import org.bukkit.ChatColor;
import org.bukkit.command.CommandSender;
import org.bukkit.configuration.serialization.ConfigurationSerializable;
import org.bukkit.configuration.serialization.SerializableAs;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.ItemMeta;
import org.bukkit.plugin.Plugin;
import studio.magemonkey.codex.CodexEngine;
import studio.magemonkey.codex.api.DelayedCommand;
import studio.magemonkey.codex.api.Replacer;
import studio.magemonkey.codex.legacy.item.ItemBuilder;
import studio.magemonkey.codex.legacy.riseitem.DarkRiseItem;
import studio.magemonkey.codex.util.DeserializationWorker;
import studio.magemonkey.codex.util.SerializationBuilder;

@SerializableAs(value="DarkRiseItemImpl")
public class DarkRiseItemImpl
implements DarkRiseItem {
    private final String id;
    private final ItemStack item;
    private final boolean dropOnDeath;
    private final int removeOnDeath;
    private final boolean confirmOnUse;
    private final int removeOnUse;
    private final boolean canDrop;
    private final boolean tradeable;
    private final boolean enabledEnchantedDurability;
    private final DoubleRange chanceToLostDurability;
    private final List<DelayedCommand> commands;
    private final List<String> permissionList = new ArrayList<String>();
    private final String permissionMessage;

    public DarkRiseItemImpl(Map<String, Object> map) {
        DeserializationWorker w = DeserializationWorker.start(map);
        this.id = w.getString("id").intern();
        this.item = w.getTypedObject("item") instanceof ItemStack ? (ItemStack)w.getTypedObject("item", ItemStack.class) : ((ItemBuilder)((Object)w.getTypedObject("item", ItemBuilder.class))).build();
        this.dropOnDeath = w.getBoolean("dropOnDeath", true);
        this.removeOnDeath = w.getInt("removeOnDeath", 1);
        this.confirmOnUse = w.getBoolean("confirmOnUse", false);
        this.removeOnUse = w.getInt("removeOnUse", 0);
        this.canDrop = w.getBoolean("canDrop", true);
        this.tradeable = w.getBoolean("tradeable", true);
        if (w.getMap().containsKey("permission")) {
            DeserializationWorker permSec = DeserializationWorker.start(w.getSection("permission", new HashMap<String, Object>()));
            if (permSec.getObject("node") instanceof Collection) {
                this.permissionList.addAll(permSec.getList("node", new ArrayList()));
            } else {
                this.permissionList.add(permSec.getString("node"));
            }
            this.permissionMessage = permSec.getString("message", "&4You don't have permission to use this");
        } else {
            this.permissionMessage = null;
        }
        this.enabledEnchantedDurability = w.getBoolean("enabledEnchantedDurability", false);
        String[] rangeString = w.getString("chanceToLostDurability", "0.0 - 0.0").split("-");
        this.chanceToLostDurability = DoubleRange.of((double)Double.parseDouble(rangeString[0].trim()), (double)Double.parseDouble(rangeString[1].trim()));
        this.commands = ((List)map.get("commands")).stream().map(DelayedCommand::new).collect(Collectors.toList());
        ItemMeta im = this.item.getItemMeta();
        if (im.hasDisplayName()) {
            im.setDisplayName(ChatColor.translateAlternateColorCodes((char)'&', (String)im.getDisplayName()));
        }
        if (im.hasLore()) {
            ArrayList lore = new ArrayList();
            im.getLore().forEach(str -> lore.add(ChatColor.translateAlternateColorCodes((char)'&', (String)str)));
            im.setLore(lore);
        }
        this.item.setItemMeta(im);
    }

    public DarkRiseItemImpl(String id, ItemStack item) {
        this.id = id.intern();
        this.item = item;
        this.dropOnDeath = true;
        this.removeOnDeath = 1;
        this.confirmOnUse = false;
        this.removeOnUse = 0;
        this.canDrop = true;
        this.tradeable = true;
        this.enabledEnchantedDurability = false;
        this.chanceToLostDurability = DoubleRange.of((double)0.0, (double)0.0);
        this.commands = new ArrayList<DelayedCommand>();
        this.permissionMessage = null;
    }

    public DarkRiseItemImpl(String id, ItemStack item, boolean dropOnDeath, int removeOnDeath, boolean confirmOnUse, int removeOnUse, boolean canDrop, boolean enabledEnchantedDurability, DoubleRange chanceToLostDurability, List<DelayedCommand> commands) {
        this(id, item, dropOnDeath, removeOnDeath, confirmOnUse, removeOnUse, canDrop, enabledEnchantedDurability, chanceToLostDurability, commands, -1);
    }

    public DarkRiseItemImpl(String id, ItemStack item, boolean dropOnDeath, int removeOnDeath, boolean confirmOnUse, int removeOnUse, boolean canDrop, boolean enabledEnchantedDurability, DoubleRange chanceToLostDurability, List<DelayedCommand> commands, int modelData) {
        this.id = id;
        this.item = item.clone();
        if (modelData != -1) {
            ItemMeta im = this.item.getItemMeta();
            im.setCustomModelData(Integer.valueOf(modelData));
            this.item.setItemMeta(im);
        }
        this.dropOnDeath = dropOnDeath;
        this.removeOnDeath = removeOnDeath;
        this.confirmOnUse = confirmOnUse;
        this.removeOnUse = removeOnUse;
        this.canDrop = canDrop;
        this.tradeable = true;
        this.enabledEnchantedDurability = enabledEnchantedDurability;
        this.chanceToLostDurability = chanceToLostDurability;
        this.commands = commands;
        this.permissionMessage = null;
    }

    @Override
    public String getName() {
        return this.isVanilla() ? this.item.getType().name() : this.item.getItemMeta().getDisplayName();
    }

    @Override
    public int isRemoveOnDeath() {
        return this.removeOnDeath;
    }

    @Override
    public int isRemoveOnUse() {
        return this.removeOnUse;
    }

    @Override
    public boolean canDrop() {
        return this.canDrop;
    }

    @Override
    public DoubleRange chanceToLostDurability() {
        return this.chanceToLostDurability;
    }

    @Override
    public List<String> getPermission() {
        return this.permissionList;
    }

    @Override
    public ItemStack getItem(int amount) {
        ItemStack clone = this.item.clone();
        clone.setAmount(amount);
        return clone;
    }

    @Override
    public boolean isVanilla() {
        return this.getId().startsWith("vanilla_");
    }

    @Override
    public void invoke(CommandSender sender) {
        if (this.commands.isEmpty()) {
            return;
        }
        DelayedCommand.invoke((Plugin)CodexEngine.get(), sender, this.commands, Replacer.replacer("{canDrop}", this.canDrop), Replacer.replacer("{enabledEnchantedDurability}", this.enabledEnchantedDurability), Replacer.replacer("{chanceToLostDurability}", this.chanceToLostDurability.toString()), Replacer.replacer("{dropOnDeath}", this.dropOnDeath), Replacer.replacer("{removeOnDeath}", this.removeOnDeath), Replacer.replacer("{confirmOnUse}", this.confirmOnUse), Replacer.replacer("removeOnUse", this.removeOnUse), Replacer.replacer("{id}", this.id), Replacer.replacer("{name}", this.getName()));
    }

    public Map<String, Object> serialize() {
        SerializationBuilder sb = SerializationBuilder.start(10).append("id", (Object)this.id).append("canDrop", (Object)this.canDrop).append("tradeable", (Object)this.tradeable).append("enabledEnchantedDurability", (Object)this.enabledEnchantedDurability).append("chanceToLostDurability", (Object)(String.valueOf(this.chanceToLostDurability.getMinimum()) + "-" + String.valueOf(this.chanceToLostDurability.getMaximum()))).append("dropOnDeath", (Object)this.dropOnDeath).append("removeOnDeath", (Object)this.removeOnDeath).append("confirmOnUse", (Object)this.confirmOnUse).append("removeOnUse", (Object)this.removeOnUse).append("permission", SerializationBuilder.start(2).append("node", this.permissionList).append("message", (Object)this.permissionMessage)).append("commands", this.commands.stream().map(DelayedCommand::serialize).collect(Collectors.toList()));
        HashMap<String, Object> item = new HashMap<String, Object>(this.item.serialize());
        item.put("==", "org.bukkit.inventory.ItemStack");
        ItemMeta im = this.item.getItemMeta();
        if (im != null) {
            HashMap<String, Object> meta = new HashMap<String, Object>(im.serialize());
            if (im.hasDisplayName()) {
                meta.put("display-name", im.getDisplayName());
            }
            if (im.hasLore()) {
                meta.put("lore", im.getLore());
            }
            meta.put("==", "ItemMeta");
            item.put("meta", meta);
        }
        sb.append("item", (Object)this.item);
        sb.append("item", item);
        return sb.build();
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (!(object instanceof DarkRiseItemImpl)) {
            return false;
        }
        DarkRiseItemImpl riseItem = (DarkRiseItemImpl)object;
        return Objects.equals(this.getId(), riseItem.getId());
    }

    public int hashCode() {
        return Objects.hash(this.id);
    }

    public String toString() {
        return new ToStringBuilder((Object)this, ToStringStyle.SHORT_PREFIX_STYLE).append("id", (Object)this.id).append("item", (Object)this.item).append("dropOnDeath", this.dropOnDeath).append("removeOnDeath", this.removeOnDeath).append("confirmOnUse", this.confirmOnUse).append("removeOnUse", this.removeOnUse).append("canDrop", this.canDrop).append("tradeable", this.tradeable).append("enabledEnchantedDurability", this.enabledEnchantedDurability).append("chanceToLostDurability", (Object)this.chanceToLostDurability).append("commands", this.commands).append("name", (Object)this.getName()).toString();
    }

    @Override
    @Generated
    public String getId() {
        return this.id;
    }

    @Override
    @Generated
    public boolean isDropOnDeath() {
        return this.dropOnDeath;
    }

    @Override
    @Generated
    public boolean isConfirmOnUse() {
        return this.confirmOnUse;
    }

    @Override
    @Generated
    public boolean isTradeable() {
        return this.tradeable;
    }

    @Override
    @Generated
    public boolean isEnabledEnchantedDurability() {
        return this.enabledEnchantedDurability;
    }

    @Override
    @Generated
    public List<DelayedCommand> getCommands() {
        return this.commands;
    }

    @Override
    @Generated
    public String getPermissionMessage() {
        return this.permissionMessage;
    }

    public static class DivineItemsMeta
    implements ConfigurationSerializable {
        public boolean enabled;
        public String tierName;
        public Double tierLevel;

        public DivineItemsMeta(Map<String, Object> map) {
            DeserializationWorker w = DeserializationWorker.start(map);
            this.enabled = w.getBoolean("enabled", false);
            this.tierName = w.getString("tierName");
            this.tierLevel = w.getDouble("tierLevel");
        }

        public DivineItemsMeta() {
            this.enabled = false;
            this.tierName = "";
            this.tierLevel = 0.0;
        }

        public Map<String, Object> serialize() {
            return SerializationBuilder.start(3).append("enabled", (Object)this.enabled).append("tierName", (Object)this.tierName).append("tierLevel", (Object)this.tierLevel).build();
        }
    }
}

