/*
 * Decompiled with CFR 0.152.
 */
package studio.magemonkey.codex.legacy.utils;

import com.google.common.collect.Sets;
import java.util.Set;
import java.util.regex.Pattern;
import net.md_5.bungee.api.ChatColor;
import net.md_5.bungee.api.chat.BaseComponent;
import studio.magemonkey.codex.legacy.utils.ComponentUtils;

public class ChatColorUtils {
    public static final char COLOR_CHAR = '\u00a7';
    public static final char DEFAULT_ALTERNATE_COLOR_CHAR = '&';
    private static final Pattern STRIP_COLOR_PATTERN;
    private static final Set<ChatColor> styles;

    public static ChatColor getByChar(char code) {
        return ChatColor.getByChar((char)code);
    }

    public static String stripColor(CharSequence input) {
        if (input == null) {
            return null;
        }
        return STRIP_COLOR_PATTERN.matcher(input).replaceAll("");
    }

    public static BaseComponent[] translateAlternateColorCodes(char altColorChar, String textToTranslate) {
        return ComponentUtils.fromLegacyText(ChatColorUtils.translateAlternateColorCodesInString(altColorChar, textToTranslate));
    }

    public static BaseComponent[] translateAlternateColorCodes(String textToTranslate) {
        return ComponentUtils.fromLegacyText(ChatColorUtils.translateAlternateColorCodesInString('&', textToTranslate));
    }

    public static String translateAlternateColorCodesInString(char altColorChar, String textToTranslate) {
        char[] b = textToTranslate.toCharArray();
        for (int i = 0; i < b.length - 1; ++i) {
            if (b[i] != altColorChar || "0123456789AaBbCcDdEeFfKkLlMmNnOoRr".indexOf(b[i + 1]) <= -1) continue;
            b[i] = 167;
            b[i + 1] = Character.toLowerCase(b[i + 1]);
        }
        return new String(b);
    }

    public static String translateAlternateColorCodesInString(String textToTranslate) {
        return ChatColorUtils.translateAlternateColorCodesInString('&', textToTranslate);
    }

    public static String removeColorCodesInString(char altColorChar, String textToTranslate) {
        char[] b = textToTranslate.toCharArray();
        for (int i = 0; i < b.length - 1; ++i) {
            if (b[i] != '\u00a7' || "0123456789AaBbCcDdEeFfKkLlMmNnOoRr".indexOf(b[i + 1]) <= -1) continue;
            b[i] = altColorChar;
            b[i + 1] = Character.toLowerCase(b[i + 1]);
        }
        return new String(b);
    }

    public static String getLastColors(CharSequence input) {
        Object result = "";
        int length = input.length();
        for (int index = length - 1; index > -1; --index) {
            char c;
            ChatColor color;
            char section = input.charAt(index);
            if (section != '\u00a7' || index >= length - 1 || (color = ChatColorUtils.getByChar(c = input.charAt(index + 1))) == null) continue;
            result = color.toString() + (String)result;
            if (!styles.contains(color) || color.equals((Object)ChatColor.RESET)) break;
        }
        return result;
    }

    static {
        styles = Sets.newHashSet((Object[])new ChatColor[]{ChatColor.UNDERLINE, ChatColor.BOLD, ChatColor.STRIKETHROUGH, ChatColor.MAGIC, ChatColor.ITALIC});
        STRIP_COLOR_PATTERN = Pattern.compile("(?i)" + String.valueOf('\u00a7') + "[0-9A-FK-OR]");
    }
}

