/*
 * Decompiled with CFR 0.152.
 */
package studio.magemonkey.codex.manager.api.menu;

import java.io.File;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.NavigableMap;
import java.util.Objects;
import java.util.Set;
import java.util.TreeMap;
import java.util.UUID;
import org.bukkit.Material;
import org.bukkit.configuration.ConfigurationSection;
import org.bukkit.configuration.file.YamlConfiguration;
import org.bukkit.entity.Player;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.ItemMeta;
import org.bukkit.plugin.Plugin;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import studio.magemonkey.codex.compat.VersionManager;
import studio.magemonkey.codex.manager.api.menu.Menu;
import studio.magemonkey.codex.manager.api.menu.Slot;
import studio.magemonkey.codex.util.StringUT;

public abstract class YAMLMenu<T> {
    private static final Set<YAMLMenu<?>> YAML_MENUS = new HashSet();
    protected final Plugin plugin;
    protected final String path;
    protected String title;
    protected int rows;
    protected NavigableMap<Integer, String> slots;
    protected NavigableMap<String, ItemStack> items;

    public static void reloadMenus(Plugin plugin) {
        YAML_MENUS.stream().filter(yamlMenu -> yamlMenu.plugin.equals((Object)plugin)).forEach(YAMLMenu::reload);
    }

    public YAMLMenu(Plugin plugin, String path) {
        this.plugin = plugin;
        this.path = path;
        this.reload();
        YAML_MENUS.add(this);
    }

    public void reload() {
        File file = new File(this.plugin.getDataFolder(), this.path);
        if (!file.exists()) {
            this.plugin.saveResource(this.path, false);
        }
        YamlConfiguration config = YamlConfiguration.loadConfiguration((File)file);
        this.title = StringUT.color(config.getString("title", ""));
        this.rows = config.getInt("rows", 6);
        TreeMap<Integer, String> slots = new TreeMap<Integer, String>();
        TreeMap<String, ItemStack> items = new TreeMap<String, ItemStack>();
        ConfigurationSection section = config.getConfigurationSection("slots");
        if (section == null) {
            return;
        }
        for (String key : section.getKeys(false)) {
            try {
                int i = Integer.parseInt(key);
                if (i < 0) {
                    throw new IllegalArgumentException();
                }
                String function = section.getString(key);
                if (function == null) continue;
                slots.put(i, function);
            }
            catch (NumberFormatException e) {
                this.plugin.getLogger().warning("Invalid index \"" + key + "\" in " + String.valueOf(this));
            }
        }
        section = config.getConfigurationSection("items");
        if (section == null) {
            return;
        }
        for (String key : section.getKeys(false)) {
            ItemMeta meta;
            Material material;
            ConfigurationSection yamlItem = section.getConfigurationSection(key);
            if (yamlItem == null) {
                this.plugin.getLogger().warning("Invalid item \"" + key + "\" in " + String.valueOf(this));
                continue;
            }
            String materialString = yamlItem.getString("material", "dirt");
            try {
                material = Material.valueOf((String)materialString.toUpperCase().replace('-', '_'));
            }
            catch (IllegalArgumentException e1) {
                this.plugin.getLogger().warning("Invalid material \"" + materialString + "\" in menu " + String.valueOf(this));
                material = Material.DIRT;
            }
            ItemStack itemStack = new ItemStack(material, yamlItem.getInt("amount", 1));
            String skullTexture = yamlItem.getString("skull-texture", null);
            if (skullTexture != null) {
                VersionManager.getNms().addSkullTexture(itemStack, skullTexture, UUID.randomUUID());
            }
            if ((meta = itemStack.getItemMeta()) != null) {
                int cmd;
                List<String> lore;
                String displayName = yamlItem.getString("display-name");
                if (displayName != null) {
                    meta.setDisplayName(StringUT.color(displayName));
                }
                if ((lore = StringUT.color(yamlItem.getStringList("lore"))).size() > 0) {
                    meta.setLore(lore);
                }
                if ((cmd = yamlItem.getInt("custom-model-data", 0)) != 0) {
                    meta.setCustomModelData(Integer.valueOf(cmd));
                }
                itemStack.setItemMeta(meta);
            }
            items.put(key, itemStack);
        }
        this.slots = Collections.unmodifiableNavigableMap(slots);
        this.items = Collections.unmodifiableNavigableMap(items);
    }

    protected abstract String getTitle(String var1, T var2);

    public String getTitle(T parameter) {
        return this.getTitle(this.title, parameter);
    }

    public int getRows() {
        return this.rows;
    }

    public boolean isEmpty() {
        return this.slots.isEmpty();
    }

    public NavigableMap<Integer, String> getSlots() {
        return this.slots;
    }

    public NavigableMap<String, ItemStack> getItems() {
        return this.items;
    }

    @NotNull
    public ItemStack getItem(String name) {
        return this.items.getOrDefault(name, new ItemStack(Material.AIR)).clone();
    }

    @Nullable
    public abstract Slot getSlot(String var1, T var2, Player var3);

    public void setSlots(Menu menu, T parameter) {
        menu.slots.clear();
        Player player = menu.getPlayer();
        for (Map.Entry entry : this.slots.entrySet()) {
            Slot slot = this.getSlot((String)entry.getValue(), parameter, player);
            if (slot == null) continue;
            menu.setSlot((Integer)entry.getKey(), slot);
        }
        ItemStack emptySlot = this.getItem("empty");
        int size = menu.slots.lastKey() / (this.getRows() * 9) + 1;
        for (int i = 0; i < size; ++i) {
            menu.slots.putIfAbsent(i, new Slot(emptySlot));
        }
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        YAMLMenu yamlMenu = (YAMLMenu)o;
        return this.plugin.equals((Object)yamlMenu.plugin) && this.path.equals(yamlMenu.path);
    }

    public int hashCode() {
        return Objects.hash(this.plugin, this.path);
    }

    public String toString() {
        return this.plugin.getName() + ":" + this.path;
    }
}

