/*
 * Decompiled with CFR 0.152.
 */
package studio.magemonkey.codex.manager.editor.object;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import org.bukkit.Material;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;
import org.bukkit.event.inventory.InventoryClickEvent;
import org.bukkit.inventory.Inventory;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.ItemMeta;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import studio.magemonkey.codex.CodexPlugin;
import studio.magemonkey.codex.config.api.JYML;
import studio.magemonkey.codex.manager.api.gui.ContentType;
import studio.magemonkey.codex.manager.api.gui.GuiClick;
import studio.magemonkey.codex.manager.api.gui.GuiItem;
import studio.magemonkey.codex.manager.api.gui.JIcon;
import studio.magemonkey.codex.manager.api.gui.NGUI;
import studio.magemonkey.codex.manager.editor.EditorManager;
import studio.magemonkey.codex.manager.editor.EditorType;
import studio.magemonkey.codex.manager.editor.object.IEditorActionsMain;
import studio.magemonkey.codex.manager.editor.object.IEditorActionsSection;
import studio.magemonkey.codex.util.ClickText;
import studio.magemonkey.codex.util.StringUT;
import studio.magemonkey.codex.util.actions.ActionCategory;
import studio.magemonkey.codex.util.actions.Parametized;
import studio.magemonkey.codex.util.actions.params.IParam;

public class IEditorActionsParams<P extends CodexPlugin<P>>
extends NGUI<P> {
    private IEditorActionsSection<P> sectionEditor;
    private Parametized parametized;
    private ActionCategory category;
    private int pId;
    private String clickedParam;
    private static int[] objSlots;
    private static String objName;
    private static List<String> objLore;

    public IEditorActionsParams(@NotNull P plugin, @NotNull IEditorActionsSection<P> section, final @NotNull ActionCategory category, @NotNull Parametized parametized, int pId) {
        super(plugin, EditorManager.EDITOR_ACTIONS_PARAMS, "");
        GuiItem guiItem;
        this.sectionEditor = section;
        this.category = category;
        this.parametized = parametized;
        this.pId = pId;
        JYML cfg = EditorManager.EDITOR_ACTIONS_PARAMS;
        objSlots = cfg.getIntArray("object-slots");
        objName = StringUT.color(cfg.getString("object-name", "&eParam: &6%param-name%"));
        objLore = StringUT.color(cfg.getStringList("object-lore"));
        GuiClick click = new GuiClick(){
            final /* synthetic */ CodexPlugin val$plugin;
            final /* synthetic */ Parametized val$parametized;
            final /* synthetic */ IEditorActionsSection val$section;
            final /* synthetic */ int val$pId;
            final /* synthetic */ IEditorActionsParams this$0;
            {
                this.val$plugin = codexPlugin;
                this.val$parametized = parametized;
                this.val$section = iEditorActionsSection;
                this.val$pId = n;
                this.this$0 = this$0;
            }

            @Override
            public void click(@NotNull Player p, @Nullable Enum<?> type, @NotNull InventoryClickEvent e) {
                EditorType type2;
                if (type == null) {
                    return;
                }
                Class<?> clazz = type.getClass();
                if (clazz.equals(ContentType.class)) {
                    ContentType type22 = (ContentType)type;
                    switch (type22) {
                        case EXIT: {
                            p.closeInventory();
                            break;
                        }
                        case RETURN: {
                            this.this$0.sectionEditor.getEditorParametized(category).open(p, 1);
                            break;
                        }
                    }
                } else if (clazz.equals(EditorType.class) && (type2 = (EditorType)type) == EditorType.OBJECT_ACTIONS_PARAM_ADD) {
                    EditorManager.tipCustom(p, this.val$plugin.lang().Codex_Editor_Actions_Param_Add.getMsg());
                    EditorManager.startEdit(p, this.this$0, type2);
                    p.closeInventory();
                    StringBuilder builder = new StringBuilder();
                    HashSet<IParam> params = new HashSet<IParam>(this.val$parametized.getParams());
                    IEditorActionsMain.ActionBuilder abuilder = this.val$section.getEditorMain().getActionBuilder(this.val$section.getSectionId());
                    if (abuilder == null) {
                        return;
                    }
                    params.removeIf(param -> abuilder.getParametized(category).get(this.val$pId).values().stream().anyMatch(map -> map.containsKey(param.getKey().toLowerCase())));
                    params.forEach(param -> {
                        if (builder.length() > 0) {
                            builder.append("&7 | ");
                        }
                        builder.append("%" + param.getKey() + "%");
                    });
                    ClickText clickText = new ClickText(builder.toString());
                    params.forEach(param -> {
                        ClickText.ClickWord word = clickText.createPlaceholder("%" + param.getKey() + "%", "&a" + param.getKey());
                        word.hint(plugin.lang().Codex_Editor_Actions_Param_Hint.asList());
                        word.suggCmd(param.getKey() + " ");
                    });
                    clickText.send((CommandSender)p);
                }
            }
        };
        for (String sId : cfg.getSection("content")) {
            guiItem = cfg.getGuiItem("content." + sId, ContentType.class);
            if (guiItem == null) continue;
            if (guiItem.getType() != null) {
                guiItem.setClick(click);
            }
            this.addButton(guiItem);
        }
        for (String sId : cfg.getSection("editor")) {
            guiItem = cfg.getGuiItem("editor." + sId, EditorType.class);
            if (guiItem == null) continue;
            Enum<?> type = guiItem.getType();
            if (type != null) {
                guiItem.setClick(click);
            }
            this.addButton(guiItem);
        }
    }

    @NotNull
    public IEditorActionsSection<P> getSctionEditor() {
        return this.sectionEditor;
    }

    @NotNull
    public Parametized getParametized() {
        return this.parametized;
    }

    @NotNull
    public ActionCategory getCategory() {
        return this.category;
    }

    public int getpId() {
        return this.pId;
    }

    @NotNull
    public String getClickedParam() {
        return this.clickedParam;
    }

    @Override
    protected void onCreate(@NotNull Player p, @NotNull Inventory inv, int page) {
        IEditorActionsMain.ActionBuilder builder = this.sectionEditor.getEditorMain().getActionBuilder(this.sectionEditor.getSectionId());
        if (builder == null) {
            ((CodexPlugin)this.plugin).warn("Invalid ActionBuilder for '" + this.sectionEditor.getSectionId() + "' section! (2)");
            return;
        }
        Map<Parametized, Map<String, String>> mapTarget = builder.getParametized(this.category).get(this.pId);
        Map<String, String> par = mapTarget.get(this.parametized);
        int count = 0;
        for (Map.Entry<String, String> en : par.entrySet()) {
            ItemStack item = new ItemStack(Material.STONE_BUTTON);
            item.setAmount(count + 1);
            ItemMeta meta = item.getItemMeta();
            if (meta == null) continue;
            ArrayList<String> lore = new ArrayList<String>(objLore);
            lore.replaceAll(line -> line.replace("%param-value%", (CharSequence)en.getValue()).replace("%param-key%", (CharSequence)en.getKey()));
            meta.setDisplayName(objName.replace("%param-value%", en.getValue()).replace("%param-name%", en.getKey()));
            meta.setLore(lore);
            item.setItemMeta(meta);
            JIcon icon = new JIcon(item);
            icon.setClick((p2, type, e) -> {
                if (e.isShiftClick() && e.isRightClick()) {
                    builder.removeParametizedParam(this.pId, this.category, this.parametized, (String)en.getKey());
                    this.open(p, 1);
                    this.getSctionEditor().getEditorMain().save();
                    return;
                }
                this.clickedParam = (String)en.getKey();
                EditorManager.tipCustom(p2, ((CodexPlugin)this.plugin).lang().Codex_Editor_Actions_Param_Edit.getMsg());
                EditorManager.startEdit(p2, this, EditorType.OBJECT_ACTIONS_PARAM_VALUE);
                p2.closeInventory();
            });
            this.addButton(p, icon, objSlots[count++]);
        }
    }

    @Override
    protected boolean ignoreNullClick() {
        return true;
    }

    @Override
    protected boolean cancelClick(int slot) {
        return true;
    }

    @Override
    protected boolean cancelPlayerClick() {
        return true;
    }
}

