/*
 * Decompiled with CFR 0.152.
 */
package studio.magemonkey.codex.mccore.commands;

import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import org.bukkit.Bukkit;
import org.bukkit.ChatColor;
import org.bukkit.command.Command;
import org.bukkit.command.CommandMap;
import org.bukkit.command.CommandSender;
import org.bukkit.command.PluginCommand;
import org.bukkit.entity.Player;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.SimplePluginManager;
import org.bukkit.plugin.java.JavaPlugin;
import studio.magemonkey.codex.mccore.commands.ConfigurableCommand;
import studio.magemonkey.codex.mccore.config.CommentedConfig;
import studio.magemonkey.codex.mccore.config.parse.DataSection;
import studio.magemonkey.codex.mccore.util.TextSizer;
import studio.magemonkey.codex.mccore.util.TextSplitter;
import studio.magemonkey.codex.util.StringUT;

public class CommandManager {
    private static final HashMap<String, ConfigurableCommand> commands = new HashMap();
    private static final HashMap<Plugin, List<String>> plugins = new HashMap();
    private static final HashMap<Plugin, CommentedConfig> configs = new HashMap();
    private static final String HELP_BUTTON = "Format.help-button";
    private static final String HELP_NO_BUTTON = "Format.help-no-button";
    private static final String PAGE = "Format.page";
    private static final String NO_DESCRIPTION = "Format.no-description";
    private static final String COMMAND_USAGE = "Format.command-usage";
    private static final String NO_COMMANDS = "Format.no-commands";
    private static final String NEXT_PAGE = "Format.next-button";
    private static final String NEXT_PAGE_HOVER = "Format.next-button-hover";
    private static final String PREV_PAGE = "Format.prev-button";
    private static final String PREV_PAGE_HOVER = "Format.prev-button-hover";
    private static final String COMMAND = "Colors.command";
    private static final String REQUIRED = "Colors.required-args";
    private static final String OPTIONAL = "Colors.optional-args";
    private static final String DESCRIPTION = "Colors.description";
    private static final String PLAYER_SIZE = "player-help-size";
    private static final String CONSOLE_SIZE = "console-help-size";
    private static int playerSize = 10;
    private static int consoleSize = 15;
    private static ChatColor command = ChatColor.GOLD;
    private static ChatColor requiredArgs = ChatColor.LIGHT_PURPLE;
    private static ChatColor optionalArgs = ChatColor.GREEN;
    private static ChatColor description = ChatColor.GRAY;
    private static String pageFormat = String.valueOf(ChatColor.DARK_GREEN) + "(" + String.valueOf(ChatColor.GOLD) + "{page}" + String.valueOf(ChatColor.DARK_GREEN) + "/" + String.valueOf(ChatColor.GOLD) + "{max}" + String.valueOf(ChatColor.DARK_GREEN) + ")";
    private static String noDescription = "No description available";
    private static String noCommands = String.valueOf(ChatColor.GRAY) + "No commands available";
    private static String nextPage = "Next";
    private static String prevPage = "Previous";
    private static String nextPageHover = "Next Page";
    private static String prevPageHover = "Previous Page";
    private static List<String> helpWithButton = new ArrayList<String>(){
        {
            this.add(String.valueOf(ChatColor.DARK_GRAY) + "-----------------------------------------------------");
            this.add(String.valueOf(ChatColor.DARK_GREEN) + "{title} - Command Usage {page}");
            this.add("{commands}");
            this.add(String.valueOf(ChatColor.DARK_GRAY) + "-----------------------------------------------------");
            this.add("{buttons}");
        }
    };
    private static List<String> helpNoButton = new ArrayList<String>(){
        {
            this.add(String.valueOf(ChatColor.DARK_GRAY) + "-----------------------------------------------------");
            this.add(String.valueOf(ChatColor.DARK_GREEN) + "{title} - Command Usage {page}");
            this.add(String.valueOf(ChatColor.DARK_GRAY) + "-----------------------------------------------------");
            this.add("{commands}");
            this.add(String.valueOf(ChatColor.DARK_GRAY) + "-----------------------------------------------------");
        }
    };
    private static List<String> commandUsage = new ArrayList<String>(){
        {
            this.add(String.valueOf(ChatColor.DARK_GRAY) + "-----------------------------------------------------");
            this.add(String.valueOf(ChatColor.GOLD) + "{command}");
            this.add(String.valueOf(ChatColor.DARK_GRAY) + "-----------------------------------------------------");
            this.add(String.valueOf(ChatColor.GRAY) + "{description}");
            this.add(String.valueOf(ChatColor.DARK_GRAY) + "-----------------------------------------------------");
        }
    };
    private static boolean invalidRegistration = false;

    public static boolean isInvalidRegistration() {
        return invalidRegistration;
    }

    public static String getDescriptionReplacement() {
        return noDescription;
    }

    public static void registerCommand(ConfigurableCommand command) {
        if (!command.isRootCommand()) {
            throw new IllegalArgumentException("Cannot register a sub command");
        }
        if (commands.containsKey(command.getName())) {
            throw new IllegalArgumentException("Duplicate command name found: \"" + command.getName() + "\"");
        }
        command.markAsRegistered();
        commands.put(command.getName(), command);
        if (!plugins.containsKey(command.getPlugin())) {
            plugins.put((Plugin)command.getPlugin(), new ArrayList());
            configs.put((Plugin)command.getPlugin(), new CommentedConfig(command.getPlugin(), "commands"));
        }
        plugins.get(command.getPlugin()).add(command.getName());
        try {
            if (!Bukkit.getServer().getClass().getSimpleName().equals("ServerMock")) {
                Field field = SimplePluginManager.class.getDeclaredField("commandMap");
                if (!field.isAccessible()) {
                    field.setAccessible(true);
                }
                CommandMap map = (CommandMap)field.get(Bukkit.getPluginManager());
                map.register(command.getName(), (Command)command);
            } else {
                Field field = Class.forName("org.mockbukkit.mockbukkit.ServerMock").getDeclaredField("commandMap");
                Field commands = Class.forName("org.mockbukkit.mockbukkit.plugin.PluginManagerMock").getDeclaredField("commands");
                if (!field.canAccess(Bukkit.getServer())) {
                    field.setAccessible(true);
                }
                if (!commands.canAccess(Bukkit.getServer().getPluginManager())) {
                    commands.setAccessible(true);
                }
                CommandMap map = (CommandMap)field.get(Bukkit.getServer());
                List cmds = (List)commands.get(Bukkit.getServer().getPluginManager());
                Method m = Class.forName("org.bukkit.command.PluginCommandUtils").getMethod("createPluginCommand", String.class, Plugin.class);
                PluginCommand cmd = (PluginCommand)m.invoke(null, command.getName(), command.getPlugin());
                cmds.add(cmd);
                map.register(command.getName(), (Command)command);
            }
        }
        catch (Exception ex) {
            invalidRegistration = true;
            Bukkit.getLogger().severe("Failed to set up commands, using custom implementation instead");
        }
    }

    public static void unregisterCommand(ConfigurableCommand command) {
        commands.remove(command.getName());
    }

    public static void unregisterCommands(Plugin plugin) {
        List<String> list = plugins.get(plugin);
        if (list == null) {
            return;
        }
        for (String command : list) {
            commands.remove(command);
        }
        plugins.remove(plugin);
        configs.remove(plugin);
    }

    public static void unregisterAll() {
        plugins.clear();
        commands.clear();
        configs.clear();
    }

    public static ConfigurableCommand getCommand(String name) {
        return commands.get(name.toLowerCase());
    }

    public static CommentedConfig getConfig(JavaPlugin plugin) {
        if (!configs.containsKey(plugin)) {
            configs.put((Plugin)plugin, new CommentedConfig(plugin, "commands"));
        }
        return configs.get(plugin);
    }

    public static void displayUsage(ConfigurableCommand c, CommandSender sender) {
        CommandManager.displayUsage(c, sender, 1);
    }

    public static void displayUsage(ConfigurableCommand c, CommandSender sender, int page) {
        while (c.hasParent() && !c.canUseCommand(sender)) {
            c = c.getParent();
        }
        if (c.canUseCommand(sender)) {
            if (c.isContainer()) {
                CommandManager.displayGeneralUsage(c, sender, page);
            } else {
                CommandManager.displaySpecificUsage(c, sender);
            }
        }
    }

    private static void displaySpecificUsage(ConfigurableCommand c, CommandSender sender) {
        String command = "/" + c.toString() + " " + c.getArgs().replace("[", String.valueOf(optionalArgs) + "[").replace("<", String.valueOf(requiredArgs) + "<");
        for (String line : commandUsage) {
            if (line.contains("{description}")) {
                List<String> dLines;
                if (sender instanceof Player) {
                    dLines = TextSizer.split(c.getDescription(), 320 - TextSizer.measureString(line.replace("{description}", "")));
                    for (String d : dLines) {
                        sender.sendMessage(line.replace("{description}", d));
                    }
                    continue;
                }
                dLines = TextSplitter.getLines(c.getDescription(), 60 - ChatColor.stripColor((String)line.replace("{description}", "")).length());
                for (String d : dLines) {
                    sender.sendMessage(line.replace("{description}", d));
                }
                continue;
            }
            sender.sendMessage(line.replace("{command}", command));
        }
    }

    private static void displayGeneralUsage(ConfigurableCommand c, CommandSender sender, int page) {
        int maxPage;
        int entries;
        List<String> keys = c.getUsableCommands(sender);
        if (keys.size() == 0) {
            sender.sendMessage(noCommands);
            return;
        }
        Collections.sort(keys);
        if (sender instanceof Player) {
            entries = playerSize - helpWithButton.size() + 1;
            if (entries >= keys.size() + 1) {
                ++entries;
            }
        } else {
            entries = consoleSize - helpNoButton.size() + 1;
        }
        if (entries < 1) {
            entries = 1;
        }
        if (page > (maxPage = (keys.size() + entries - 1) / entries)) {
            page = maxPage;
        }
        if (page < 1) {
            page = 1;
        }
        String pageString = maxPage == 1 ? "" : pageFormat.replace("{page}", "" + page).replace("{max}", "" + maxPage);
        String titleString = "/" + c.toString();
        int maxSize = 0;
        int index = 0;
        for (String key : keys) {
            if (++index <= (page - 1) * entries || index > page * entries) continue;
            String args = c.getSubCommand(key).getArgs();
            int size = sender instanceof Player ? TextSizer.measureString(key + " " + args) : (key + " " + args).length();
            if (size <= maxSize) continue;
            maxSize = size;
        }
        maxSize = sender instanceof Player ? (maxSize += 4) : ++maxSize;
        if (sender instanceof Player) {
            String ends = "PreviousNext";
            String spacing = TextSizer.expand(" ", 320 - TextSizer.measureString(ends), true);
            if (!spacing.startsWith(" ")) {
                spacing = spacing.substring(spacing.indexOf(32));
            }
            String buttons = "tellraw " + sender.getName() + " {\"text\":\"\",\"extra\":[{\"text\":\"" + prevPage + "\",\"clickEvent\":{\"action\":\"run_command\",\"value\":\"" + titleString + " " + ((page + maxPage - 2) % maxPage + 1) + "\"},\"hoverEvent\":{\"action\":\"show_text\",\"value\":\"" + prevPageHover + "\"}},{\"text\":\"" + spacing + "\"},{\"text\":\"" + nextPage + "\",\"clickEvent\":{\"action\":\"run_command\",\"value\":\"" + titleString + " " + (page % maxPage + 1) + "\"},\"hoverEvent\":{\"action\":\"show_text\",\"value\":\"" + nextPageHover + "\"}}]}";
            for (String line : helpWithButton) {
                if (line.contains("{commands}")) {
                    index = 0;
                    for (String key : keys) {
                        if (++index <= (page - 1) * entries || index > page * entries) continue;
                        ConfigurableCommand sub = c.getSubCommand(key);
                        String args = sub.getArgs().replace("[", String.valueOf(optionalArgs) + "[").replace("<", String.valueOf(requiredArgs) + "<");
                        sender.sendMessage(line.replace("{commands}", String.valueOf(command) + "/" + c.toString() + " " + TextSizer.expand(key + " " + args, maxSize, false) + String.valueOf(ChatColor.GRAY) + "- " + String.valueOf(description) + sub.getDescription()));
                    }
                    continue;
                }
                if (line.contains("{buttons}")) {
                    if (maxPage <= 1) continue;
                    Bukkit.getServer().dispatchCommand((CommandSender)Bukkit.getConsoleSender(), buttons);
                    continue;
                }
                sender.sendMessage(line.replace("{title}", titleString).replace("{page}", pageString));
            }
        } else {
            for (String line : helpNoButton) {
                if (line.contains("{commands}")) {
                    index = 0;
                    for (String key : keys) {
                        if (++index <= (page - 1) * entries || index > page * entries) continue;
                        ConfigurableCommand sub = c.getSubCommand(key);
                        String args = sub.getArgs().replace("[", String.valueOf(optionalArgs) + "[").replace("<", String.valueOf(requiredArgs) + "<");
                        sender.sendMessage(line.replace("{commands}", String.valueOf(command) + "/" + c.toString() + " " + TextSizer.expandConsole(key + " " + args, maxSize, false) + String.valueOf(ChatColor.GRAY) + "- " + String.valueOf(description) + sub.getDescription()));
                    }
                    continue;
                }
                sender.sendMessage(line.replace("{title}", titleString).replace("{page}", pageString));
            }
        }
    }

    public static String[] trimArgs(String[] args) {
        if (args.length == 0) {
            return args;
        }
        String[] trimmed = new String[args.length - 1];
        if (trimmed.length > 0) {
            System.arraycopy(args, 1, trimmed, 0, trimmed.length);
        }
        return trimmed;
    }

    public static void loadOptions(DataSection config) {
        playerSize = config.getInt(PLAYER_SIZE, playerSize);
        consoleSize = config.getInt(CONSOLE_SIZE, consoleSize);
        command = CommandManager.getColor(config.getString(COMMAND, null), command);
        requiredArgs = CommandManager.getColor(config.getString(REQUIRED, null), requiredArgs);
        optionalArgs = CommandManager.getColor(config.getString(OPTIONAL, null), optionalArgs);
        description = CommandManager.getColor(config.getString(DESCRIPTION, null), description);
        pageFormat = StringUT.color(config.getString(PAGE, pageFormat));
        noDescription = StringUT.color(config.getString(NO_DESCRIPTION, noDescription));
        noCommands = StringUT.color(config.getString(NO_COMMANDS, noCommands));
        nextPage = StringUT.color(config.getString(NEXT_PAGE, nextPage));
        prevPage = StringUT.color(config.getString(PREV_PAGE, prevPage));
        nextPageHover = StringUT.color(config.getString(NEXT_PAGE_HOVER, nextPageHover));
        prevPageHover = StringUT.color(config.getString(PREV_PAGE_HOVER, prevPageHover));
        helpWithButton = config.has(HELP_BUTTON) && config.isList(HELP_BUTTON) ? StringUT.color(config.getList(HELP_BUTTON)) : helpWithButton;
        helpNoButton = config.has(HELP_NO_BUTTON) && config.isList(HELP_NO_BUTTON) ? StringUT.color(config.getList(HELP_NO_BUTTON)) : helpNoButton;
        commandUsage = config.has(COMMAND_USAGE) && config.isList(COMMAND_USAGE) ? StringUT.color(config.getList(COMMAND_USAGE)) : commandUsage;
    }

    private static ChatColor getColor(String input, ChatColor defaultColor) {
        if (input == null) {
            return defaultColor;
        }
        try {
            return ChatColor.valueOf((String)input.toUpperCase().replace(' ', '_'));
        }
        catch (Exception ex) {
            return defaultColor;
        }
    }
}

