/*
 * Decompiled with CFR 0.152.
 */
package studio.magemonkey.codex.mccore.commands;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.bukkit.command.Command;
import org.bukkit.command.CommandSender;
import org.bukkit.command.TabCompleter;
import org.bukkit.entity.Player;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.java.JavaPlugin;
import org.bukkit.util.StringUtil;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import studio.magemonkey.codex.CodexEngine;
import studio.magemonkey.codex.mccore.commands.CommandManager;
import studio.magemonkey.codex.mccore.commands.IFunction;
import studio.magemonkey.codex.mccore.commands.SenderType;
import studio.magemonkey.codex.mccore.config.CommentedConfig;
import studio.magemonkey.codex.mccore.config.CustomFilter;
import studio.magemonkey.codex.mccore.config.parse.DataSection;
import studio.magemonkey.codex.util.StringUT;

public class ConfigurableCommand
extends Command {
    private static final String SENDER_KEY = "sender";
    private static final String ENABLED_KEY = "enabled";
    private static final String DESCRIPTION_KEY = "description";
    private static final String PERMISSION_KEY = "permission";
    private static final String NAME_KEY = "name";
    private static final String ARGS_KEY = "args";
    private static final String MESSAGES_KEY = "messages";
    private static final String COOLDOWN_KEY = "cooldown";
    private final JavaPlugin plugin;
    private final Map<String, ConfigurableCommand> subCommands = new HashMap<String, ConfigurableCommand>();
    private final Map<String, String> messages = new HashMap<String, String>();
    private ConfigurableCommand parent;
    private IFunction function;
    private SenderType senderType;
    private String description;
    private String permission;
    private String name;
    private String args;
    private String key;
    private boolean registered;
    private boolean enabled;
    private int cooldown;
    private long timer;

    @Contract(value="null, _ -> null")
    public static List<String> getTabCompletions(@Nullable Collection<String> options, @NotNull String[] args) {
        if (options == null) {
            return null;
        }
        String joined = String.join((CharSequence)" ", args);
        return options.stream().filter(name -> StringUtil.startsWithIgnoreCase((String)name, (String)joined)).sorted(String.CASE_INSENSITIVE_ORDER).map(key -> key.substring(joined.lastIndexOf(32) + 1)).collect(Collectors.toList());
    }

    @NotNull
    public static List<String> getPlayerTabCompletions(@NotNull CommandSender sender, @NotNull String arg) {
        Player senderPlayer = sender instanceof Player ? (Player)sender : null;
        return ConfigurableCommand.getTabCompletions(sender.getServer().getOnlinePlayers().stream().filter(player -> senderPlayer == null || senderPlayer.canSee(player)).map(Player::getName).collect(Collectors.toList()), new String[]{arg});
    }

    public ConfigurableCommand(JavaPlugin plugin, String key, SenderType senderType) {
        this(plugin, key, senderType, null, null, null, null);
    }

    public ConfigurableCommand(JavaPlugin plugin, String key, SenderType senderType, String description) {
        this(plugin, key, senderType, null, description, null, null);
    }

    public ConfigurableCommand(JavaPlugin plugin, String key, SenderType senderType, IFunction function) {
        this(plugin, key, senderType, function, null, null, null);
    }

    public ConfigurableCommand(JavaPlugin plugin, String key, SenderType senderType, IFunction function, String description) {
        this(plugin, key, senderType, function, description, null, null);
    }

    public ConfigurableCommand(JavaPlugin plugin, String key, SenderType senderType, IFunction function, String description, String args) {
        this(plugin, key, senderType, function, description, args, null);
    }

    public ConfigurableCommand(JavaPlugin plugin, String key, SenderType senderType, IFunction function, String description, String args, String permission) {
        super(key, description == null ? "" : description, "", new ArrayList());
        this.plugin = plugin;
        this.senderType = senderType;
        this.function = function;
        this.registered = false;
        this.enabled = true;
        this.key = key;
        this.load(key, description, args, permission);
    }

    public boolean hasDescription() {
        return this.description != null;
    }

    public boolean hasArguments() {
        return this.args != null;
    }

    public boolean requiresPermission() {
        return this.permission != null;
    }

    public boolean hasSubCommand(String name) {
        return this.subCommands.containsKey(name.toLowerCase());
    }

    public boolean canUseCommand(CommandSender sender) {
        return !(!this.enabled || this.senderType == SenderType.PLAYER_ONLY && !(sender instanceof Player) || this.senderType == SenderType.CONSOLE_ONLY && sender instanceof Player || this.permission != null && !sender.hasPermission(this.permission) && sender instanceof Player);
    }

    public boolean isRootCommand() {
        return this.parent == null;
    }

    public String getName() {
        return this.name;
    }

    public JavaPlugin getPlugin() {
        return this.plugin;
    }

    public String getDescription() {
        return this.description == null ? CommandManager.getDescriptionReplacement() : this.description;
    }

    public String getArgs() {
        return this.args == null ? "" : this.args;
    }

    public String getPermission() {
        return this.permission;
    }

    public SenderType getSenderType() {
        return this.senderType;
    }

    public List<String> getUsableCommands(CommandSender sender) {
        ArrayList<String> keys = new ArrayList<String>();
        for (Map.Entry<String, ConfigurableCommand> entry : this.subCommands.entrySet()) {
            if (!entry.getValue().canUseCommand(sender)) continue;
            keys.add(entry.getKey());
        }
        return keys;
    }

    public ConfigurableCommand getSubCommand(String name) {
        return this.subCommands.get(name);
    }

    public boolean hasParent() {
        return this.parent != null;
    }

    public ConfigurableCommand getParent() {
        return this.parent;
    }

    public boolean isContainer() {
        return this.function == null;
    }

    public boolean isFunction() {
        return this.function != null;
    }

    public void markAsRegistered() {
        this.registered = true;
    }

    public void addSubCommand(ConfigurableCommand command) {
        if (this.function != null) {
            throw new IllegalStateException("A sub command cannot be added to \"/" + this.toString() + "\", it's already attached to a function");
        }
        if (command.registered) {
            throw new IllegalArgumentException("A registered command cannot be added to another command");
        }
        command.parent = this;
        this.subCommands.put(command.name, command);
    }

    public void addSubCommands(ConfigurableCommand ... commands) {
        for (ConfigurableCommand command : commands) {
            this.addSubCommand(command);
        }
    }

    public boolean execute(CommandSender sender, String label, String[] args) {
        return this.execute(sender, args);
    }

    public boolean execute(CommandSender sender, String[] args) {
        if (!this.canUseCommand(sender)) {
            return false;
        }
        if (this.cooldown > 0 && System.currentTimeMillis() - this.timer < (long)this.cooldown * 1000L) {
            String message = StringUT.color(((CodexEngine)CodexEngine.getPlugin(CodexEngine.class)).getCommandMessage());
            int time = this.cooldown - (int)(System.currentTimeMillis() - this.timer + 999L) / 1000;
            message = message.replace("{time}", "" + time);
            sender.sendMessage(message);
            return false;
        }
        this.timer = System.currentTimeMillis();
        if (this.function != null) {
            this.function.execute(this, (Plugin)this.plugin, sender, args);
        } else {
            if (args.length > 0 && this.hasSubCommand(args[0])) {
                ConfigurableCommand subCommand = this.subCommands.get(args[0].toLowerCase());
                args = CommandManager.trimArgs(args);
                return subCommand.execute(sender, args);
            }
            this.displayHelp(sender, args);
        }
        return true;
    }

    @NotNull
    public List<String> tabComplete(@NotNull CommandSender sender, @NotNull String alias, @NotNull String[] args) throws IllegalArgumentException {
        if (this.function == null) {
            if (args.length > 1 && this.hasSubCommand(args[0])) {
                ConfigurableCommand subCommand = this.subCommands.get(args[0].toLowerCase());
                return subCommand.tabComplete(sender, subCommand.name, CommandManager.trimArgs(args));
            }
            return ConfigurableCommand.getTabCompletions(this.subCommands.keySet(), args);
        }
        if (this.function instanceof TabCompleter) {
            List completions = ((TabCompleter)this.function).onTabComplete(sender, (Command)this, alias, args);
            if (completions == null) {
                return List.of();
            }
            return completions;
        }
        return List.of();
    }

    public void displayHelp(CommandSender sender) {
        this.displayHelp(sender, 1);
    }

    public void displayHelp(CommandSender sender, String[] args) {
        int page = 1;
        if (args != null && args.length > 0) {
            try {
                page = Integer.parseInt(args[0]);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        this.displayHelp(sender, page);
    }

    public void displayHelp(CommandSender sender, int page) {
        CommandManager.displayUsage(this, sender, page);
    }

    public String getMessage(String key, String defaultMessage, CustomFilter ... filters) {
        DataSection config;
        DataSection msgSection;
        CommentedConfig pluginConfig = CommandManager.getConfig(this.plugin);
        DataSection main = pluginConfig.getConfig();
        if (!main.has(this.key)) {
            main.createSection(this.key);
        }
        if ((msgSection = (config = main.getSection(this.key)).getSection(MESSAGES_KEY)) == null || !msgSection.has(key)) {
            if (msgSection == null) {
                msgSection = config.createSection(MESSAGES_KEY);
            }
            msgSection.set(key, defaultMessage.replace('\u00a7', '&'));
            pluginConfig.save();
        }
        String msg = StringUT.color(msgSection.getString(key));
        for (CustomFilter filter : filters) {
            msg = filter.apply(msg);
        }
        return msg;
    }

    public void sendMessage(CommandSender sender, String key, String defaultMessage, CustomFilter ... filters) {
        String str = this.getMessage(key, defaultMessage, filters);
        if (str.length() > 0) {
            sender.sendMessage(str);
        }
    }

    private void load(String key, String description, String args, String permission) {
        CommentedConfig pluginConfig = CommandManager.getConfig(this.plugin);
        DataSection main = pluginConfig.getConfig();
        DataSection config = main.defaultSection(key);
        this.name = config.getString(NAME_KEY, key).toLowerCase();
        this.description = config.getString(DESCRIPTION_KEY, description);
        this.permission = config.getString(PERMISSION_KEY, permission);
        this.args = config.getString(ARGS_KEY, args);
        this.enabled = config.getBoolean(ENABLED_KEY, this.enabled);
        this.cooldown = config.getInt(COOLDOWN_KEY, this.cooldown);
        if (config.has(MESSAGES_KEY)) {
            DataSection msgSection = config.getSection(MESSAGES_KEY);
            for (String msgKey : msgSection.keys()) {
                this.messages.put(msgKey, msgSection.getString(msgKey));
            }
        }
        if (this.name.contains(" ")) {
            String noSpaces = this.name.replace(" ", "");
            this.plugin.getLogger().warning("Invalid command name \"" + this.name + "\", using \"" + noSpaces + "\" instead");
            this.name = noSpaces;
        }
        try {
            this.senderType = config.has(SENDER_KEY) ? SenderType.valueOf(config.getString(SENDER_KEY).toUpperCase().replace(" ", "_")) : this.senderType;
        }
        catch (Exception ex) {
            this.plugin.getLogger().warning("Invalid sender type for command \"/" + this.toString() + "\", using the default instead");
        }
        config.set(NAME_KEY, this.name);
        config.set(DESCRIPTION_KEY, this.description);
        config.set(PERMISSION_KEY, this.permission);
        config.set(ARGS_KEY, args);
        config.set(SENDER_KEY, this.senderType.name());
        config.set(ENABLED_KEY, this.enabled);
        config.set(COOLDOWN_KEY, this.cooldown);
        pluginConfig.save();
    }

    public String toString() {
        if (this.parent == null) {
            return this.name;
        }
        return this.parent.toString() + " " + this.name;
    }
}

