/*
 * Decompiled with CFR 0.152.
 */
package studio.magemonkey.codex.mccore.config;

import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import org.bukkit.configuration.ConfigurationSection;
import studio.magemonkey.codex.mccore.config.ExcludeField;
import studio.magemonkey.codex.mccore.config.SerializableField;

public class ConfigSerializer {
    public static final String ALL_FLAG = "ALL";
    private static final HashMap<String, Integer> flags = new HashMap<String, Integer>(){
        {
            this.put(ConfigSerializer.ALL_FLAG, Integer.MAX_VALUE);
        }
    };
    private static int flagCount = 0;

    public static void defineFlag(String name) {
        if (flagCount == 30) {
            throw new IllegalArgumentException("Cannot contain any more flags");
        }
        if (flags.containsKey(name)) {
            throw new IllegalArgumentException("Flag name already in use: " + name);
        }
        flags.put(name, 1 << flagCount++);
    }

    public static void defineFlagGroup(String name, String ... members) {
        if (flags.containsKey(name)) {
            throw new IllegalArgumentException("Flag name already in use: " + name);
        }
        int value = 0;
        for (String flag : members) {
            if (!flags.containsKey(flag)) continue;
            value += flags.get(flag).intValue();
        }
        if (value > 0) {
            flags.put(name, value);
        }
    }

    public static void serialize(Object obj, ConfigurationSection config) {
        ConfigSerializer.serialize(obj, config, ALL_FLAG);
    }

    public static void serialize(Object obj, ConfigurationSection config, String flag) {
        if (!flags.containsKey(flag)) {
            throw new IllegalArgumentException("Flag is not registered: " + flag);
        }
        if (config == null) {
            throw new IllegalArgumentException("Cannot serialize into a null configuration");
        }
        if (obj == null) {
            return;
        }
        int value = flags.get(flag);
        ArrayList<Field> fields = new ArrayList<Field>();
        for (Class<?> c = obj.getClass(); c != null; c = c.getSuperclass()) {
            fields.addAll(Arrays.asList(c.getDeclaredFields()));
        }
        for (Field field : fields) {
            field.setAccessible(true);
            ExcludeField exclude = field.getAnnotation(ExcludeField.class);
            if (exclude != null && (flags.get(exclude.flag()) & value) > 0) continue;
            try {
                SerializableField serializable = field.getAnnotation(SerializableField.class);
                if (serializable != null && (flags.get(serializable.flag()) & value) > 0) {
                    if (!config.contains(field.getName())) {
                        config.createSection(field.getName());
                    }
                    if (serializable.list()) {
                        int index = 1;
                        ConfigurationSection listSection = config.getConfigurationSection(field.getName());
                        for (Object object : (Iterable)field.get(obj)) {
                            String path = "item" + index;
                            if (!listSection.contains(path)) {
                                listSection.createSection(path);
                            }
                            ConfigSerializer.serialize(object, listSection.getConfigurationSection(path));
                        }
                        continue;
                    }
                    if (serializable.map()) {
                        ConfigurationSection root = config.getConfigurationSection(field.getName());
                        HashMap map = (HashMap)((Object)serializable);
                        for (Map.Entry entry : map.entrySet()) {
                            if (!root.contains(entry.getKey().toString())) {
                                root.createSection(entry.getKey().toString());
                            }
                            ConfigurationSection mapSection = root.getConfigurationSection(entry.getKey().toString());
                            ConfigSerializer.serialize(entry.getValue(), mapSection);
                        }
                        continue;
                    }
                    ConfigSerializer.serialize(field.get(obj), config.getConfigurationSection(field.getName()), flag);
                    continue;
                }
                Object v = field.get(obj);
                config.set(field.getName(), v);
            }
            catch (Exception exception) {}
        }
    }
}

