/*
 * Decompiled with CFR 0.152.
 */
package studio.magemonkey.codex.mccore.config;

import java.util.ArrayList;
import java.util.List;
import org.bukkit.Bukkit;
import org.bukkit.Location;

public class LocationData {
    public static String serializeSimpleLocation(Location loc) {
        if (loc == null) {
            return null;
        }
        return loc.getWorld().getName() + "," + loc.getBlockX() + "," + loc.getBlockY() + "," + loc.getBlockZ();
    }

    public static String serializeLocation(Location loc) {
        if (loc == null) {
            return null;
        }
        return loc.getWorld().getName() + "," + loc.getX() + "," + loc.getY() + "," + loc.getZ();
    }

    public static String serializeDetailedLocation(Location loc) {
        if (loc == null) {
            return null;
        }
        return loc.getWorld().getName() + "," + loc.getX() + "," + loc.getY() + "," + loc.getZ() + "," + loc.getYaw() + "," + loc.getPitch();
    }

    public static Location parseLocation(String dataString) {
        if (dataString == null || !dataString.contains(",")) {
            return null;
        }
        String[] pieces = dataString.split(",");
        if (pieces.length == 4) {
            return new Location(Bukkit.getWorld((String)pieces[0]), Double.parseDouble(pieces[1]), Double.parseDouble(pieces[2]), Double.parseDouble(pieces[3]));
        }
        if (pieces.length == 6) {
            return new Location(Bukkit.getWorld((String)pieces[0]), Double.parseDouble(pieces[1]), Double.parseDouble(pieces[2]), Double.parseDouble(pieces[3]), Float.parseFloat(pieces[4]), Float.parseFloat(pieces[5]));
        }
        return null;
    }

    public static List<String> serializeSimpleLocations(List<Location> locations) {
        if (locations == null || locations.size() == 0) {
            return null;
        }
        ArrayList<String> list = new ArrayList<String>();
        for (Location location : locations) {
            list.add(LocationData.serializeSimpleLocation(location));
        }
        return list;
    }

    public static List<String> serializeLocations(List<Location> locations) {
        if (locations == null || locations.size() == 0) {
            return null;
        }
        ArrayList<String> list = new ArrayList<String>();
        for (Location location : locations) {
            list.add(LocationData.serializeLocation(location));
        }
        return list;
    }

    public static List<String> serializeDetailedLocations(List<Location> locations) {
        if (locations == null || locations.size() == 0) {
            return null;
        }
        ArrayList<String> list = new ArrayList<String>();
        for (Location location : locations) {
            list.add(LocationData.serializeDetailedLocation(location));
        }
        return list;
    }

    public static List<Location> parseLocations(List<String> dataStrings) {
        if (dataStrings == null || dataStrings.size() == 0) {
            return null;
        }
        ArrayList<Location> list = new ArrayList<Location>();
        for (String dataString : dataStrings) {
            Location loc = LocationData.parseLocation(dataString);
            if (loc == null) continue;
            list.add(loc);
        }
        return list;
    }

    public static String serializeCompactSimpleLocations(List<Location> locations) {
        if (locations == null || locations.size() == 0) {
            return null;
        }
        StringBuilder data = new StringBuilder();
        for (Location loc : locations) {
            data.append(LocationData.serializeSimpleLocation(loc));
            data.append(":");
        }
        return data.length() > 0 ? data.substring(0, data.length() - 1) : null;
    }

    public static String serializeCompactLocations(List<Location> locations) {
        if (locations == null || locations.size() == 0) {
            return null;
        }
        StringBuilder data = new StringBuilder();
        for (Location loc : locations) {
            data.append(LocationData.serializeLocation(loc));
            data.append(":");
        }
        return data.length() > 0 ? data.substring(0, data.length() - 1) : null;
    }

    public static String serializeCompactDetailedLocations(List<Location> locations) {
        if (locations == null || locations.size() == 0) {
            return null;
        }
        StringBuilder data = new StringBuilder();
        for (Location loc : locations) {
            data.append(LocationData.serializeDetailedLocation(loc));
            data.append(":");
        }
        return data.length() > 0 ? data.substring(0, data.length() - 1) : null;
    }

    public static List<Location> parseCompactLocations(String dataString) {
        if (dataString == null || dataString.length() == 0) {
            return null;
        }
        String[] dataStrings = dataString.contains(":") ? dataString.split(":") : new String[]{dataString};
        ArrayList<Location> list = new ArrayList<Location>();
        for (String data : dataStrings) {
            Location loc = LocationData.parseLocation(data);
            if (loc == null) continue;
            list.add(loc);
        }
        return list;
    }
}

