/*
 * Decompiled with CFR 0.152.
 */
package studio.magemonkey.codex.mccore.scoreboard;

import java.util.List;
import org.bukkit.ChatColor;
import org.bukkit.command.CommandSender;
import org.jetbrains.annotations.NotNull;
import studio.magemonkey.codex.CodexPlugin;
import studio.magemonkey.codex.commands.api.ISubCommand;
import studio.magemonkey.codex.mccore.scoreboard.BoardManager;
import studio.magemonkey.codex.mccore.scoreboard.PlayerBoards;
import studio.magemonkey.codex.mccore.scoreboard.ScoreboardNodes;

public class ShowCommand<P extends CodexPlugin<P>>
extends ISubCommand<P> {
    ShowCommand(P plugin) {
        super(plugin, List.of("show"), ScoreboardNodes.SHOW.getNode());
    }

    @Override
    public void perform(@NotNull CommandSender sender, @NotNull String label, @NotNull String[] args) {
        if (args.length > 1) {
            StringBuilder name = new StringBuilder(args[1]);
            for (int i = 2; i < args.length; ++i) {
                name.append(" ").append(args[i]);
            }
            PlayerBoards board = BoardManager.getPlayerBoards(sender.getName());
            if (board.showBoard(name.toString())) {
                sender.sendMessage(String.valueOf(ChatColor.DARK_GREEN) + "Your scoreboard has been changed");
            } else {
                sender.sendMessage(String.valueOf(ChatColor.DARK_RED) + "You do not have a scoreboard with that name");
            }
        } else {
            this.printUsage(sender);
        }
    }

    @Override
    @NotNull
    public String usage() {
        return "<boardName>";
    }

    @Override
    @NotNull
    public String description() {
        return "Shows the scoreboard";
    }

    @Override
    public boolean playersOnly() {
        return true;
    }
}

