/*
 * Decompiled with CFR 0.152.
 */
package studio.magemonkey.codex.mccore.sql.direct;

import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.DriverManager;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.HashMap;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.bukkit.configuration.ConfigurationSection;
import org.bukkit.plugin.Plugin;
import studio.magemonkey.codex.mccore.sql.ColumnType;
import studio.magemonkey.codex.mccore.sql.direct.SQLTable;

public class SQLDatabase {
    private final HashMap<String, SQLTable> tables = new HashMap();
    private final Plugin plugin;
    private final String connectionURL;
    private final String user;
    private final String password;
    private Connection connection;

    public SQLDatabase(Plugin plugin, String host, String port, String database, String username, String password) {
        this.plugin = plugin;
        this.connectionURL = "jdbc:mysql://" + host + ":" + port + "/" + database;
        this.user = username;
        this.password = password;
    }

    public SQLDatabase(Plugin plugin, ConfigurationSection config) {
        this.plugin = plugin;
        this.connectionURL = "jdbc:mysql://" + config.getString("host") + ":" + config.getString("port") + "/" + config.getString("database");
        this.user = config.getString("username");
        this.password = config.getString("password");
    }

    public Logger getLogger() {
        return this.plugin.getLogger();
    }

    public DatabaseMetaData getMeta() throws SQLException {
        return this.isConnected() ? this.connection.getMetaData() : null;
    }

    public boolean isConnected() {
        return this.connection != null;
    }

    public boolean openConnection() {
        try {
            this.connection = DriverManager.getConnection(this.connectionURL, this.user, this.password);
        }
        catch (Exception ex) {
            this.plugin.getLogger().log(Level.SEVERE, "Failed to connect to the MySQL server: " + ex.getMessage());
        }
        return this.connection != null;
    }

    public void closeConnection() {
        if (this.connection != null) {
            try {
                this.connection.close();
                this.connection = null;
            }
            catch (Exception ex) {
                this.plugin.getLogger().severe("Could not close the MySQL connection: " + ex.getMessage());
                ex.printStackTrace();
            }
        }
    }

    public PreparedStatement getStatement(String sql) {
        try {
            return this.isConnected() ? this.connection.prepareStatement(sql) : null;
        }
        catch (Exception ex) {
            this.plugin.getLogger().severe("Failed to prepare an SQL statement");
            return null;
        }
    }

    public Statement getStatement() {
        try {
            return this.connection.createStatement();
        }
        catch (Exception ex) {
            return null;
        }
    }

    public boolean tableExists(String name) {
        return this.tableExists(this.plugin, name);
    }

    public boolean tableExists(Plugin plugin, String name) {
        name = plugin.getName() + "_" + (String)name;
        if (this.tables.containsKey(name)) {
            return true;
        }
        try {
            DatabaseMetaData meta = this.connection.getMetaData();
            ResultSet result = meta.getTables(null, null, (String)name, null);
            boolean exists = result.next();
            result.close();
            return exists;
        }
        catch (Exception ex) {
            plugin.getLogger().severe("Unable to validate table: " + ex.getMessage());
            return false;
        }
    }

    public SQLTable createTable(String name) {
        return this.createTable(this.plugin, name);
    }

    public SQLTable createTable(Plugin plugin, String name) {
        String full = plugin.getName() + "_" + name;
        if (!this.isConnected()) {
            plugin.getLogger().severe("A plugin tried to create a table while not connected to the SQL database");
            return null;
        }
        if (this.tables.containsKey(full)) {
            return this.tables.get(full);
        }
        if (this.tableExists(plugin, name)) {
            SQLTable table = new SQLTable(this, full);
            this.tables.put(full, table);
            return table;
        }
        try {
            this.getStatement().execute("CREATE TABLE " + full + " (Name " + ColumnType.STRING_64.toString() + ")");
            SQLTable table = new SQLTable(this, full);
            this.tables.put(full, table);
            plugin.getLogger().info("Created a new MySQL table with the name: " + full);
            return table;
        }
        catch (Exception ex) {
            plugin.getLogger().severe("Failed to create table \"" + name + "\" - " + ex.getMessage());
            return null;
        }
    }

    public boolean deleteTable(String name) {
        return this.deleteTable(this.plugin, name);
    }

    public boolean deleteTable(Plugin plugin, String name) {
        if (this.isConnected() && this.tableExists(plugin, name)) {
            try {
                String full = plugin.getName() + "_" + name;
                this.getStatement().execute("DROP TABLE " + full);
                this.tables.remove(full);
                return true;
            }
            catch (Exception ex) {
                plugin.getLogger().severe("Failed to delete table \"" + name + "\" - " + ex.getMessage());
            }
        }
        return false;
    }
}

