/*
 * Decompiled with CFR 0.152.
 */
package studio.magemonkey.codex.mccore.util;

import java.util.Hashtable;
import org.bukkit.entity.Ageable;
import org.bukkit.entity.EntityType;
import org.bukkit.entity.Horse;
import org.bukkit.entity.LivingEntity;
import org.bukkit.entity.Sheep;
import org.bukkit.entity.Skeleton;
import org.bukkit.entity.Slime;
import org.bukkit.entity.Tameable;
import org.bukkit.entity.Villager;
import org.bukkit.entity.Zombie;
import studio.magemonkey.codex.mccore.util.TextFormatter;
import studio.magemonkey.codex.util.Reflex;

public class MobManager {
    private static final Hashtable<String, String> table = new Hashtable<String, String>(){
        {
            this.put("mushroom_cow", "Mooshroom");
            this.put("pig_zombie", "Zombie Pigman");
            this.put("snowman", "Snow Golem");
        }
    };

    public static String getName(LivingEntity entity) {
        Object name = entity.getType().getName();
        if (table.contains(((String)name).toLowerCase())) {
            return table.get(((String)name).toLowerCase());
        }
        if (entity.getType() == EntityType.SKELETON && ((Skeleton)entity).getSkeletonType() == Skeleton.SkeletonType.WITHER) {
            name = "wither_" + (String)name;
        }
        return TextFormatter.format((String)name);
    }

    public static String getDetailedName(LivingEntity entity) {
        Object basic = MobManager.getName(entity);
        String type = entity.getType().name();
        if (type.equals("SLIME")) {
            switch (((Slime)entity).getSize()) {
                case 4: {
                    basic = "Big " + (String)basic;
                    break;
                }
                case 2: {
                    basic = "Small " + (String)basic;
                    break;
                }
                case 1: {
                    basic = "Tiny " + (String)basic;
                }
            }
        } else if (type.equals("HORSE")) {
            String variant = ((Horse)entity).getVariant().name();
            basic = TextFormatter.format(variant) + " " + (String)basic;
        } else if (type.equals("SHEEP")) {
            String color = ((Sheep)entity).getColor().name().toLowerCase();
            basic = TextFormatter.format(color) + " " + (String)basic;
        } else if (type.equals("VILLAGER")) {
            String profession = ((Villager)entity).getProfession().name();
            basic = TextFormatter.format(profession) + " " + (String)basic;
        } else if (type.equals("ZOMBIE")) {
            Object extra = ((Zombie)entity).isBaby() ? "Baby " : "";
            extra = (String)extra + (((Zombie)entity).isVillager() ? "Villager " : "");
            basic = (String)extra + (String)basic;
        } else if (type.equals("GUARDIAN")) {
            try {
                if (((Boolean)Reflex.getMethod(entity, "isElder", new Class[0]).invoke((Object)entity, new Object[0])).booleanValue()) {
                    basic = "Elder " + (String)basic;
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        if (entity instanceof Ageable) {
            Object object = basic = ((Ageable)entity).isAdult() ? basic : "Baby " + (String)basic;
        }
        if (entity instanceof Tameable) {
            basic = ((Tameable)entity).isTamed() ? "Tamed " + (String)basic : "Wild " + (String)basic;
        }
        return basic;
    }
}

