/*
 * Decompiled with CFR 0.152.
 */
package studio.magemonkey.codex.util.actions.conditions.list;

import java.util.List;
import java.util.Set;
import java.util.function.Predicate;
import org.bukkit.World;
import org.bukkit.entity.Entity;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import studio.magemonkey.codex.CodexPlugin;
import studio.magemonkey.codex.util.actions.conditions.IConditionValidator;
import studio.magemonkey.codex.util.actions.params.IParamResult;
import studio.magemonkey.codex.util.actions.params.IParamValue;

public class Condition_WorldTime
extends IConditionValidator {
    public Condition_WorldTime(@NotNull CodexPlugin<?> plugin) {
        super(plugin, "WORLD_TIME");
    }

    @Override
    @NotNull
    public List<String> getDescription() {
        return this.plugin.lang().Codex_Editor_Actions_Condition_WorldTime_Desc.asList();
    }

    @Override
    public void registerParams() {
        this.registerParam("TARGET");
        this.registerParam("NAME");
        this.registerParam("AMOUNT");
    }

    @Override
    @Nullable
    protected Predicate<Entity> validate(@NotNull Entity exe, @NotNull Set<Entity> targets, @NotNull IParamResult result) {
        String worldName = result.getParamValue("NAME").getString(null);
        World world = worldName != null ? this.plugin.getServer().getWorld(worldName) : null;
        long timeReq = result.getParamValue("AMOUNT").getInt(-1);
        IParamValue.IOperator oper = result.getParamValue("AMOUNT").getOperator();
        return target -> {
            long timeWorld = world == null ? target.getWorld().getTime() : world.getTime();
            return oper.check(timeWorld, timeReq);
        };
    }

    @Override
    public boolean mustHaveTarget() {
        return false;
    }
}

