/*
 * Decompiled with CFR 0.152.
 */
package studio.magemonkey.codex.util.actions.params;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.jetbrains.annotations.NotNull;

public class IParamValue {
    private int integer = -1;
    private double duble = -1.0;
    private double[] arrDouble = null;
    private boolean bool = false;
    private String str;
    private List<String> list;
    private IOperator operator;
    private String raw;

    public IParamValue() {
    }

    public IParamValue(int i) {
        this.integer = i;
        this.setRaw(String.valueOf(i));
    }

    public IParamValue(double d) {
        this.duble = d;
        this.setRaw(String.valueOf(d));
    }

    public IParamValue(double[] arr) {
        this.arrDouble = arr;
        StringBuilder b = new StringBuilder();
        for (double d : arr) {
            if (b.length() > 0) {
                b.append(",");
            }
            b.append(String.valueOf(d));
        }
        this.setRaw(b.toString());
    }

    public IParamValue(boolean b) {
        this.bool = b;
        this.setRaw(String.valueOf(b));
    }

    public IParamValue(@NotNull String str) {
        this.str = str;
        this.setRaw(str);
    }

    public IParamValue(@NotNull List<String> list) {
        this.list = list;
        StringBuilder b = new StringBuilder();
        for (String s : list) {
            if (b.length() > 0) {
                b.append(",");
            }
            b.append(s);
        }
        this.setRaw(b.toString());
    }

    public IParamValue(@NotNull String[] str) {
        this(Arrays.asList(str));
    }

    @NotNull
    public String getRaw() {
        return this.raw;
    }

    public void setRaw(@NotNull String raw) {
        this.raw = raw;
    }

    public int getInt(int def) {
        if (!this.hasInt()) {
            return def;
        }
        return this.integer;
    }

    public boolean hasInt() {
        return this.integer != -1;
    }

    public void setInt(int integer) {
        this.integer = integer;
    }

    public double getDouble(double def) {
        if (!this.hasDouble()) {
            return def;
        }
        return this.duble;
    }

    public boolean hasDouble() {
        return this.duble != -1.0;
    }

    public void setDouble(double d) {
        this.duble = d;
    }

    public double[] getDoubleArray() {
        if (!this.hasDoubleArray()) {
            return new double[]{0.0, 0.0, 0.0};
        }
        return this.arrDouble;
    }

    public boolean hasDoubleArray() {
        return this.arrDouble != null;
    }

    public void setDoubleArray(double[] arr) {
        this.arrDouble = arr;
    }

    public boolean getBoolean() {
        return this.bool;
    }

    public void setBoolean(boolean b) {
        this.bool = b;
    }

    public boolean hasOperator() {
        return this.operator != null;
    }

    public IOperator getOperator() {
        return this.operator;
    }

    public void setOperator(IOperator io) {
        this.operator = io;
        if (this.raw != null) {
            this.raw = this.operator.val + this.raw;
        }
    }

    public String getString(String def) {
        if (!this.hasString()) {
            return def;
        }
        return this.str;
    }

    public boolean hasString() {
        return this.str != null;
    }

    public void setString(String str) {
        this.str = str;
    }

    public List<String> getStringList() {
        if (!this.hasStringList()) {
            return new ArrayList<String>();
        }
        return this.list;
    }

    public boolean hasStringList() {
        return this.list != null;
    }

    public static enum IOperator {
        GREATER(">"),
        LOWER("<"),
        EQUALS("=");

        public String val;

        private IOperator(String val) {
            this.val = val;
        }

        @NotNull
        public static String clean(@NotNull String str) {
            for (IOperator o : IOperator.values()) {
                str = str.replace(o.val, "");
            }
            return str;
        }

        @NotNull
        public static IOperator parse(@NotNull String str) {
            for (IOperator o : IOperator.values()) {
                if (!str.contains(o.val)) continue;
                return o;
            }
            return EQUALS;
        }

        public boolean check(double from, double to) {
            switch (this.ordinal()) {
                case 0: {
                    return from > to;
                }
                case 1: {
                    return from < to;
                }
                case 2: {
                    return from == to;
                }
            }
            return true;
        }
    }
}

