/*
 * Decompiled with CFR 0.152.
 */
package studio.magemonkey.codex.util.messages;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import net.md_5.bungee.api.chat.BaseComponent;
import net.md_5.bungee.api.chat.TextComponent;
import org.bukkit.ChatColor;
import studio.magemonkey.codex.legacy.placeholder.PlaceholderItem;
import studio.magemonkey.codex.legacy.placeholder.PlaceholderType;
import studio.magemonkey.codex.legacy.riseitem.DarkRiseItem;
import studio.magemonkey.codex.legacy.utils.ComponentUtils;
import studio.magemonkey.codex.legacy.utils.Utils;
import studio.magemonkey.codex.util.messages.AbstractMessageUtil;
import studio.magemonkey.codex.util.messages.MessageData;

public class MessageUtil
extends AbstractMessageUtil {
    @Override
    public BaseComponent[] getMessageAsComponent(String path, MessageData ... replace) {
        ArrayList<Object> components = new ArrayList<Object>();
        List<String> msgs = this.getString(path);
        HashMap placeholders = new HashMap();
        Map data = Arrays.stream(replace).collect(Collectors.toMap(MessageData::getName, messageData -> messageData, (a, b) -> b, HashMap::new));
        Pattern pat = Pattern.compile("\\$<(.*?)>");
        msgs.stream().map(pat::matcher).forEach(mat -> {
            while (mat.find()) {
                PlaceholderItem it = PlaceholderType.getQualifiedItem(mat.group(1));
                if (it == null) continue;
                String id = "$<" + mat.group(1) + ">";
                placeholders.put(id, it);
            }
        });
        for (String send : msgs) {
            BaseComponent[] comps;
            if (send.equalsIgnoreCase("false")) continue;
            for (BaseComponent component : comps = ComponentUtils.fromLegacyText(send)) {
                for (Map.Entry entry : placeholders.entrySet()) {
                    PlaceholderItem holder = (PlaceholderItem)entry.getValue();
                    String id = (String)entry.getKey();
                    if (!component.toPlainText().contains(id)) continue;
                    Object translated = holder.apply(((MessageData)data.get(holder.getType().getId())).getObject(), null);
                    if (translated instanceof BaseComponent) {
                        ComponentUtils.replace(component, id, (BaseComponent)translated);
                        continue;
                    }
                    ComponentUtils.replace(component, id, translated.toString());
                }
                for (MessageData datum : replace) {
                    String check = "$<" + datum.getName() + ">";
                    if (!component.toPlainText().contains(check)) continue;
                    if (datum.getObject() instanceof BaseComponent) {
                        ComponentUtils.replace(component, check, (BaseComponent)datum.getObject());
                        continue;
                    }
                    ComponentUtils.replace(component, check, datum.getObject().toString());
                }
                components.add(component);
            }
            if (msgs.size() <= 1) continue;
            components.add(new TextComponent("\n"));
        }
        return components.toArray(new BaseComponent[0]);
    }

    @Override
    public String getMessageAsString(String path, String def, boolean stripColor, MessageData ... data) {
        if (!this.messages.containsKey(path)) {
            path = def;
        }
        BaseComponent[] strs = this.getMessageAsComponent(path, data);
        StringBuilder bob = new StringBuilder();
        for (BaseComponent str : strs) {
            bob.append(str.toLegacyText());
        }
        return stripColor ? ChatColor.stripColor((String)bob.toString()) : bob.toString();
    }

    private List<String> getString(String key) {
        ArrayList<String> ret = new ArrayList<String>();
        if (!this.messages.containsKey(key)) {
            ret.add(key);
            return ret;
        }
        Object msg = this.messages.get(key);
        if (msg == null) {
            ret.add(key);
        } else {
            try {
                ret.addAll((List)msg);
            }
            catch (ClassCastException e) {
                ret.add(msg.toString());
            }
        }
        return Utils.fixColors(ret);
    }

    public static String getReplacement(String string) {
        string = "$<" + (String)string + ">";
        return string;
    }

    private static MessageData[] translateSpecial(MessageData ... data) {
        ArrayList<MessageData> rep = new ArrayList<MessageData>();
        for (MessageData md : data) {
            if (md.getName().equalsIgnoreCase("item")) {
                DarkRiseItem it = (DarkRiseItem)md.getObject();
                rep.add(new MessageData("riseItem.name", it.getName()));
                rep.add(new MessageData("riseItem.id", it.getId()));
                continue;
            }
            rep.add(md);
        }
        return rep.toArray(new MessageData[0]);
    }
}

