/*
 * Decompiled with CFR 0.152.
 */
package systems.uom.unicode;

import javax.measure.Quantity;
import javax.measure.Unit;
import javax.measure.UnitConverter;
import javax.measure.quantity.Acceleration;
import javax.measure.quantity.AmountOfSubstance;
import javax.measure.quantity.Angle;
import javax.measure.quantity.Area;
import javax.measure.quantity.Dimensionless;
import javax.measure.quantity.ElectricCapacitance;
import javax.measure.quantity.ElectricConductance;
import javax.measure.quantity.ElectricCurrent;
import javax.measure.quantity.ElectricInductance;
import javax.measure.quantity.ElectricPotential;
import javax.measure.quantity.ElectricResistance;
import javax.measure.quantity.Energy;
import javax.measure.quantity.Force;
import javax.measure.quantity.Frequency;
import javax.measure.quantity.Illuminance;
import javax.measure.quantity.Length;
import javax.measure.quantity.LuminousFlux;
import javax.measure.quantity.LuminousIntensity;
import javax.measure.quantity.MagneticFlux;
import javax.measure.quantity.MagneticFluxDensity;
import javax.measure.quantity.Mass;
import javax.measure.quantity.Power;
import javax.measure.quantity.Pressure;
import javax.measure.quantity.RadiationDoseAbsorbed;
import javax.measure.quantity.RadiationDoseEffective;
import javax.measure.quantity.SolidAngle;
import javax.measure.quantity.Speed;
import javax.measure.quantity.Temperature;
import javax.measure.quantity.Time;
import javax.measure.quantity.Volume;
import systems.uom.quantity.Information;
import systems.uom.quantity.InformationRate;
import tec.uom.se.AbstractConverter;
import tec.uom.se.AbstractSystemOfUnits;
import tec.uom.se.AbstractUnit;
import tec.uom.se.format.SimpleUnitFormat;
import tec.uom.se.function.PiMultiplierConverter;
import tec.uom.se.function.RationalConverter;
import tec.uom.se.unit.AlternateUnit;
import tec.uom.se.unit.MetricPrefix;
import tec.uom.se.unit.ProductUnit;
import tec.uom.se.unit.TransformedUnit;
import tec.uom.se.unit.Units;

public final class CLDR
extends AbstractSystemOfUnits {
    private static final CLDR INSTANCE = new CLDR();
    public static final Unit<Length> METER = Units.METRE;
    public static final Unit<Length> FOOT = CLDR.addUnit(METER.multiply(3048.0).divide(10000.0));
    public static final Unit<Length> FOOT_SURVEY = CLDR.addUnit(METER.multiply(1200.0).divide(3937.0));
    public static final Unit<Length> YARD = CLDR.addUnit(FOOT.multiply(3.0));
    public static final Unit<Length> INCH = CLDR.addUnit(FOOT.divide(12.0));
    public static final Unit<Length> MILE = CLDR.addUnit(METER.multiply(1609344.0).divide(1000.0));
    public static final Unit<Length> ASTRONOMICAL_UNIT = CLDR.addUnit(Units.METRE.multiply(1.49597870691E11));
    public static final Unit<Time> SECOND = CLDR.addUnit(Units.SECOND);
    public static final Unit<Angle> RADIAN = CLDR.addUnit(Units.RADIAN);
    public static final Unit<Temperature> KELVIN = CLDR.addUnit(Units.KELVIN);
    public static final Unit<LuminousIntensity> CANDELA = CLDR.addUnit(Units.CANDELA);
    public static final Unit<Dimensionless> PI = CLDR.addUnit(AbstractUnit.ONE.transform((UnitConverter)new PiMultiplierConverter()));
    public static final Unit<Dimensionless> PERCENT = CLDR.addUnit(AbstractUnit.ONE.divide(100.0));
    public static final Unit<AmountOfSubstance> MOLE = CLDR.addUnit(Units.MOLE);
    public static final Unit<SolidAngle> STERADIAN = CLDR.addUnit(Units.STERADIAN);
    public static final Unit<Frequency> HERTZ = CLDR.addUnit(Units.HERTZ);
    public static final Unit<Force> NEWTON = CLDR.addUnit(Units.NEWTON);
    public static final Unit<Pressure> PASCAL = CLDR.addUnit(Units.PASCAL);
    public static final Unit<Energy> JOULE = CLDR.addUnit(Units.JOULE);
    public static final Unit<Power> WATT = CLDR.addUnit(Units.WATT);
    public static final Unit<ElectricCurrent> AMPERE = CLDR.addUnit(Units.AMPERE);
    public static final Unit<ElectricPotential> VOLT = CLDR.addUnit(Units.VOLT);
    public static final Unit<ElectricCapacitance> FARAD = CLDR.addUnit(Units.FARAD);
    public static final Unit<ElectricResistance> OHM = CLDR.addUnit(Units.OHM);
    public static final Unit<ElectricConductance> SIEMENS = CLDR.addUnit(Units.SIEMENS);
    public static final Unit<MagneticFlux> WEBER = CLDR.addUnit(Units.WEBER);
    public static final Unit<Temperature> CELSIUS = CLDR.addUnit(Units.CELSIUS);
    public static final Unit<MagneticFluxDensity> TESLA = CLDR.addUnit(Units.TESLA);
    public static final Unit<ElectricInductance> HENRY = CLDR.addUnit(Units.HENRY);
    public static final Unit<LuminousFlux> LUMEN = CLDR.addUnit(Units.LUMEN);
    public static final Unit<Illuminance> LUX = CLDR.addUnit(Units.LUX);
    public static final Unit<RadiationDoseAbsorbed> GRAY = CLDR.addUnit(Units.GRAY);
    public static final Unit<RadiationDoseEffective> SIEVERT = CLDR.addUnit(Units.SIEVERT);
    static final Unit<Angle> DEGREE_ANGLE = new TransformedUnit(RADIAN, (UnitConverter)new PiMultiplierConverter().concatenate((AbstractConverter)new RationalConverter(1L, 180L)));
    static final Unit<Angle> MINUTE_ANGLE = new TransformedUnit(RADIAN, (UnitConverter)new PiMultiplierConverter().concatenate((AbstractConverter)new RationalConverter(1L, 10800L)));
    static final Unit<Angle> SECOND_ANGLE = new TransformedUnit(RADIAN, (UnitConverter)new PiMultiplierConverter().concatenate((AbstractConverter)new RationalConverter(1L, 648000L)));
    public static final Unit<Angle> DEGREE = CLDR.addUnit(DEGREE_ANGLE);
    public static final Unit<Angle> ARC_MINUTE = CLDR.addUnit(MINUTE_ANGLE);
    public static final Unit<Angle> ARC_SECOND = CLDR.addUnit(SECOND_ANGLE);
    public static final Unit<Area> SQUARE_FOOT = CLDR.addUnit(new ProductUnit((Unit)((AbstractUnit)FOOT.multiply(FOOT))));
    private static final Unit<Area> ARE = CLDR.addUnit(Units.SQUARE_METRE.multiply(100.0));
    public static final Unit<Area> HECTARE = CLDR.addUnit(ARE.multiply(100.0));
    public static final Unit<Area> ACRE = CLDR.addUnit(SQUARE_FOOT.multiply(43560.0));
    public static final Unit<Volume> LITER = new TransformedUnit((Unit)Units.CUBIC_METRE, (UnitConverter)new RationalConverter(1L, 1000L));
    public static final Unit<Volume> CUBIC_INCH = CLDR.addUnit(INCH.pow(3).asType(Volume.class));
    public static final Unit<Volume> CUBIC_FOOT = CLDR.addUnit(CUBIC_INCH.multiply(1728.0).asType(Volume.class));
    public static final Unit<Volume> ACRE_FOOT = CLDR.addUnit(CUBIC_FOOT.multiply(43560.0));
    public static final Unit<Volume> BUSHEL = CLDR.addUnit(CUBIC_INCH.multiply(215042.0).divide(100.0));
    public static final Unit<Time> MINUTE = CLDR.addUnit(Units.MINUTE);
    public static final Unit<Time> HOUR = CLDR.addUnit(Units.HOUR);
    public static final Unit<Time> DAY = CLDR.addUnit(Units.DAY);
    static final Unit<Time> YEAR_JULIAN = CLDR.addUnit(Units.DAY.multiply(365.25));
    public static final Unit<Time> YEAR = CLDR.addUnit(Units.DAY.multiply(365.25));
    public static final Unit<Time> MONTH = CLDR.addUnit(YEAR_JULIAN.divide(12.0));
    public static final Unit<Time> CENTURY = CLDR.addUnit(YEAR.multiply(100.0));
    private static final Unit<Pressure> BAR = CLDR.addUnit(Units.PASCAL.multiply(100000.0));
    public static final Unit<Mass> GRAM = CLDR.addUnit(Units.GRAM);
    public static final Unit<Mass> TONNE = CLDR.addUnit(Units.KILOGRAM.multiply(1000.0));
    static final Unit<Speed> C = CLDR.addUnit(Units.METRES_PER_SECOND.multiply(2.99792458E8));
    private static final Unit<Acceleration> ACCELLERATION_OF_FREEFALL = CLDR.addUnit(Units.METRES_PER_SQUARE_SECOND.multiply(9.80665));
    public static final Unit<Length> LIGHT_YEAR = CLDR.addUnit(new ProductUnit(C.multiply(YEAR_JULIAN)));
    static final Unit<Length> INCH_INTERNATIONAL = CLDR.addUnit(MetricPrefix.CENTI((Unit)Units.METRE).multiply(254.0).divide(100.0));
    static final Unit<Length> FOOT_INTERNATIONAL = CLDR.addUnit(INCH_INTERNATIONAL.multiply(12.0));
    public static final Unit<Length> NAUTICAL_MILE = CLDR.addUnit(Units.METRE.multiply(1852.0));
    public static final Unit<Speed> KNOT = CLDR.addUnit(new ProductUnit(NAUTICAL_MILE.divide(HOUR)));
    private static final Unit<Mass> GRAIN = CLDR.addUnit(MetricPrefix.MILLI(GRAM).multiply(6479891.0).divide(100000.0));
    static final Unit<Mass> POUND = CLDR.addUnit(GRAIN.multiply(7000.0));
    public static final Unit<Mass> CARAT = CLDR.addUnit(GRAM.divide(5.0));
    private static final Unit<Dimensionless> CARAT_GOLD = CLDR.addUnit(AbstractUnit.ONE.divide(24.0));
    private static final Unit<Force> POUND_FORCE = CLDR.addUnit(POUND.multiply(ACCELLERATION_OF_FREEFALL).asType(Force.class));
    private static final Unit<Length> PARSEC = CLDR.addUnit(Units.METRE.multiply(3.085677E16));
    static final Unit<Length> PIXEL = CLDR.addUnit(INCH.divide(72.0));
    static final Unit<Length> COMPUTER_POINT = PIXEL;
    static final Unit<Length> LINE = CLDR.addUnit(INCH_INTERNATIONAL.divide(12.0));
    public static final Unit<Length> POINT = CLDR.addUnit(LINE.divide(6.0));
    public static final Unit<Length> PICA = CLDR.addUnit(POINT.multiply(12.0));
    public static final Unit<Length> POINT_PRINTER = CLDR.addUnit(INCH_INTERNATIONAL.multiply(13837.0).divide(1000000.0));
    public static final Unit<Length> PICA_PRINTER = CLDR.addUnit(POINT_PRINTER.multiply(12.0));
    public static final Unit<Temperature> FAHRENHEIT = CLDR.addUnit(KELVIN.multiply(5.0).divide(9.0).shift(459.67));
    private static final Unit<Energy> CALORIE_THERMOCHEMICAL = CLDR.addUnit(JOULE.multiply(4184.0).divide(1000.0));
    public static final Unit<Energy> CALORIE = CLDR.addUnit(CALORIE_THERMOCHEMICAL);
    private static final Unit<Energy> CALORIE_FOOD = CLDR.addUnit(MetricPrefix.KILO(CALORIE_THERMOCHEMICAL));
    public static final Unit<Power> HORSEPOWER = CLDR.addUnit(new ProductUnit(FOOT_INTERNATIONAL.multiply(POUND_FORCE).divide(SECOND)));
    public static final Unit<Pressure> POUND_PER_SQUARE_INCH = CLDR.addUnit(new ProductUnit(POUND_FORCE.divide(INCH_INTERNATIONAL.pow(2))));
    public static final Unit<Angle> CIRCLE = CLDR.addUnit(new ProductUnit(PI.multiply(RADIAN.multiply(2.0))));
    public static final Unit<SolidAngle> SPHERE = CLDR.addUnit(new ProductUnit(PI.multiply(STERADIAN.multiply(4.0))));
    public static final Unit<Information> BIT = CLDR.addUnit(new AlternateUnit(AbstractUnit.ONE, "bit"), Information.class);
    public static final Unit<Information> BYTE = CLDR.addUnit(BIT.multiply(8.0));
    static final ProductUnit<InformationRate> BITS_PER_SECOND = CLDR.addUnit(new ProductUnit(BIT.divide(SECOND)), InformationRate.class);
    static final Unit<Information> OCTET = BYTE;

    private CLDR() {
    }

    public static CLDR getInstance() {
        return INSTANCE;
    }

    public String getName() {
        return "CLDR";
    }

    private static <U extends Unit<?>> U addUnit(U unit) {
        CLDR.INSTANCE.units.add(unit);
        return unit;
    }

    private static <U extends AbstractUnit<?>> U addUnit(U unit, Class<? extends Quantity<?>> type) {
        CLDR.INSTANCE.units.add(unit);
        CLDR.INSTANCE.quantityToUnit.put(type, unit);
        return unit;
    }

    static {
        SimpleUnitFormat.getInstance().label(BYTE, "B");
        SimpleUnitFormat.getInstance().label(CARAT_GOLD, "kt");
        SimpleUnitFormat.getInstance().label(CARAT, "ct");
        SimpleUnitFormat.getInstance().label(POUND, "lb");
        SimpleUnitFormat.getInstance().label(BAR, "b");
    }
}

