/*
 * Decompiled with CFR 0.152.
 */
package tech.bitey.bufferstuff;

import java.nio.DoubleBuffer;
import java.nio.FloatBuffer;
import java.nio.IntBuffer;
import java.nio.LongBuffer;
import tech.bitey.bufferstuff.BufferUtils;

public enum BufferSearch {


    public static int binarySearch(IntBuffer b, int fromIndex, int toIndex, int key) {
        BufferUtils.rangeCheck(b.capacity(), fromIndex, toIndex);
        return BufferSearch.binarySearch0(b, fromIndex, toIndex, key);
    }

    private static int binarySearch0(IntBuffer b, int fromIndex, int toIndex, int key) {
        int low = fromIndex;
        int high = toIndex - 1;
        while (low <= high) {
            int mid = low + high >>> 1;
            int midVal = b.get(mid);
            if (midVal < key) {
                low = mid + 1;
                continue;
            }
            if (midVal > key) {
                high = mid - 1;
                continue;
            }
            return mid;
        }
        return -(low + 1);
    }

    public static int binarySearch(LongBuffer b, int fromIndex, int toIndex, long key) {
        BufferUtils.rangeCheck(b.capacity(), fromIndex, toIndex);
        return BufferSearch.binarySearch0(b, fromIndex, toIndex, key);
    }

    private static int binarySearch0(LongBuffer b, int fromIndex, int toIndex, long key) {
        int low = fromIndex;
        int high = toIndex - 1;
        while (low <= high) {
            int mid = low + high >>> 1;
            long midVal = b.get(mid);
            if (midVal < key) {
                low = mid + 1;
                continue;
            }
            if (midVal > key) {
                high = mid - 1;
                continue;
            }
            return mid;
        }
        return -(low + 1);
    }

    public static int binarySearch(FloatBuffer b, int fromIndex, int toIndex, float key) {
        BufferUtils.rangeCheck(b.capacity(), fromIndex, toIndex);
        return BufferSearch.binarySearch0(b, fromIndex, toIndex, key);
    }

    private static int binarySearch0(FloatBuffer b, int fromIndex, int toIndex, float key) {
        int low = fromIndex;
        int high = toIndex - 1;
        while (low <= high) {
            int keyBits;
            int mid = low + high >>> 1;
            float midVal = b.get(mid);
            if (midVal < key) {
                low = mid + 1;
                continue;
            }
            if (midVal > key) {
                high = mid - 1;
                continue;
            }
            int midBits = Float.floatToIntBits(midVal);
            if (midBits == (keyBits = Float.floatToIntBits(key))) {
                return mid;
            }
            if (midBits < keyBits) {
                low = mid + 1;
                continue;
            }
            high = mid - 1;
        }
        return -(low + 1);
    }

    public static int binarySearch(DoubleBuffer b, int fromIndex, int toIndex, double key) {
        BufferUtils.rangeCheck(b.capacity(), fromIndex, toIndex);
        return BufferSearch.binarySearch0(b, fromIndex, toIndex, key);
    }

    private static int binarySearch0(DoubleBuffer b, int fromIndex, int toIndex, double key) {
        int low = fromIndex;
        int high = toIndex - 1;
        while (low <= high) {
            long keyBits;
            int mid = low + high >>> 1;
            double midVal = b.get(mid);
            if (midVal < key) {
                low = mid + 1;
                continue;
            }
            if (midVal > key) {
                high = mid - 1;
                continue;
            }
            long midBits = Double.doubleToLongBits(midVal);
            if (midBits == (keyBits = Double.doubleToLongBits(key))) {
                return mid;
            }
            if (midBits < keyBits) {
                low = mid + 1;
                continue;
            }
            high = mid - 1;
        }
        return -(low + 1);
    }
}

