/*
 * Decompiled with CFR 0.152.
 */
package tech.bitey.bufferstuff;

import java.nio.ByteBuffer;
import java.nio.DoubleBuffer;
import java.nio.FloatBuffer;
import java.nio.IntBuffer;
import java.nio.LongBuffer;

public enum BufferUtils {


    public static ByteBuffer duplicate(ByteBuffer b) {
        return b.duplicate().order(b.order());
    }

    public static ByteBuffer slice(ByteBuffer b) {
        return b.slice().order(b.order());
    }

    public static ByteBuffer slice(ByteBuffer b, int fromIndex, int toIndex) {
        BufferUtils.rangeCheck(b.capacity(), fromIndex, toIndex);
        ByteBuffer dup = BufferUtils.duplicate(b);
        dup.limit(toIndex);
        dup.position(fromIndex);
        return BufferUtils.slice(dup);
    }

    public static boolean isSorted(IntBuffer b, int fromIndex, int toIndex) {
        BufferUtils.rangeCheck(b.capacity(), fromIndex, toIndex);
        if (toIndex - fromIndex <= 1) {
            return true;
        }
        int prev = b.get(fromIndex);
        for (int i = fromIndex + 1; i < toIndex; ++i) {
            int value = b.get(i);
            if (prev > value) {
                return false;
            }
            prev = value;
        }
        return true;
    }

    public static boolean isSortedAndDistinct(IntBuffer b, int fromIndex, int toIndex) {
        BufferUtils.rangeCheck(b.capacity(), fromIndex, toIndex);
        if (toIndex - fromIndex <= 1) {
            return true;
        }
        int prev = b.get(fromIndex);
        for (int i = fromIndex + 1; i < toIndex; ++i) {
            int value = b.get(i);
            if (prev >= value) {
                return false;
            }
            prev = value;
        }
        return true;
    }

    public static boolean isSorted(LongBuffer b, int fromIndex, int toIndex) {
        BufferUtils.rangeCheck(b.capacity(), fromIndex, toIndex);
        if (toIndex - fromIndex <= 1) {
            return true;
        }
        long prev = b.get(fromIndex);
        for (int i = fromIndex + 1; i < toIndex; ++i) {
            long value = b.get(i);
            if (prev > value) {
                return false;
            }
            prev = value;
        }
        return true;
    }

    public static boolean isSortedAndDistinct(LongBuffer b, int fromIndex, int toIndex) {
        BufferUtils.rangeCheck(b.capacity(), fromIndex, toIndex);
        if (toIndex - fromIndex <= 1) {
            return true;
        }
        long prev = b.get(fromIndex);
        for (int i = fromIndex + 1; i < toIndex; ++i) {
            long value = b.get(i);
            if (prev >= value) {
                return false;
            }
            prev = value;
        }
        return true;
    }

    public static boolean isSorted(FloatBuffer b, int fromIndex, int toIndex) {
        BufferUtils.rangeCheck(b.capacity(), fromIndex, toIndex);
        if (toIndex - fromIndex <= 1) {
            return true;
        }
        float prev = b.get(fromIndex);
        for (int i = fromIndex + 1; i < toIndex; ++i) {
            float value = b.get(i);
            if (Float.compare(prev, value) > 0) {
                return false;
            }
            prev = value;
        }
        return true;
    }

    public static boolean isSortedAndDistinct(FloatBuffer b, int fromIndex, int toIndex) {
        BufferUtils.rangeCheck(b.capacity(), fromIndex, toIndex);
        if (toIndex - fromIndex <= 1) {
            return true;
        }
        float prev = b.get(fromIndex);
        for (int i = fromIndex + 1; i < toIndex; ++i) {
            float value = b.get(i);
            if (Float.compare(prev, value) >= 0) {
                return false;
            }
            prev = value;
        }
        return true;
    }

    public static boolean isSorted(DoubleBuffer b, int fromIndex, int toIndex) {
        BufferUtils.rangeCheck(b.capacity(), fromIndex, toIndex);
        if (toIndex - fromIndex <= 1) {
            return true;
        }
        double prev = b.get(fromIndex);
        for (int i = fromIndex + 1; i < toIndex; ++i) {
            double value = b.get(i);
            if (Double.compare(prev, value) > 0) {
                return false;
            }
            prev = value;
        }
        return true;
    }

    public static boolean isSortedAndDistinct(DoubleBuffer b, int fromIndex, int toIndex) {
        BufferUtils.rangeCheck(b.capacity(), fromIndex, toIndex);
        if (toIndex - fromIndex <= 1) {
            return true;
        }
        double prev = b.get(fromIndex);
        for (int i = fromIndex + 1; i < toIndex; ++i) {
            double value = b.get(i);
            if (Double.compare(prev, value) >= 0) {
                return false;
            }
            prev = value;
        }
        return true;
    }

    public static ByteBuffer copy(ByteBuffer b, int fromIndex, int toIndex) {
        ByteBuffer slice = BufferUtils.slice(b, fromIndex, toIndex);
        ByteBuffer copy = b.isDirect() ? ByteBuffer.allocateDirect(slice.capacity()) : ByteBuffer.allocate(slice.capacity());
        copy.order(b.order());
        copy.put(slice);
        copy.flip();
        return copy;
    }

    public static IntBuffer copy(IntBuffer b, int fromIndex, int toIndex) {
        BufferUtils.rangeCheck(b.capacity(), fromIndex, toIndex);
        IntBuffer dup = b.duplicate();
        dup.limit(toIndex);
        dup.position(fromIndex);
        ByteBuffer copy = b.isDirect() ? ByteBuffer.allocateDirect(dup.remaining() * 4) : ByteBuffer.allocate(dup.remaining() * 4);
        copy.order(b.order());
        IntBuffer view = copy.asIntBuffer();
        view.put(dup);
        view.flip();
        return view;
    }

    public static LongBuffer copy(LongBuffer b, int fromIndex, int toIndex) {
        BufferUtils.rangeCheck(b.capacity(), fromIndex, toIndex);
        LongBuffer dup = b.duplicate();
        dup.limit(toIndex);
        dup.position(fromIndex);
        ByteBuffer copy = b.isDirect() ? ByteBuffer.allocateDirect(dup.remaining() * 8) : ByteBuffer.allocate(dup.remaining() * 8);
        copy.order(b.order());
        LongBuffer view = copy.asLongBuffer();
        view.put(dup);
        view.flip();
        return view;
    }

    public static FloatBuffer copy(FloatBuffer b, int fromIndex, int toIndex) {
        BufferUtils.rangeCheck(b.capacity(), fromIndex, toIndex);
        FloatBuffer dup = b.duplicate();
        dup.limit(toIndex);
        dup.position(fromIndex);
        ByteBuffer copy = b.isDirect() ? ByteBuffer.allocateDirect(dup.remaining() * 4) : ByteBuffer.allocate(dup.remaining() * 4);
        copy.order(b.order());
        FloatBuffer view = copy.asFloatBuffer();
        view.put(dup);
        view.flip();
        return view;
    }

    public static DoubleBuffer copy(DoubleBuffer b, int fromIndex, int toIndex) {
        BufferUtils.rangeCheck(b.capacity(), fromIndex, toIndex);
        DoubleBuffer dup = b.duplicate();
        dup.limit(toIndex);
        dup.position(fromIndex);
        ByteBuffer copy = b.isDirect() ? ByteBuffer.allocateDirect(dup.remaining() * 8) : ByteBuffer.allocate(dup.remaining() * 8);
        copy.order(b.order());
        DoubleBuffer view = copy.asDoubleBuffer();
        view.put(dup);
        view.flip();
        return view;
    }

    static void rangeCheck(int bufferCapacity, int fromIndex, int toIndex) {
        if (fromIndex > toIndex) {
            throw new IllegalArgumentException("fromIndex(" + fromIndex + ") > toIndex(" + toIndex + ")");
        }
        if (fromIndex < 0) {
            throw new IndexOutOfBoundsException("fromIndex(" + fromIndex + ") < 0");
        }
        if (toIndex > bufferCapacity) {
            throw new IndexOutOfBoundsException("toIndex(" + toIndex + ") > " + bufferCapacity);
        }
    }

    static void rangeCheckInclusive(int bufferCapacity, int fromIndex, int toIndex) {
        if (fromIndex > toIndex) {
            throw new IllegalArgumentException("fromIndex(" + fromIndex + ") > toIndex(" + toIndex + ")");
        }
        if (fromIndex < 0) {
            throw new IndexOutOfBoundsException("fromIndex(" + fromIndex + ") < 0");
        }
        if (toIndex >= bufferCapacity) {
            throw new IndexOutOfBoundsException("toIndex(" + toIndex + ") >= " + bufferCapacity);
        }
    }
}

