/*
 * Decompiled with CFR 0.152.
 */
package tech.bitey.bufferstuff;

import java.io.InputStream;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.DoubleBuffer;
import java.nio.FloatBuffer;
import java.nio.IntBuffer;
import java.nio.LongBuffer;
import java.nio.ShortBuffer;
import tech.bitey.bufferstuff.SmallByteBuffer;
import tech.bitey.bufferstuff.SmallDoubleBuffer;
import tech.bitey.bufferstuff.SmallFloatBuffer;
import tech.bitey.bufferstuff.SmallIntBuffer;
import tech.bitey.bufferstuff.SmallLongBuffer;
import tech.bitey.bufferstuff.SmallShortBuffer;

/*
 * Uses 'sealed' constructs - enablewith --sealed true
 */
public interface BigByteBuffer {
    public ByteBuffer[] buffers();

    public long position();

    public long limit();

    public long capacity();

    public BigByteBuffer position(long var1);

    public BigByteBuffer limit(long var1);

    public long remaining();

    public boolean hasRemaining();

    public ByteOrder order();

    public BigByteBuffer order(ByteOrder var1);

    public BigByteBuffer duplicate();

    public BigByteBuffer slice();

    public BigByteBuffer slice(long var1, long var3);

    public ByteBuffer smallSlice();

    public ByteBuffer smallSlice(long var1, long var3);

    public BigByteBuffer copy(long var1, long var3);

    public BigByteBuffer clear();

    public BigByteBuffer flip();

    public BigByteBuffer put(byte var1);

    public BigByteBuffer put(long var1, byte var3);

    public BigByteBuffer put(BigByteBuffer var1);

    public BigByteBuffer put(ByteBuffer var1);

    public BigByteBuffer put(byte[] var1);

    public byte get();

    public byte get(long var1);

    public BigByteBuffer get(byte[] var1, int var2, int var3);

    default public BigByteBuffer get(byte[] dst) {
        return this.get(dst, 0, dst.length);
    }

    default public SmallByteBuffer asByteBuffer() {
        return new SmallByteBuffer(this.duplicate());
    }

    public InputStream toInputStream();

    public BigByteBuffer putShort(short var1);

    public BigByteBuffer putShort(long var1, short var3);

    public BigByteBuffer putShort(short[] var1);

    public BigByteBuffer putShort(ShortBuffer var1);

    public short getShort();

    public short getShort(long var1);

    default public SmallShortBuffer asShortBuffer() {
        return new SmallShortBuffer(this.duplicate());
    }

    public BigByteBuffer putInt(int var1);

    public BigByteBuffer putInt(long var1, int var3);

    public BigByteBuffer putInt(int[] var1);

    public BigByteBuffer putInt(IntBuffer var1);

    public int getInt();

    public int getInt(long var1);

    default public SmallIntBuffer asIntBuffer() {
        return new SmallIntBuffer(this.duplicate());
    }

    public BigByteBuffer putLong(long var1);

    public BigByteBuffer putLong(long var1, long var3);

    public BigByteBuffer putLong(long[] var1);

    public BigByteBuffer putLong(LongBuffer var1);

    public long getLong();

    public long getLong(long var1);

    default public SmallLongBuffer asLongBuffer() {
        return new SmallLongBuffer(this.duplicate());
    }

    public BigByteBuffer putFloat(float var1);

    public BigByteBuffer putFloat(long var1, float var3);

    public BigByteBuffer putFloat(float[] var1);

    public BigByteBuffer putFloat(FloatBuffer var1);

    public float getFloat();

    public float getFloat(long var1);

    default public SmallFloatBuffer asFloatBuffer() {
        return new SmallFloatBuffer(this.duplicate());
    }

    public BigByteBuffer putDouble(double var1);

    public BigByteBuffer putDouble(long var1, double var3);

    public BigByteBuffer putDouble(double[] var1);

    public BigByteBuffer putDouble(DoubleBuffer var1);

    public double getDouble();

    public double getDouble(long var1);

    default public SmallDoubleBuffer asDoubleBuffer() {
        return new SmallDoubleBuffer(this.duplicate());
    }
}

