/*
 * Decompiled with CFR 0.152.
 */
package tech.bitey.bufferstuff;

import java.nio.ByteBuffer;
import java.nio.DoubleBuffer;
import java.nio.FloatBuffer;
import java.nio.IntBuffer;
import java.nio.LongBuffer;
import java.nio.ShortBuffer;
import tech.bitey.bufferstuff.BufferUtils;
import tech.bitey.bufferstuff.SmallByteBuffer;
import tech.bitey.bufferstuff.SmallDoubleBuffer;
import tech.bitey.bufferstuff.SmallFloatBuffer;
import tech.bitey.bufferstuff.SmallIntBuffer;
import tech.bitey.bufferstuff.SmallLongBuffer;
import tech.bitey.bufferstuff.SmallShortBuffer;

public final class BufferSearch
extends Enum<BufferSearch> {
    private static final /* synthetic */ BufferSearch[] $VALUES;

    public static BufferSearch[] values() {
        return (BufferSearch[])$VALUES.clone();
    }

    public static BufferSearch valueOf(String name) {
        return Enum.valueOf(BufferSearch.class, name);
    }

    public static int binarySearch(IntBuffer b, int fromIndex, int toIndex, int key) {
        BufferUtils.rangeCheck(b.capacity(), fromIndex, toIndex);
        return BufferSearch.binarySearch0(b, fromIndex, toIndex, key);
    }

    private static int binarySearch0(IntBuffer b, int fromIndex, int toIndex, int key) {
        int low = fromIndex;
        int high = toIndex - 1;
        while (low <= high) {
            int mid = low + high >>> 1;
            int midVal = b.get(mid);
            if (midVal < key) {
                low = mid + 1;
                continue;
            }
            if (midVal > key) {
                high = mid - 1;
                continue;
            }
            return mid;
        }
        return -(low + 1);
    }

    public static int binarySearch(LongBuffer b, int fromIndex, int toIndex, long key) {
        BufferUtils.rangeCheck(b.capacity(), fromIndex, toIndex);
        return BufferSearch.binarySearch0(b, fromIndex, toIndex, key);
    }

    private static int binarySearch0(LongBuffer b, int fromIndex, int toIndex, long key) {
        int low = fromIndex;
        int high = toIndex - 1;
        while (low <= high) {
            int mid = low + high >>> 1;
            long midVal = b.get(mid);
            if (midVal < key) {
                low = mid + 1;
                continue;
            }
            if (midVal > key) {
                high = mid - 1;
                continue;
            }
            return mid;
        }
        return -(low + 1);
    }

    public static int binarySearch(ShortBuffer b, int fromIndex, int toIndex, short key) {
        BufferUtils.rangeCheck(b.capacity(), fromIndex, toIndex);
        return BufferSearch.binarySearch0(b, fromIndex, toIndex, key);
    }

    private static int binarySearch0(ShortBuffer b, int fromIndex, int toIndex, short key) {
        int low = fromIndex;
        int high = toIndex - 1;
        while (low <= high) {
            int mid = low + high >>> 1;
            short midVal = b.get(mid);
            if (midVal < key) {
                low = mid + 1;
                continue;
            }
            if (midVal > key) {
                high = mid - 1;
                continue;
            }
            return mid;
        }
        return -(low + 1);
    }

    public static int binarySearch(ByteBuffer b, int fromIndex, int toIndex, byte key) {
        BufferUtils.rangeCheck(b.capacity(), fromIndex, toIndex);
        return BufferSearch.binarySearch0(b, fromIndex, toIndex, key);
    }

    private static int binarySearch0(ByteBuffer b, int fromIndex, int toIndex, byte key) {
        int low = fromIndex;
        int high = toIndex - 1;
        while (low <= high) {
            int mid = low + high >>> 1;
            byte midVal = b.get(mid);
            if (midVal < key) {
                low = mid + 1;
                continue;
            }
            if (midVal > key) {
                high = mid - 1;
                continue;
            }
            return mid;
        }
        return -(low + 1);
    }

    public static int binarySearch(FloatBuffer b, int fromIndex, int toIndex, float key) {
        BufferUtils.rangeCheck(b.capacity(), fromIndex, toIndex);
        return BufferSearch.binarySearch0(b, fromIndex, toIndex, key);
    }

    private static int binarySearch0(FloatBuffer b, int fromIndex, int toIndex, float key) {
        int low = fromIndex;
        int high = toIndex - 1;
        while (low <= high) {
            int keyBits;
            int mid = low + high >>> 1;
            float midVal = b.get(mid);
            if (midVal < key) {
                low = mid + 1;
                continue;
            }
            if (midVal > key) {
                high = mid - 1;
                continue;
            }
            int midBits = Float.floatToIntBits(midVal);
            if (midBits == (keyBits = Float.floatToIntBits(key))) {
                return mid;
            }
            if (midBits < keyBits) {
                low = mid + 1;
                continue;
            }
            high = mid - 1;
        }
        return -(low + 1);
    }

    public static int binarySearch(DoubleBuffer b, int fromIndex, int toIndex, double key) {
        BufferUtils.rangeCheck(b.capacity(), fromIndex, toIndex);
        return BufferSearch.binarySearch0(b, fromIndex, toIndex, key);
    }

    private static int binarySearch0(DoubleBuffer b, int fromIndex, int toIndex, double key) {
        int low = fromIndex;
        int high = toIndex - 1;
        while (low <= high) {
            long keyBits;
            int mid = low + high >>> 1;
            double midVal = b.get(mid);
            if (midVal < key) {
                low = mid + 1;
                continue;
            }
            if (midVal > key) {
                high = mid - 1;
                continue;
            }
            long midBits = Double.doubleToLongBits(midVal);
            if (midBits == (keyBits = Double.doubleToLongBits(key))) {
                return mid;
            }
            if (midBits < keyBits) {
                low = mid + 1;
                continue;
            }
            high = mid - 1;
        }
        return -(low + 1);
    }

    public static int binaryFindFirst(IntBuffer b, int minIndex, int keyIndex) {
        BufferUtils.rangeCheckInclusive(b.capacity(), minIndex, keyIndex);
        return BufferSearch.binaryFindFirst(b, minIndex, keyIndex, b.get(keyIndex));
    }

    private static int binaryFindFirst(IntBuffer b, int minIndex, int fromIndex, int key) {
        while (minIndex != fromIndex && b.get(fromIndex - 1) == key) {
            int rangeIndex;
            int range = 1;
            while (minIndex <= (rangeIndex = fromIndex - (range <<= 1)) && b.get(rangeIndex) == key) {
            }
            fromIndex -= range >> 1;
        }
        return fromIndex;
    }

    public static int binaryFindLast(IntBuffer b, int maxIndex, int keyIndex) {
        BufferUtils.rangeCheck(b.capacity(), keyIndex, maxIndex);
        if (keyIndex == maxIndex) {
            return keyIndex;
        }
        return BufferSearch.binaryFindLast(b, keyIndex, maxIndex - 1, b.get(keyIndex));
    }

    private static int binaryFindLast(IntBuffer b, int fromIndex, int maxIndex, int key) {
        while (fromIndex != maxIndex && b.get(fromIndex + 1) == key) {
            int rangeIndex;
            int range = 1;
            while ((rangeIndex = fromIndex + (range <<= 1)) <= maxIndex && b.get(rangeIndex) == key) {
            }
            fromIndex += range >> 1;
        }
        return fromIndex;
    }

    public static int binaryFindFirst(LongBuffer b, int minIndex, int keyIndex) {
        BufferUtils.rangeCheckInclusive(b.capacity(), minIndex, keyIndex);
        return BufferSearch.binaryFindFirst(b, minIndex, keyIndex, b.get(keyIndex));
    }

    private static int binaryFindFirst(LongBuffer b, int minIndex, int fromIndex, long key) {
        while (minIndex != fromIndex && b.get(fromIndex - 1) == key) {
            int rangeIndex;
            int range = 1;
            while (minIndex <= (rangeIndex = fromIndex - (range <<= 1)) && b.get(rangeIndex) == key) {
            }
            fromIndex -= range >> 1;
        }
        return fromIndex;
    }

    public static int binaryFindLast(LongBuffer b, int maxIndex, int keyIndex) {
        BufferUtils.rangeCheck(b.capacity(), keyIndex, maxIndex);
        if (keyIndex == maxIndex) {
            return keyIndex;
        }
        return BufferSearch.binaryFindLast(b, keyIndex, maxIndex - 1, b.get(keyIndex));
    }

    private static int binaryFindLast(LongBuffer b, int fromIndex, int maxIndex, long key) {
        while (fromIndex != maxIndex && b.get(fromIndex + 1) == key) {
            int rangeIndex;
            int range = 1;
            while ((rangeIndex = fromIndex + (range <<= 1)) <= maxIndex && b.get(rangeIndex) == key) {
            }
            fromIndex += range >> 1;
        }
        return fromIndex;
    }

    public static int binaryFindFirst(ShortBuffer b, int minIndex, int keyIndex) {
        BufferUtils.rangeCheckInclusive(b.capacity(), minIndex, keyIndex);
        return BufferSearch.binaryFindFirst(b, minIndex, keyIndex, b.get(keyIndex));
    }

    private static int binaryFindFirst(ShortBuffer b, int minIndex, int fromIndex, short key) {
        while (minIndex != fromIndex && b.get(fromIndex - 1) == key) {
            int rangeIndex;
            int range = 1;
            while (minIndex <= (rangeIndex = fromIndex - (range <<= 1)) && b.get(rangeIndex) == key) {
            }
            fromIndex -= range >> 1;
        }
        return fromIndex;
    }

    public static int binaryFindLast(ShortBuffer b, int maxIndex, int keyIndex) {
        BufferUtils.rangeCheck(b.capacity(), keyIndex, maxIndex);
        if (keyIndex == maxIndex) {
            return keyIndex;
        }
        return BufferSearch.binaryFindLast(b, keyIndex, maxIndex - 1, b.get(keyIndex));
    }

    private static int binaryFindLast(ShortBuffer b, int fromIndex, int maxIndex, short key) {
        while (fromIndex != maxIndex && b.get(fromIndex + 1) == key) {
            int rangeIndex;
            int range = 1;
            while ((rangeIndex = fromIndex + (range <<= 1)) <= maxIndex && b.get(rangeIndex) == key) {
            }
            fromIndex += range >> 1;
        }
        return fromIndex;
    }

    public static int binaryFindFirst(ByteBuffer b, int minIndex, int keyIndex) {
        BufferUtils.rangeCheckInclusive(b.capacity(), minIndex, keyIndex);
        return BufferSearch.binaryFindFirst(b, minIndex, keyIndex, b.get(keyIndex));
    }

    private static int binaryFindFirst(ByteBuffer b, int minIndex, int fromIndex, byte key) {
        while (minIndex != fromIndex && b.get(fromIndex - 1) == key) {
            int rangeIndex;
            int range = 1;
            while (minIndex <= (rangeIndex = fromIndex - (range <<= 1)) && b.get(rangeIndex) == key) {
            }
            fromIndex -= range >> 1;
        }
        return fromIndex;
    }

    public static int binaryFindLast(ByteBuffer b, int maxIndex, int keyIndex) {
        BufferUtils.rangeCheck(b.capacity(), keyIndex, maxIndex);
        if (keyIndex == maxIndex) {
            return keyIndex;
        }
        return BufferSearch.binaryFindLast(b, keyIndex, maxIndex - 1, b.get(keyIndex));
    }

    private static int binaryFindLast(ByteBuffer b, int fromIndex, int maxIndex, byte key) {
        while (fromIndex != maxIndex && b.get(fromIndex + 1) == key) {
            int rangeIndex;
            int range = 1;
            while ((rangeIndex = fromIndex + (range <<= 1)) <= maxIndex && b.get(rangeIndex) == key) {
            }
            fromIndex += range >> 1;
        }
        return fromIndex;
    }

    public static int binaryFindFirst(FloatBuffer b, int minIndex, int keyIndex) {
        BufferUtils.rangeCheckInclusive(b.capacity(), minIndex, keyIndex);
        return BufferSearch.binaryFindFirst(b, minIndex, keyIndex, b.get(keyIndex));
    }

    private static int binaryFindFirst(FloatBuffer b, int minIndex, int fromIndex, float key) {
        while (minIndex != fromIndex && Float.compare(b.get(fromIndex - 1), key) == 0) {
            int rangeIndex;
            int range = 1;
            while (minIndex <= (rangeIndex = fromIndex - (range <<= 1)) && Float.compare(b.get(rangeIndex), key) == 0) {
            }
            fromIndex -= range >> 1;
        }
        return fromIndex;
    }

    public static int binaryFindLast(FloatBuffer b, int maxIndex, int keyIndex) {
        BufferUtils.rangeCheck(b.capacity(), keyIndex, maxIndex);
        if (keyIndex == maxIndex) {
            return keyIndex;
        }
        return BufferSearch.binaryFindLast(b, keyIndex, maxIndex - 1, b.get(keyIndex));
    }

    private static int binaryFindLast(FloatBuffer b, int fromIndex, int maxIndex, float key) {
        while (fromIndex != maxIndex && Float.compare(b.get(fromIndex + 1), key) == 0) {
            int rangeIndex;
            int range = 1;
            while ((rangeIndex = fromIndex + (range <<= 1)) <= maxIndex && Float.compare(b.get(rangeIndex), key) == 0) {
            }
            fromIndex += range >> 1;
        }
        return fromIndex;
    }

    public static int binaryFindFirst(DoubleBuffer b, int minIndex, int keyIndex) {
        BufferUtils.rangeCheckInclusive(b.capacity(), minIndex, keyIndex);
        return BufferSearch.binaryFindFirst(b, minIndex, keyIndex, b.get(keyIndex));
    }

    private static int binaryFindFirst(DoubleBuffer b, int minIndex, int fromIndex, double key) {
        while (minIndex != fromIndex && Double.compare(b.get(fromIndex - 1), key) == 0) {
            int rangeIndex;
            int range = 1;
            while (minIndex <= (rangeIndex = fromIndex - (range <<= 1)) && Double.compare(b.get(rangeIndex), key) == 0) {
            }
            fromIndex -= range >> 1;
        }
        return fromIndex;
    }

    public static int binaryFindLast(DoubleBuffer b, int maxIndex, int keyIndex) {
        BufferUtils.rangeCheck(b.capacity(), keyIndex, maxIndex);
        if (keyIndex == maxIndex) {
            return keyIndex;
        }
        return BufferSearch.binaryFindLast(b, keyIndex, maxIndex - 1, b.get(keyIndex));
    }

    private static int binaryFindLast(DoubleBuffer b, int fromIndex, int maxIndex, double key) {
        while (fromIndex != maxIndex && Double.compare(b.get(fromIndex + 1), key) == 0) {
            int rangeIndex;
            int range = 1;
            while ((rangeIndex = fromIndex + (range <<= 1)) <= maxIndex && Double.compare(b.get(rangeIndex), key) == 0) {
            }
            fromIndex += range >> 1;
        }
        return fromIndex;
    }

    public static int binarySearch(SmallIntBuffer b, int fromIndex, int toIndex, int key) {
        BufferUtils.rangeCheck(b.capacity(), fromIndex, toIndex);
        return BufferSearch.binarySearch0(b, fromIndex, toIndex, key);
    }

    private static int binarySearch0(SmallIntBuffer b, int fromIndex, int toIndex, int key) {
        int low = fromIndex;
        int high = toIndex - 1;
        while (low <= high) {
            int mid = low + high >>> 1;
            int midVal = b.get(mid);
            if (midVal < key) {
                low = mid + 1;
                continue;
            }
            if (midVal > key) {
                high = mid - 1;
                continue;
            }
            return mid;
        }
        return -(low + 1);
    }

    public static int binarySearch(SmallLongBuffer b, int fromIndex, int toIndex, long key) {
        BufferUtils.rangeCheck(b.capacity(), fromIndex, toIndex);
        return BufferSearch.binarySearch0(b, fromIndex, toIndex, key);
    }

    private static int binarySearch0(SmallLongBuffer b, int fromIndex, int toIndex, long key) {
        int low = fromIndex;
        int high = toIndex - 1;
        while (low <= high) {
            int mid = low + high >>> 1;
            long midVal = b.get(mid);
            if (midVal < key) {
                low = mid + 1;
                continue;
            }
            if (midVal > key) {
                high = mid - 1;
                continue;
            }
            return mid;
        }
        return -(low + 1);
    }

    public static int binarySearch(SmallShortBuffer b, int fromIndex, int toIndex, short key) {
        BufferUtils.rangeCheck(b.capacity(), fromIndex, toIndex);
        return BufferSearch.binarySearch0(b, fromIndex, toIndex, key);
    }

    private static int binarySearch0(SmallShortBuffer b, int fromIndex, int toIndex, short key) {
        int low = fromIndex;
        int high = toIndex - 1;
        while (low <= high) {
            int mid = low + high >>> 1;
            short midVal = b.get(mid);
            if (midVal < key) {
                low = mid + 1;
                continue;
            }
            if (midVal > key) {
                high = mid - 1;
                continue;
            }
            return mid;
        }
        return -(low + 1);
    }

    public static int binarySearch(SmallByteBuffer b, int fromIndex, int toIndex, byte key) {
        BufferUtils.rangeCheck(b.capacity(), fromIndex, toIndex);
        return BufferSearch.binarySearch0(b, fromIndex, toIndex, key);
    }

    private static int binarySearch0(SmallByteBuffer b, int fromIndex, int toIndex, byte key) {
        int low = fromIndex;
        int high = toIndex - 1;
        while (low <= high) {
            int mid = low + high >>> 1;
            byte midVal = b.get(mid);
            if (midVal < key) {
                low = mid + 1;
                continue;
            }
            if (midVal > key) {
                high = mid - 1;
                continue;
            }
            return mid;
        }
        return -(low + 1);
    }

    public static int binarySearch(SmallFloatBuffer b, int fromIndex, int toIndex, float key) {
        BufferUtils.rangeCheck(b.capacity(), fromIndex, toIndex);
        return BufferSearch.binarySearch0(b, fromIndex, toIndex, key);
    }

    private static int binarySearch0(SmallFloatBuffer b, int fromIndex, int toIndex, float key) {
        int low = fromIndex;
        int high = toIndex - 1;
        while (low <= high) {
            int keyBits;
            int mid = low + high >>> 1;
            float midVal = b.get(mid);
            if (midVal < key) {
                low = mid + 1;
                continue;
            }
            if (midVal > key) {
                high = mid - 1;
                continue;
            }
            int midBits = Float.floatToIntBits(midVal);
            if (midBits == (keyBits = Float.floatToIntBits(key))) {
                return mid;
            }
            if (midBits < keyBits) {
                low = mid + 1;
                continue;
            }
            high = mid - 1;
        }
        return -(low + 1);
    }

    public static int binarySearch(SmallDoubleBuffer b, int fromIndex, int toIndex, double key) {
        BufferUtils.rangeCheck(b.capacity(), fromIndex, toIndex);
        return BufferSearch.binarySearch0(b, fromIndex, toIndex, key);
    }

    private static int binarySearch0(SmallDoubleBuffer b, int fromIndex, int toIndex, double key) {
        int low = fromIndex;
        int high = toIndex - 1;
        while (low <= high) {
            long keyBits;
            int mid = low + high >>> 1;
            double midVal = b.get(mid);
            if (midVal < key) {
                low = mid + 1;
                continue;
            }
            if (midVal > key) {
                high = mid - 1;
                continue;
            }
            long midBits = Double.doubleToLongBits(midVal);
            if (midBits == (keyBits = Double.doubleToLongBits(key))) {
                return mid;
            }
            if (midBits < keyBits) {
                low = mid + 1;
                continue;
            }
            high = mid - 1;
        }
        return -(low + 1);
    }

    public static int binaryFindFirst(SmallIntBuffer b, int minIndex, int keyIndex) {
        BufferUtils.rangeCheckInclusive(b.capacity(), minIndex, keyIndex);
        return BufferSearch.binaryFindFirst(b, minIndex, keyIndex, b.get(keyIndex));
    }

    private static int binaryFindFirst(SmallIntBuffer b, int minIndex, int fromIndex, int key) {
        while (minIndex != fromIndex && b.get(fromIndex - 1) == key) {
            int rangeIndex;
            int range = 1;
            while (minIndex <= (rangeIndex = fromIndex - (range <<= 1)) && b.get(rangeIndex) == key) {
            }
            fromIndex -= range >> 1;
        }
        return fromIndex;
    }

    public static int binaryFindLast(SmallIntBuffer b, int maxIndex, int keyIndex) {
        BufferUtils.rangeCheck(b.capacity(), keyIndex, maxIndex);
        if (keyIndex == maxIndex) {
            return keyIndex;
        }
        return BufferSearch.binaryFindLast(b, keyIndex, maxIndex - 1, b.get(keyIndex));
    }

    private static int binaryFindLast(SmallIntBuffer b, int fromIndex, int maxIndex, int key) {
        while (fromIndex != maxIndex && b.get(fromIndex + 1) == key) {
            int rangeIndex;
            int range = 1;
            while ((rangeIndex = fromIndex + (range <<= 1)) <= maxIndex && b.get(rangeIndex) == key) {
            }
            fromIndex += range >> 1;
        }
        return fromIndex;
    }

    public static int binaryFindFirst(SmallLongBuffer b, int minIndex, int keyIndex) {
        BufferUtils.rangeCheckInclusive(b.capacity(), minIndex, keyIndex);
        return BufferSearch.binaryFindFirst(b, minIndex, keyIndex, b.get(keyIndex));
    }

    private static int binaryFindFirst(SmallLongBuffer b, int minIndex, int fromIndex, long key) {
        while (minIndex != fromIndex && b.get(fromIndex - 1) == key) {
            int rangeIndex;
            int range = 1;
            while (minIndex <= (rangeIndex = fromIndex - (range <<= 1)) && b.get(rangeIndex) == key) {
            }
            fromIndex -= range >> 1;
        }
        return fromIndex;
    }

    public static int binaryFindLast(SmallLongBuffer b, int maxIndex, int keyIndex) {
        BufferUtils.rangeCheck(b.capacity(), keyIndex, maxIndex);
        if (keyIndex == maxIndex) {
            return keyIndex;
        }
        return BufferSearch.binaryFindLast(b, keyIndex, maxIndex - 1, b.get(keyIndex));
    }

    private static int binaryFindLast(SmallLongBuffer b, int fromIndex, int maxIndex, long key) {
        while (fromIndex != maxIndex && b.get(fromIndex + 1) == key) {
            int rangeIndex;
            int range = 1;
            while ((rangeIndex = fromIndex + (range <<= 1)) <= maxIndex && b.get(rangeIndex) == key) {
            }
            fromIndex += range >> 1;
        }
        return fromIndex;
    }

    public static int binaryFindFirst(SmallShortBuffer b, int minIndex, int keyIndex) {
        BufferUtils.rangeCheckInclusive(b.capacity(), minIndex, keyIndex);
        return BufferSearch.binaryFindFirst(b, minIndex, keyIndex, b.get(keyIndex));
    }

    private static int binaryFindFirst(SmallShortBuffer b, int minIndex, int fromIndex, short key) {
        while (minIndex != fromIndex && b.get(fromIndex - 1) == key) {
            int rangeIndex;
            int range = 1;
            while (minIndex <= (rangeIndex = fromIndex - (range <<= 1)) && b.get(rangeIndex) == key) {
            }
            fromIndex -= range >> 1;
        }
        return fromIndex;
    }

    public static int binaryFindLast(SmallShortBuffer b, int maxIndex, int keyIndex) {
        BufferUtils.rangeCheck(b.capacity(), keyIndex, maxIndex);
        if (keyIndex == maxIndex) {
            return keyIndex;
        }
        return BufferSearch.binaryFindLast(b, keyIndex, maxIndex - 1, b.get(keyIndex));
    }

    private static int binaryFindLast(SmallShortBuffer b, int fromIndex, int maxIndex, short key) {
        while (fromIndex != maxIndex && b.get(fromIndex + 1) == key) {
            int rangeIndex;
            int range = 1;
            while ((rangeIndex = fromIndex + (range <<= 1)) <= maxIndex && b.get(rangeIndex) == key) {
            }
            fromIndex += range >> 1;
        }
        return fromIndex;
    }

    public static int binaryFindFirst(SmallByteBuffer b, int minIndex, int keyIndex) {
        BufferUtils.rangeCheckInclusive(b.capacity(), minIndex, keyIndex);
        return BufferSearch.binaryFindFirst(b, minIndex, keyIndex, b.get(keyIndex));
    }

    private static int binaryFindFirst(SmallByteBuffer b, int minIndex, int fromIndex, byte key) {
        while (minIndex != fromIndex && b.get(fromIndex - 1) == key) {
            int rangeIndex;
            int range = 1;
            while (minIndex <= (rangeIndex = fromIndex - (range <<= 1)) && b.get(rangeIndex) == key) {
            }
            fromIndex -= range >> 1;
        }
        return fromIndex;
    }

    public static int binaryFindLast(SmallByteBuffer b, int maxIndex, int keyIndex) {
        BufferUtils.rangeCheck(b.capacity(), keyIndex, maxIndex);
        if (keyIndex == maxIndex) {
            return keyIndex;
        }
        return BufferSearch.binaryFindLast(b, keyIndex, maxIndex - 1, b.get(keyIndex));
    }

    private static int binaryFindLast(SmallByteBuffer b, int fromIndex, int maxIndex, byte key) {
        while (fromIndex != maxIndex && b.get(fromIndex + 1) == key) {
            int rangeIndex;
            int range = 1;
            while ((rangeIndex = fromIndex + (range <<= 1)) <= maxIndex && b.get(rangeIndex) == key) {
            }
            fromIndex += range >> 1;
        }
        return fromIndex;
    }

    public static int binaryFindFirst(SmallFloatBuffer b, int minIndex, int keyIndex) {
        BufferUtils.rangeCheckInclusive(b.capacity(), minIndex, keyIndex);
        return BufferSearch.binaryFindFirst(b, minIndex, keyIndex, b.get(keyIndex));
    }

    private static int binaryFindFirst(SmallFloatBuffer b, int minIndex, int fromIndex, float key) {
        while (minIndex != fromIndex && Float.compare(b.get(fromIndex - 1), key) == 0) {
            int rangeIndex;
            int range = 1;
            while (minIndex <= (rangeIndex = fromIndex - (range <<= 1)) && Float.compare(b.get(rangeIndex), key) == 0) {
            }
            fromIndex -= range >> 1;
        }
        return fromIndex;
    }

    public static int binaryFindLast(SmallFloatBuffer b, int maxIndex, int keyIndex) {
        BufferUtils.rangeCheck(b.capacity(), keyIndex, maxIndex);
        if (keyIndex == maxIndex) {
            return keyIndex;
        }
        return BufferSearch.binaryFindLast(b, keyIndex, maxIndex - 1, b.get(keyIndex));
    }

    private static int binaryFindLast(SmallFloatBuffer b, int fromIndex, int maxIndex, float key) {
        while (fromIndex != maxIndex && Float.compare(b.get(fromIndex + 1), key) == 0) {
            int rangeIndex;
            int range = 1;
            while ((rangeIndex = fromIndex + (range <<= 1)) <= maxIndex && Float.compare(b.get(rangeIndex), key) == 0) {
            }
            fromIndex += range >> 1;
        }
        return fromIndex;
    }

    public static int binaryFindFirst(SmallDoubleBuffer b, int minIndex, int keyIndex) {
        BufferUtils.rangeCheckInclusive(b.capacity(), minIndex, keyIndex);
        return BufferSearch.binaryFindFirst(b, minIndex, keyIndex, b.get(keyIndex));
    }

    private static int binaryFindFirst(SmallDoubleBuffer b, int minIndex, int fromIndex, double key) {
        while (minIndex != fromIndex && Double.compare(b.get(fromIndex - 1), key) == 0) {
            int rangeIndex;
            int range = 1;
            while (minIndex <= (rangeIndex = fromIndex - (range <<= 1)) && Double.compare(b.get(rangeIndex), key) == 0) {
            }
            fromIndex -= range >> 1;
        }
        return fromIndex;
    }

    public static int binaryFindLast(SmallDoubleBuffer b, int maxIndex, int keyIndex) {
        BufferUtils.rangeCheck(b.capacity(), keyIndex, maxIndex);
        if (keyIndex == maxIndex) {
            return keyIndex;
        }
        return BufferSearch.binaryFindLast(b, keyIndex, maxIndex - 1, b.get(keyIndex));
    }

    private static int binaryFindLast(SmallDoubleBuffer b, int fromIndex, int maxIndex, double key) {
        while (fromIndex != maxIndex && Double.compare(b.get(fromIndex + 1), key) == 0) {
            int rangeIndex;
            int range = 1;
            while ((rangeIndex = fromIndex + (range <<= 1)) <= maxIndex && Double.compare(b.get(rangeIndex), key) == 0) {
            }
            fromIndex += range >> 1;
        }
        return fromIndex;
    }

    private static /* synthetic */ BufferSearch[] $values() {
        return new BufferSearch[0];
    }

    static {
        $VALUES = BufferSearch.$values();
    }
}

